/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.model.Body;
import de.gematik.test.tiger.mockserver.model.MediaType;
import java.nio.charset.Charset;
import java.util.Objects;

public abstract class BodyWithContentType<T>
extends Body<T> {
    private int hashCode;
    protected final MediaType contentType;

    public BodyWithContentType(Body.Type type, MediaType contentType) {
        super(type);
        this.contentType = contentType;
    }

    @JsonIgnore
    Charset determineCharacterSet(MediaType mediaType, Charset defaultCharset) {
        Charset charset;
        if (mediaType != null && (charset = mediaType.getCharset()) != null) {
            return charset;
        }
        return defaultCharset;
    }

    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        return this.determineCharacterSet(this.contentType, defaultIfNotSet);
    }

    public String getContentType() {
        return this.contentType != null ? this.contentType.toString() : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BodyWithContentType that = (BodyWithContentType)o;
        return Objects.equals(this.contentType, that.contentType);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.contentType);
        }
        return this.hashCode;
    }
}

