/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.model.Body;
import de.gematik.test.tiger.mockserver.model.BodyWithContentType;
import de.gematik.test.tiger.mockserver.model.Not;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public abstract class Body<T>
extends Not {
    private int hashCode;
    private final Type type;
    private Boolean optional;

    public Body(Type type) {
        this.type = type;
    }

    public Type getType() {
        return this.type;
    }

    public Boolean getOptional() {
        return this.optional;
    }

    public Body<T> withOptional(Boolean optional) {
        this.optional = optional;
        return this;
    }

    public abstract T getValue();

    @JsonIgnore
    public byte[] getRawBytes() {
        return this.toString().getBytes(StandardCharsets.UTF_8);
    }

    @JsonIgnore
    public Charset getCharset(Charset defaultIfNotSet) {
        if (this instanceof BodyWithContentType) {
            return this.getCharset(defaultIfNotSet);
        }
        return defaultIfNotSet;
    }

    public String getContentType() {
        if (this instanceof BodyWithContentType) {
            return this.getContentType();
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Body body = (Body)o;
        return this.type == body.type && Objects.equals(this.optional, body.optional);
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.type, this.optional);
        }
        return this.hashCode;
    }
}

