/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.model.Body;
import de.gematik.test.tiger.mockserver.model.BodyWithContentType;
import de.gematik.test.tiger.mockserver.model.MediaType;
import java.util.Arrays;
import java.util.Base64;
import lombok.Generated;

public class BinaryBody
extends BodyWithContentType<byte[]> {
    private final byte[] bytes;

    public BinaryBody(byte[] bytes) {
        this(bytes, null);
    }

    public BinaryBody(byte[] bytes, MediaType contentType) {
        super(Body.Type.BINARY, contentType);
        this.bytes = bytes;
    }

    public static BinaryBody binary(byte[] body) {
        return new BinaryBody(body);
    }

    public static BinaryBody binary(byte[] body, MediaType contentType) {
        return new BinaryBody(body, contentType);
    }

    public byte[] getValue() {
        return this.bytes;
    }

    @JsonIgnore
    public byte[] getRawBytes() {
        return this.bytes;
    }

    public String toString() {
        if (this.bytes == null) {
            return "";
        }
        if (this.bytes.length > 1000) {
            return Base64.getEncoder().encodeToString(Arrays.copyOfRange(this.bytes, 0, 1000)) + "...";
        }
        return Base64.getEncoder().encodeToString(this.bytes);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryBody)) {
            return false;
        }
        BinaryBody other = (BinaryBody)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        return Arrays.equals(this.bytes, other.bytes);
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BinaryBody;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.bytes);
        return result;
    }
}

