/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mappers;

import de.gematik.test.tiger.mockserver.codec.BodyDecoderEncoder;
import de.gematik.test.tiger.mockserver.model.Cookies;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.Headers;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.model.KeyAndValue;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import java.util.Set;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FullHttpResponseToMockServerHttpResponse {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FullHttpResponseToMockServerHttpResponse.class);
    private final BodyDecoderEncoder bodyDecoderEncoder = new BodyDecoderEncoder();

    public HttpResponse mapFullHttpResponseToMockServerResponse(FullHttpResponse fullHttpResponse) {
        HttpResponse httpResponse = new HttpResponse();
        try {
            if (fullHttpResponse != null) {
                if (fullHttpResponse.decoderResult().isFailure()) {
                    log.error("exception decoding response ", fullHttpResponse.decoderResult().cause());
                }
                this.setStatusCode(httpResponse, fullHttpResponse);
                this.setHeaders(httpResponse, fullHttpResponse);
                this.setCookies(httpResponse);
                this.setBody(httpResponse, fullHttpResponse);
            }
        }
        catch (RuntimeException e) {
            log.error("exception decoding response {}", (Object)fullHttpResponse, (Object)e);
        }
        return httpResponse;
    }

    private void setStatusCode(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        HttpResponseStatus status = fullHttpResponse.status();
        httpResponse.withStatusCode(Integer.valueOf(status.code()));
        httpResponse.withReasonPhrase(status.reasonPhrase());
    }

    private void setHeaders(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        Set headerNames = fullHttpResponse.headers().names();
        if (!headerNames.isEmpty()) {
            Headers headers = new Headers(new Header[0]);
            for (String headerName : headerNames) {
                headers.withEntry(headerName, fullHttpResponse.headers().getAll(headerName));
            }
            httpResponse.withHeaders(headers);
        }
    }

    private void setCookies(HttpResponse httpResponse) {
        Cookies cookies = new Cookies(new de.gematik.test.tiger.mockserver.model.Cookie[0]);
        for (Header header : httpResponse.getHeaderList()) {
            if (header.getName().equalsIgnoreCase("Set-Cookie")) {
                for (String cookieHeader : header.getValues()) {
                    Cookie httpCookie = ClientCookieDecoder.LAX.decode(cookieHeader);
                    String name = httpCookie.name().trim();
                    String value = httpCookie.value() != null ? httpCookie.value().trim() : "";
                    cookies.withEntry((KeyAndValue)new de.gematik.test.tiger.mockserver.model.Cookie(name, value));
                }
            }
            if (!header.getName().equalsIgnoreCase("Cookie")) continue;
            for (String cookieHeader : header.getValues()) {
                for (Cookie httpCookie : ServerCookieDecoder.LAX.decode(cookieHeader)) {
                    String name = httpCookie.name().trim();
                    String value = httpCookie.value() != null ? httpCookie.value().trim() : "";
                    cookies.withEntry((KeyAndValue)new de.gematik.test.tiger.mockserver.model.Cookie(name, value));
                }
            }
        }
        if (!cookies.isEmpty()) {
            httpResponse.withCookies(cookies);
        }
    }

    private void setBody(HttpResponse httpResponse, FullHttpResponse fullHttpResponse) {
        httpResponse.withBody(this.bodyDecoderEncoder.byteBufToBody(fullHttpResponse.content(), fullHttpResponse.headers().get((CharSequence)HttpHeaderNames.CONTENT_TYPE)));
    }
}

