/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import com.google.common.collect.ImmutableMap;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.filters.HopByHopHeaderFilter;
import de.gematik.test.tiger.mockserver.httpclient.HttpClientInitializer;
import de.gematik.test.tiger.mockserver.httpclient.SocketCommunicationException;
import de.gematik.test.tiger.mockserver.httpclient.SocketConnectionException;
import de.gematik.test.tiger.mockserver.model.BinaryMessage;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.model.Message;
import de.gematik.test.tiger.mockserver.model.Protocol;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyHttpClient {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyHttpClient.class);
    static final AttributeKey<Boolean> SECURE = AttributeKey.valueOf((String)"SECURE");
    static final AttributeKey<InetSocketAddress> REMOTE_SOCKET = AttributeKey.valueOf((String)"REMOTE_SOCKET");
    static final AttributeKey<CompletableFuture<Message>> RESPONSE_FUTURE = AttributeKey.valueOf((String)"RESPONSE_FUTURE");
    static final AttributeKey<Boolean> ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE = AttributeKey.valueOf((String)"ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE");
    private static final HopByHopHeaderFilter hopByHopHeaderFilter = new HopByHopHeaderFilter();
    private final Configuration configuration;
    private final EventLoopGroup eventLoopGroup;
    private final Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations;
    private final NettySslContextFactory nettySslContextFactory;

    public NettyHttpClient(Configuration configuration, EventLoopGroup eventLoopGroup, List<ProxyConfiguration> proxyConfigurations, NettySslContextFactory nettySslContextFactory) {
        this.configuration = configuration;
        this.eventLoopGroup = eventLoopGroup;
        this.proxyConfigurations = proxyConfigurations != null ? proxyConfigurations.stream().collect(Collectors.toMap(ProxyConfiguration::getType, proxyConfiguration -> proxyConfiguration)) : ImmutableMap.of();
        this.nettySslContextFactory = nettySslContextFactory;
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequest httpRequest) throws SocketConnectionException {
        return this.sendRequest(httpRequest, httpRequest.socketAddressFromHostHeader());
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress) throws SocketConnectionException {
        return this.sendRequest(httpRequest, remoteAddress, this.configuration.socketConnectionTimeoutInMillis());
    }

    public CompletableFuture<HttpResponse> sendRequest(HttpRequest httpRequest, @Nullable InetSocketAddress remoteAddress, Long connectionTimeoutMillis) throws SocketConnectionException {
        if (!this.eventLoopGroup.isShuttingDown()) {
            if (this.proxyConfigurations != null && !Boolean.TRUE.equals(httpRequest.isSecure()) && this.proxyConfigurations.containsKey(ProxyConfiguration.Type.HTTP) && this.isHostNotOnNoProxyHostList(remoteAddress)) {
                ProxyConfiguration proxyConfiguration = (ProxyConfiguration)this.proxyConfigurations.get(ProxyConfiguration.Type.HTTP);
                remoteAddress = proxyConfiguration.getProxyAddress();
                proxyConfiguration.addProxyAuthenticationHeader(httpRequest);
            } else if (remoteAddress == null) {
                remoteAddress = httpRequest.socketAddressFromHostHeader();
            }
            if (Protocol.HTTP_2.equals((Object)httpRequest.getProtocol()) && !Boolean.TRUE.equals(httpRequest.isSecure())) {
                log.warn("HTTP2 requires ALPN but request is not secure (i.e. TLS) so protocol changed to HTTP1");
                httpRequest.setProtocol(Protocol.HTTP_1_1);
            }
            CompletableFuture<HttpResponse> httpResponseFuture = new CompletableFuture<HttpResponse>();
            CompletableFuture responseFuture = new CompletableFuture();
            Protocol httpProtocol = httpRequest.getProtocol() != null ? httpRequest.getProtocol() : Protocol.HTTP_1_1;
            HttpClientInitializer clientInitializer = new HttpClientInitializer(this.proxyConfigurations, this.nettySslContextFactory, httpProtocol);
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectionTimeoutMillis != null ? Integer.valueOf(connectionTimeoutMillis.intValue()) : null)).attr(SECURE, (Object)(httpRequest.isSecure() != null && httpRequest.isSecure() != false ? 1 : 0))).attr(REMOTE_SOCKET, (Object)remoteAddress)).attr(RESPONSE_FUTURE, responseFuture)).attr(ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE, (Object)true)).handler((ChannelHandler)clientInitializer)).connect((SocketAddress)remoteAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    clientInitializer.whenComplete((protocol, throwable) -> {
                        if (throwable != null) {
                            httpResponseFuture.completeExceptionally((Throwable)throwable);
                        } else {
                            future.channel().writeAndFlush((Object)httpRequest);
                        }
                    });
                } else {
                    httpResponseFuture.completeExceptionally(future.cause());
                }
            }));
            responseFuture.whenComplete((message, throwable) -> {
                if (throwable == null) {
                    if (message != null) {
                        httpResponseFuture.complete((HttpResponse)message);
                    } else {
                        httpResponseFuture.complete(HttpResponse.response());
                    }
                } else {
                    httpResponseFuture.completeExceptionally((Throwable)throwable);
                }
            });
            return httpResponseFuture;
        }
        throw new IllegalStateException("Request sent after client has been stopped - the event loop has been shutdown so it is not possible to send a request");
    }

    public CompletableFuture<BinaryMessage> sendRequest(BinaryMessage binaryRequest, boolean isSecure, InetSocketAddress remoteAddress, Long connectionTimeoutMillis) throws SocketConnectionException {
        if (!this.eventLoopGroup.isShuttingDown()) {
            if (this.proxyConfigurations != null && !isSecure && this.proxyConfigurations.containsKey(ProxyConfiguration.Type.HTTP)) {
                remoteAddress = ((ProxyConfiguration)this.proxyConfigurations.get(ProxyConfiguration.Type.HTTP)).getProxyAddress();
            } else if (remoteAddress == null) {
                throw new IllegalArgumentException("Remote address cannot be null");
            }
            CompletableFuture<BinaryMessage> binaryResponseFuture = new CompletableFuture<BinaryMessage>();
            CompletableFuture responseFuture = new CompletableFuture();
            ((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.eventLoopGroup)).channel(NioSocketChannel.class)).option(ChannelOption.AUTO_READ, (Object)true)).option(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT)).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, connectionTimeoutMillis != null ? Integer.valueOf(connectionTimeoutMillis.intValue()) : null)).attr(SECURE, (Object)isSecure)).attr(REMOTE_SOCKET, (Object)remoteAddress)).attr(RESPONSE_FUTURE, responseFuture)).attr(ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE, (Object)(!this.configuration.forwardBinaryRequestsWithoutWaitingForResponse() ? 1 : 0))).handler((ChannelHandler)new HttpClientInitializer(this.proxyConfigurations, this.nettySslContextFactory, null))).connect((SocketAddress)remoteAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    if (log.isDebugEnabled()) {
                        log.debug("sending bytes hex {} to {}", (Object)ByteBufUtil.hexDump((byte[])binaryRequest.getBytes()), future.channel().attr(REMOTE_SOCKET).get());
                    }
                    future.channel().writeAndFlush((Object)Unpooled.copiedBuffer((byte[])binaryRequest.getBytes()));
                } else {
                    binaryResponseFuture.completeExceptionally(future.cause());
                }
            }));
            responseFuture.whenComplete((message, throwable) -> {
                if (throwable == null) {
                    binaryResponseFuture.complete((BinaryMessage)message);
                } else {
                    throwable.printStackTrace();
                    binaryResponseFuture.completeExceptionally((Throwable)throwable);
                }
            });
            return binaryResponseFuture;
        }
        throw new IllegalStateException("Request sent after client has been stopped - the event loop has been shutdown so it is not possible to send a request");
    }

    public HttpResponse sendRequest(HttpRequest httpRequest, long timeout, TimeUnit unit, boolean ignoreErrors) {
        HttpResponse httpResponse;
        block9: {
            httpResponse = null;
            try {
                httpResponse = (HttpResponse)this.sendRequest(httpRequest).get(timeout, unit);
            }
            catch (TimeoutException e) {
                if (!ignoreErrors) {
                    throw new SocketCommunicationException("Response was not received from MockServer after " + this.configuration.maxSocketTimeoutInMillis() + " milliseconds, to wait longer please use \"mockserver.maxSocketTimeout\" system property or ConfigurationProperties.maxSocketTimeout(long milliseconds)", e.getCause());
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                if (ignoreErrors) break block9;
                Throwable cause = ex.getCause();
                if (cause instanceof SocketConnectionException) {
                    throw (SocketConnectionException)cause;
                }
                if (cause instanceof ConnectException) {
                    throw new SocketConnectionException("Unable to connect to socket " + httpRequest.socketAddressFromHostHeader(), cause);
                }
                if (cause instanceof UnknownHostException) {
                    throw new SocketConnectionException("Unable to resolve host " + httpRequest.socketAddressFromHostHeader(), cause);
                }
                if (cause instanceof IOException) {
                    throw new SocketConnectionException(cause.getMessage(), cause);
                }
                if (cause instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Exception while sending request - " + ex.getMessage(), ex);
                }
                throw new RuntimeException("Exception while sending request - " + ex.getMessage(), ex);
            }
        }
        return httpResponse;
    }

    private boolean isHostNotOnNoProxyHostList(InetSocketAddress remoteAddress) {
        if (remoteAddress == null || StringUtils.isBlank((CharSequence)this.configuration.noProxyHosts())) {
            return true;
        }
        return Stream.of(this.configuration.noProxyHosts().split(",")).map(String::trim).map(host -> {
            try {
                return InetAddress.getByName(host);
            }
            catch (UnknownHostException e) {
                return null;
            }
        }).filter(Objects::nonNull).noneMatch(remoteAddress.getAddress()::equals);
    }
}

