/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.test.tiger.mockserver.codec.MockServerBinaryClientCodec;
import de.gematik.test.tiger.mockserver.codec.MockServerHttpClientCodec;
import de.gematik.test.tiger.mockserver.httpclient.Http2SettingsHandler;
import de.gematik.test.tiger.mockserver.httpclient.HttpClientConnectionErrorHandler;
import de.gematik.test.tiger.mockserver.httpclient.HttpClientHandler;
import de.gematik.test.tiger.mockserver.httpclient.HttpOrHttp2Initializer;
import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.model.Protocol;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DelegatingDecompressorFrameListener;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameLogger;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandlerBuilder;
import io.netty.handler.codec.http2.InboundHttp2ToHttpAdapterBuilder;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class HttpClientInitializer
extends ChannelInitializer<SocketChannel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClientInitializer.class);
    private final Protocol httpProtocol;
    private final HttpClientConnectionErrorHandler httpClientConnectionHandler;
    private final CompletableFuture<Protocol> protocolFuture;
    private final HttpClientHandler httpClientHandler;
    private final Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations;
    private final NettySslContextFactory nettySslContextFactory;

    HttpClientInitializer(Map<ProxyConfiguration.Type, ProxyConfiguration> proxyConfigurations, NettySslContextFactory nettySslContextFactory, Protocol httpProtocol) {
        this.proxyConfigurations = proxyConfigurations;
        this.httpProtocol = httpProtocol;
        this.protocolFuture = new CompletableFuture();
        this.httpClientHandler = new HttpClientHandler();
        this.httpClientConnectionHandler = new HttpClientConnectionErrorHandler();
        this.nettySslContextFactory = nettySslContextFactory;
    }

    public void whenComplete(BiConsumer<? super Protocol, ? super Throwable> action) {
        this.protocolFuture.whenComplete(action);
    }

    public void initChannel(SocketChannel channel) {
        boolean secure;
        ChannelPipeline pipeline = channel.pipeline();
        boolean bl = secure = channel.attr(NettyHttpClient.SECURE) != null && channel.attr(NettyHttpClient.SECURE).get() != null && (Boolean)channel.attr(NettyHttpClient.SECURE).get() != false;
        if (this.proxyConfigurations != null) {
            if (secure && this.proxyConfigurations.containsKey(ProxyConfiguration.Type.HTTPS)) {
                proxyConfiguration = (ProxyConfiguration)this.proxyConfigurations.get(ProxyConfiguration.Type.HTTPS);
                if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.getUsername()) && StringUtils.isNotBlank((CharSequence)proxyConfiguration.getPassword())) {
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress(), proxyConfiguration.getUsername(), proxyConfiguration.getPassword())});
                } else {
                    pipeline.addLast(new ChannelHandler[]{new HttpProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress())});
                }
            } else if (this.proxyConfigurations.containsKey(ProxyConfiguration.Type.SOCKS5)) {
                proxyConfiguration = (ProxyConfiguration)this.proxyConfigurations.get(ProxyConfiguration.Type.SOCKS5);
                if (StringUtils.isNotBlank((CharSequence)proxyConfiguration.getUsername()) && StringUtils.isNotBlank((CharSequence)proxyConfiguration.getPassword())) {
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress(), proxyConfiguration.getUsername(), proxyConfiguration.getPassword())});
                } else {
                    pipeline.addLast(new ChannelHandler[]{new Socks5ProxyHandler((SocketAddress)proxyConfiguration.getProxyAddress())});
                }
            }
        }
        pipeline.addLast(new ChannelHandler[]{this.httpClientConnectionHandler});
        if (secure) {
            InetSocketAddress remoteAddress = (InetSocketAddress)channel.attr(NettyHttpClient.REMOTE_SOCKET).get();
            pipeline.addLast(new ChannelHandler[]{this.nettySslContextFactory.createClientSslContext(this.httpProtocol != null && this.httpProtocol.equals((Object)Protocol.HTTP_2)).newHandler(channel.alloc(), remoteAddress.getHostName(), remoteAddress.getPort())});
        }
        if (this.httpProtocol == null) {
            this.configureBinaryPipeline(pipeline);
        } else if (secure) {
            pipeline.addLast(new ChannelHandler[]{new HttpOrHttp2Initializer(arg_0 -> this.configureHttp1Pipeline(arg_0), arg_0 -> this.configureHttp2Pipeline(arg_0))});
        } else {
            this.configureHttp1Pipeline(pipeline);
        }
    }

    private void configureHttp1Pipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpContentDecompressor()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(Integer.MAX_VALUE)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpClientCodec(this.proxyConfigurations)});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
        this.protocolFuture.complete(Protocol.HTTP_1_1);
    }

    private void configureHttp2Pipeline(ChannelPipeline pipeline) {
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        HttpToHttp2ConnectionHandlerBuilder http2ConnectionHandlerBuilder = new HttpToHttp2ConnectionHandlerBuilder().frameListener((Http2FrameListener)new DelegatingDecompressorFrameListener((Http2Connection)connection, (Http2FrameListener)new InboundHttp2ToHttpAdapterBuilder((Http2Connection)connection).maxContentLength(Integer.MAX_VALUE).propagateSettings(true).validateHttpHeaders(false).build())).connection((Http2Connection)connection).flushPreface(true);
        if (log.isTraceEnabled()) {
            http2ConnectionHandlerBuilder.frameLogger(new Http2FrameLogger(LogLevel.TRACE, HttpClientHandler.class.getName()));
        }
        pipeline.addLast(new ChannelHandler[]{http2ConnectionHandlerBuilder.build()});
        pipeline.addLast(new ChannelHandler[]{new Http2SettingsHandler(this.protocolFuture)});
        pipeline.addLast(new ChannelHandler[]{new MockServerHttpClientCodec(this.proxyConfigurations)});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
    }

    private void configureBinaryPipeline(ChannelPipeline pipeline) {
        pipeline.addLast(new ChannelHandler[]{new MockServerBinaryClientCodec()});
        pipeline.addLast(new ChannelHandler[]{this.httpClientHandler});
        this.protocolFuture.complete(null);
    }
}

