/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.model.Message;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.SSLException;
import org.apache.commons.lang3.StringUtils;

@ChannelHandler.Sharable
public class HttpClientHandler
extends SimpleChannelInboundHandler<Message> {
    private final List<String> connectionClosedStrings = Arrays.asList("Broken pipe", "(broken pipe)", "Connection reset");

    HttpClientHandler() {
        super(false);
    }

    public void channelRead0(ChannelHandlerContext ctx, Message response) {
        ((CompletableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).complete(response);
        ctx.close();
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.isNotSslException(cause) && this.isNotConnectionReset(cause)) {
            cause.printStackTrace();
        }
        ((CompletableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get()).completeExceptionally(cause);
        ctx.close();
    }

    private boolean isNotSslException(Throwable cause) {
        return !(cause.getCause() instanceof SSLException) && !(cause instanceof DecoderException | cause instanceof NotSslRecordException);
    }

    private boolean isNotConnectionReset(Throwable cause) {
        return this.connectionClosedStrings.stream().noneMatch(connectionClosedString -> StringUtils.isNotBlank((CharSequence)cause.getMessage()) && cause.getMessage().contains((CharSequence)connectionClosedString) || cause.getCause() != null && StringUtils.isNotBlank((CharSequence)cause.getCause().getMessage()) && cause.getCause().getMessage().contains((CharSequence)connectionClosedString));
    }
}

