/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.httpclient;

import de.gematik.test.tiger.mockserver.httpclient.NettyHttpClient;
import de.gematik.test.tiger.mockserver.httpclient.SocketConnectionException;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.concurrent.CompletableFuture;

@ChannelHandler.Sharable
public class HttpClientConnectionErrorHandler
extends ChannelDuplexHandler {
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        CompletableFuture responseFuture = (CompletableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get();
        if (responseFuture != null && !responseFuture.isDone()) {
            if (((Boolean)ctx.channel().attr(NettyHttpClient.ERROR_IF_CHANNEL_CLOSED_WITHOUT_RESPONSE).get()).booleanValue()) {
                responseFuture.completeExceptionally((Throwable)new SocketConnectionException("Channel handler removed before valid response has been received"));
            } else {
                responseFuture.complete(null);
            }
        }
        super.handlerRemoved(ctx);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        CompletableFuture responseFuture = (CompletableFuture)ctx.channel().attr(NettyHttpClient.RESPONSE_FUTURE).get();
        if (!responseFuture.isDone()) {
            responseFuture.completeExceptionally(cause);
        }
        super.exceptionCaught(ctx, cause);
    }
}

