/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.formatting;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import de.gematik.test.tiger.mockserver.character.Character;
import io.netty.buffer.ByteBufUtil;
import java.util.HashMap;
import java.util.Map;

/*
 * Exception performing whole class analysis ignored.
 */
public class StringFormatter {
    private static final Map<Integer, String> INDENTS = new HashMap();
    private static final Splitter fixedLengthSplitter = Splitter.fixedLength((int)64);
    private static final Joiner newLineJoiner = Joiner.on((String)Character.NEW_LINE);

    public static StringBuilder[] indentAndToString(Object ... objects) {
        return StringFormatter.indentAndToString((int)1, (Object[])objects);
    }

    public static StringBuilder[] indentAndToString(int indent, Object ... objects) {
        StringBuilder[] indentedObjects = new StringBuilder[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            indentedObjects[i] = new StringBuilder(Character.NEW_LINE).append(Character.NEW_LINE).append(String.valueOf(objects[i]).replaceAll("(?m)^", (String)INDENTS.get(indent))).append(Character.NEW_LINE);
        }
        return indentedObjects;
    }

    public static String formatLogMessage(String message, Object ... arguments) {
        return StringFormatter.formatLogMessage((int)0, (String)message, (Object[])arguments);
    }

    public static String formatLogMessage(int indent, String message, Object ... arguments) {
        StringBuilder logMessage = new StringBuilder();
        StringBuilder[] formattedArguments = StringFormatter.indentAndToString((int)(indent + 1), (Object[])arguments);
        String[] messageParts = message.split("\\{}");
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            logMessage.append((String)INDENTS.get(indent)).append(messageParts[messagePartIndex]);
            if (formattedArguments.length > 0 && formattedArguments.length > messagePartIndex) {
                logMessage.append((CharSequence)formattedArguments[messagePartIndex]);
            }
            if (messagePartIndex >= messageParts.length - 1) continue;
            logMessage.append(Character.NEW_LINE);
            if (messageParts[messagePartIndex + 1].startsWith(" ")) continue;
            logMessage.append(" ");
        }
        return logMessage.toString();
    }

    public static String formatLogMessage(String[] messageParts, Object ... arguments) {
        StringBuilder logMessage = new StringBuilder();
        StringBuilder[] formattedArguments = StringFormatter.indentAndToString((Object[])arguments);
        for (int messagePartIndex = 0; messagePartIndex < messageParts.length; ++messagePartIndex) {
            logMessage.append(messageParts[messagePartIndex]);
            if (formattedArguments.length <= 0 || formattedArguments.length <= messagePartIndex) continue;
            logMessage.append((CharSequence)formattedArguments[messagePartIndex]);
        }
        return logMessage.toString();
    }

    public static String formatBytes(byte[] bytes) {
        return newLineJoiner.join(fixedLengthSplitter.split((CharSequence)ByteBufUtil.hexDump((byte[])bytes)));
    }

    static {
        INDENTS.put(0, "");
        INDENTS.put(1, "  ");
        INDENTS.put(2, "    ");
        INDENTS.put(3, "      ");
        INDENTS.put(4, "        ");
    }
}

