/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.decorator.AddBundledServerNamesModifier;
import de.gematik.rbellogger.data.decorator.MessageMetadataModifier;
import de.gematik.rbellogger.data.decorator.ServerNameFromHostname;
import de.gematik.rbellogger.data.decorator.ServernameFromProcessAndPortSupplier;
import de.gematik.rbellogger.data.decorator.ServernameFromSpyPortMapping;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelListFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelNoteFacet;
import de.gematik.rbellogger.data.facet.RbelUriFacet;
import de.gematik.rbellogger.data.facet.RbelUriParameterFacet;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpOverrideForwardedRequest;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.model.MockserverX509CertificateWrapper;
import de.gematik.test.tiger.mockserver.model.Parameters;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.certificate.TlsFacet;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyModificationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyParsingException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTigerRouteCallback
implements ExpectationForwardAndResponseCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTigerRouteCallback.class);
    public static final String LOCATION_HEADER_KEY = "Location";
    private final TigerProxy tigerProxy;
    private final TigerRoute tigerRoute;
    private final MessageMetadataModifier modifierBasedOnProcessAndPort;
    private final MessageMetadataModifier modifierBasedOnHostname;
    private final MessageMetadataModifier modifierBasedOnlyOnPort;
    private Map<String, CompletableFuture<RbelElement>> requestLogIdToParsingFuture = new ConcurrentHashMap<String, CompletableFuture<RbelElement>>();

    protected AbstractTigerRouteCallback(TigerProxy tigerProxy, TigerRoute tigerRoute) {
        this.tigerProxy = tigerProxy;
        this.tigerRoute = tigerRoute;
        this.modifierBasedOnProcessAndPort = AddBundledServerNamesModifier.createModifier((Function)new ServernameFromProcessAndPortSupplier());
        this.modifierBasedOnHostname = AddBundledServerNamesModifier.createModifier((Function)new ServerNameFromHostname());
        this.modifierBasedOnlyOnPort = AddBundledServerNamesModifier.createModifier((Function)new ServernameFromSpyPortMapping());
    }

    public void applyModifications(HttpRequest request) {
        if (!this.tigerProxy.getModifications().isEmpty()) {
            this.parseMessageAndApplyModifications(request);
        }
    }

    public void parseMessageAndApplyModifications(HttpRequest request) {
        RbelElement requestElement = this.tigerProxy.getRbelLogger().getRbelConverter().convertElement(this.tigerProxy.getMockServerToRbelConverter().requestToRbelMessage(request));
        RbelElement modifiedRequest = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(requestElement);
        if (modifiedRequest == requestElement) {
            return;
        }
        request.withBody(this.extractSafe(modifiedRequest, "$.body").getRawContent());
        for (RbelElement modifiedHeader : modifiedRequest.findRbelPathMembers("$.header.*")) {
            request = request.replaceHeader(Header.header((String)modifiedHeader.getKey().orElseThrow(), modifiedHeader.getRawStringContent()));
        }
        RbelUriFacet uriFacet = (RbelUriFacet)this.extractSafe(modifiedRequest, "$.path").getFacetOrFail(RbelUriFacet.class);
        request.setPath(uriFacet.getBasicPathString());
        this.clearExistingQueryParameters(request);
        this.addAllQueryParametersFromRbelMessage(request, uriFacet);
        request.setMethod(this.extractSafe(modifiedRequest, "$.method").getRawStringContent());
    }

    private RbelElement extractSafe(RbelElement targetElement, String rbelPath) {
        return (RbelElement)targetElement.findElement(rbelPath).orElseThrow(() -> new TigerProxyModificationException("Unexpected structure: Could not find '" + rbelPath + "'!"));
    }

    private void addAllQueryParametersFromRbelMessage(HttpRequest request, RbelUriFacet uriFacet) {
        for (RbelElement queryElement : uriFacet.getQueryParameters()) {
            RbelUriParameterFacet parameterFacet = (RbelUriParameterFacet)queryElement.getFacetOrFail(RbelUriParameterFacet.class);
            request.withQueryStringParameter(parameterFacet.getKeyAsString(), parameterFacet.getValue().getRawStringContent());
        }
    }

    private void clearExistingQueryParameters(HttpRequest request) {
        Parameters queryStringParameters = request.getQueryStringParameters();
        if (queryStringParameters == null) {
            return;
        }
        queryStringParameters.getEntries().forEach(parameter -> queryStringParameters.remove(parameter.getName()));
    }

    public void applyModifications(HttpResponse response) {
        if (!this.tigerProxy.getModifications().isEmpty()) {
            this.parseMessageAndApplyModifications(response);
        }
    }

    public void parseMessageAndApplyModifications(HttpResponse response) {
        RbelElement responseElement = this.tigerProxy.getRbelLogger().getRbelConverter().convertElement(this.tigerProxy.getMockServerToRbelConverter().responseToRbelMessage(response));
        RbelElement modifiedResponse = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(responseElement);
        if (modifiedResponse == responseElement) {
            return;
        }
        response.withBody(this.extractSafe(modifiedResponse, "$.body").getRawContent());
        for (RbelElement modifiedHeader : modifiedResponse.findRbelPathMembers("$.header.*")) {
            response = response.replaceHeader(Header.header((String)modifiedHeader.getKey().orElseThrow(), modifiedHeader.getRawStringContent()));
        }
        response.withStatusCode(Integer.parseInt(this.extractSafe(modifiedResponse, "$.responseCode").getRawStringContent()));
        String reasonPhrase = this.extractSafe(modifiedResponse, "$.reasonPhrase").getRawStringContent();
        if (!StringUtils.isEmpty((CharSequence)reasonPhrase)) {
            response.withReasonPhrase(reasonPhrase);
        } else {
            response.withReasonPhrase(" ");
        }
    }

    @Override
    public final HttpRequest handle(HttpRequest req) {
        try {
            this.doIncomingRequestLogging(req);
            HttpRequest modifiedRequest = this.handleRequest(req);
            if (this.shouldLogTraffic()) {
                this.parseMessage(req);
            }
            return modifiedRequest;
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of request", (Throwable)e);
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    public void propagateExceptionMessageSafe(Exception exception) {
        try {
            this.tigerProxy.propagateException(exception);
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occurred (ignoring):", (Throwable)handlingException);
        }
    }

    protected abstract HttpRequest handleRequest(HttpRequest var1);

    @Override
    public final HttpResponse handle(HttpRequest req, HttpResponse resp) {
        try {
            this.doOutgoingResponseLogging(resp);
            return this.handleResponse(req, resp);
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of response", (Throwable)e);
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    private HttpResponse handleResponse(HttpRequest req, HttpResponse resp) {
        this.rewriteLocationHeaderIfApplicable(resp);
        this.applyModifications(resp);
        if (this.shouldLogTraffic()) {
            this.parseMessages(req, resp);
        }
        return resp.withBody(resp.getBodyAsRawBytes());
    }

    private void rewriteLocationHeaderIfApplicable(HttpResponse resp) {
        if (this.tigerProxy.getTigerProxyConfiguration().isRewriteLocationHeader() && resp.getStatusCode() / 100 == 3 && !resp.getHeader(LOCATION_HEADER_KEY).isEmpty()) {
            List<String> locations = resp.getHeader(LOCATION_HEADER_KEY);
            resp.removeHeader(LOCATION_HEADER_KEY);
            locations.stream().map(this::rewriteConcreteLocation).map(l -> new Header(LOCATION_HEADER_KEY, (String)l)).forEach(resp::withHeader);
            log.info("Rewriting from {} to {}", locations, resp.getHeader(LOCATION_HEADER_KEY));
        }
    }

    protected String rewriteConcreteLocation(String originalLocation) {
        return originalLocation;
    }

    public void parseMessage(HttpRequest mockServerRequest) {
        this.executeHttpRequestParsing(mockServerRequest);
    }

    private void parseMessages(HttpRequest req, HttpResponse resp) {
        CompletableFuture<Void> messageParsingCompleteFuture = this.executeHttpTrafficPairParsing(req, resp);
        if (this.tigerProxy.getTigerProxyConfiguration().isParsingShouldBlockCommunication()) {
            try {
                messageParsingCompleteFuture.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TigerProxyParsingException("Interruption while parsing traffic", e);
            }
            catch (ExecutionException e) {
                throw new TigerProxyParsingException("Error while parsing traffic", e);
            }
        }
    }

    public CompletableFuture<Object> executeHttpRequestParsing(HttpRequest mockServerRequest) {
        if (this.isHealthEndpointRequest(mockServerRequest)) {
            return CompletableFuture.completedFuture(null);
        }
        CompletableFuture<RbelElement> toBeConvertedRequest = this.getTigerProxy().getMockServerToRbelConverter().convertRequest(mockServerRequest, this.extractProtocolAndHostForRequest(mockServerRequest), Optional.of(ZonedDateTime.now()));
        this.requestLogIdToParsingFuture.put(mockServerRequest.getLogCorrelationId(), toBeConvertedRequest);
        log.trace("Added request to pairingMap with id {}", (Object)mockServerRequest.getLogCorrelationId());
        return toBeConvertedRequest.thenApply(request -> {
            this.parseCertificateChainIfPresent(mockServerRequest, (RbelElement)request).ifPresent(arg_0 -> ((RbelElement)request).addFacet(arg_0));
            this.getTigerProxy().triggerListener((RbelElement)request);
            this.addBundledServerNameToHostnameFacet((RbelElement)request);
            return request;
        });
    }

    private CompletableFuture<Void> executeHttpTrafficPairParsing(HttpRequest req, HttpResponse resp) {
        if (this.isHealthEndpointRequest(req)) {
            return CompletableFuture.completedFuture(null);
        }
        return this.getTigerProxy().getMockServerToRbelConverter().convertResponse(resp, this.extractProtocolAndHostForRequest(req), req.getRemoteAddress(), Optional.of(ZonedDateTime.now())).thenAccept(response -> this.retrieveParsedRequest(req).thenAccept(request -> this.postProcessingAfterBothMessageParsed((RbelElement)response, (RbelElement)request)));
    }

    private void postProcessingAfterBothMessageParsed(RbelElement response, RbelElement request) {
        TracingMessagePairFacet pairFacet = TracingMessagePairFacet.builder().response(response).request(request).build();
        request.addFacet((RbelFacet)pairFacet);
        response.addFacet((RbelFacet)pairFacet);
        response.addOrReplaceFacet((RbelFacet)response.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::toBuilder).orElse(RbelHttpResponseFacet.builder()).request(request).build());
        this.getTigerProxy().triggerListener(response);
        this.addBundledServerNameToHostnameFacet(response);
    }

    private CompletableFuture<RbelElement> retrieveParsedRequest(HttpRequest req) {
        CompletableFuture<RbelElement> requestParsingFuture = this.requestLogIdToParsingFuture.remove(req.getLogCorrelationId());
        if (requestParsingFuture == null) {
            log.error("Could not find request for response with id {}! Skipping response parsing!", (Object)req.getLogCorrelationId());
            this.tigerProxy.getRbelMessages().forEach(msg -> log.info("Message: {} : {}", (Object)msg.getUuid(), msg));
            throw new TigerProxyParsingException("Not able to find parsed request for uuid " + req.getLogCorrelationId() + "!");
        }
        return requestParsingFuture;
    }

    private void addBundledServerNameToHostnameFacet(RbelElement element) {
        this.modifierBasedOnHostname.modifyMetadata(element);
        this.modifierBasedOnlyOnPort.modifyMetadata(element);
        this.modifierBasedOnProcessAndPort.modifyMetadata(element);
    }

    private boolean isHealthEndpointRequest(HttpRequest request) {
        return request.getQueryStringParameters() != null && request.getQueryStringParameters().containsEntry("healthEndPointUuid", this.getTigerProxy().getHealthEndpointRequestUuid().toString());
    }

    private Optional<RbelFacet> parseCertificateChainIfPresent(HttpRequest httpRequest, RbelElement message) {
        if (httpRequest.getClientCertificateChain() == null || httpRequest.getClientCertificateChain().isEmpty()) {
            return Optional.empty();
        }
        RbelElement certificateChainElement = new RbelElement(null, message);
        certificateChainElement.addFacet((RbelFacet)RbelListFacet.builder().childNodes(httpRequest.getClientCertificateChain().stream().map(MockserverX509CertificateWrapper::certificate).map(cert -> this.mapToRbelElement((Certificate)cert, message)).toList()).build());
        return Optional.of(TlsFacet.builder().clientCertificateChain(certificateChainElement).build());
    }

    private RbelElement mapToRbelElement(Certificate certificate, RbelElement parentNode) {
        try {
            RbelElement certificateNode = new RbelElement(certificate.getEncoded(), parentNode);
            this.getTigerProxy().getRbelLogger().getRbelConverter().convertElement(certificateNode);
            return certificateNode;
        }
        catch (CertificateEncodingException e) {
            RbelElement rbelElement = new RbelElement(null, parentNode);
            rbelElement.addFacet((RbelFacet)RbelNoteFacet.builder().style(RbelNoteFacet.NoteStyling.ERROR).value("Error while trying to get binary representation for certificate: " + e.getMessage()).build());
            return rbelElement;
        }
    }

    boolean shouldLogTraffic() {
        return !this.getTigerRoute().isDisableRbelLogging();
    }

    protected abstract String extractProtocolAndHostForRequest(HttpRequest var1);

    private void addTimingFacet(RbelElement message, ZonedDateTime requestTime) {
        message.addFacet((RbelFacet)RbelMessageTimingFacet.builder().transmissionTime(requestTime).build());
    }

    HttpRequest cloneRequest(HttpRequest req) {
        HttpOverrideForwardedRequest clonedRequest = HttpOverrideForwardedRequest.forwardOverriddenRequest(req);
        if (req.getBody() != null) {
            return clonedRequest.getRequestOverride().withBody(req.getBodyAsRawBytes());
        }
        return clonedRequest.getRequestOverride();
    }

    public void doOutgoingResponseLogging(HttpResponse resp) {
        if (log.isInfoEnabled() && this.tigerProxy.getTigerProxyConfiguration().isActivateTrafficLogging()) {
            log.info("Returning HTTP " + resp.getStatusCode() + " Response-Length: " + AbstractTigerRouteCallback.getMessageSize(resp.getBodyAsRawBytes()));
        }
    }

    private static String getMessageSize(byte[] body) {
        return FileUtils.byteCountToDisplaySize((long)body.length);
    }

    public void doIncomingRequestLogging(HttpRequest req) {
        if (log.isInfoEnabled() && this.tigerProxy.getTigerProxyConfiguration().isActivateTrafficLogging()) {
            log.info("Received " + AbstractTigerRouteCallback.getProtocol(req) + " " + req.getMethod() + " " + req.getPath() + " " + AbstractTigerRouteCallback.getUserAgentString(req) + " Request-Length: " + AbstractTigerRouteCallback.getMessageSize(req.getBodyAsRawBytes()) + " => " + this.printTrafficTarget(req));
        }
    }

    protected abstract String printTrafficTarget(HttpRequest var1);

    private static String getProtocol(HttpRequest req) {
        if (Boolean.TRUE.equals(req.isSecure())) {
            return "HTTPS";
        }
        return "HTTP";
    }

    private static String getUserAgentString(HttpRequest req) {
        return Optional.ofNullable(req.getFirstHeader("User-Agent")).filter(StringUtils::isNotEmpty).map(agent -> "User-Agent: '" + agent + "'").orElse("");
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public TigerRoute getTigerRoute() {
        return this.tigerRoute;
    }

    @Generated
    public MessageMetadataModifier getModifierBasedOnProcessAndPort() {
        return this.modifierBasedOnProcessAndPort;
    }

    @Generated
    public MessageMetadataModifier getModifierBasedOnHostname() {
        return this.modifierBasedOnHostname;
    }

    @Generated
    public MessageMetadataModifier getModifierBasedOnlyOnPort() {
        return this.modifierBasedOnlyOnPort;
    }

    @Generated
    public Map<String, CompletableFuture<RbelElement>> getRequestLogIdToParsingFuture() {
        return this.requestLogIdToParsingFuture;
    }

    @Generated
    public void setRequestLogIdToParsingFuture(Map<String, CompletableFuture<RbelElement>> requestLogIdToParsingFuture) {
        this.requestLogIdToParsingFuture = requestLogIdToParsingFuture;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTigerRouteCallback)) {
            return false;
        }
        AbstractTigerRouteCallback other = (AbstractTigerRouteCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        TigerRoute this$tigerRoute = this.getTigerRoute();
        TigerRoute other$tigerRoute = other.getTigerRoute();
        if (this$tigerRoute == null ? other$tigerRoute != null : !this$tigerRoute.equals(other$tigerRoute)) {
            return false;
        }
        MessageMetadataModifier this$modifierBasedOnProcessAndPort = this.getModifierBasedOnProcessAndPort();
        MessageMetadataModifier other$modifierBasedOnProcessAndPort = other.getModifierBasedOnProcessAndPort();
        if (this$modifierBasedOnProcessAndPort == null ? other$modifierBasedOnProcessAndPort != null : !this$modifierBasedOnProcessAndPort.equals(other$modifierBasedOnProcessAndPort)) {
            return false;
        }
        MessageMetadataModifier this$modifierBasedOnHostname = this.getModifierBasedOnHostname();
        MessageMetadataModifier other$modifierBasedOnHostname = other.getModifierBasedOnHostname();
        if (this$modifierBasedOnHostname == null ? other$modifierBasedOnHostname != null : !this$modifierBasedOnHostname.equals(other$modifierBasedOnHostname)) {
            return false;
        }
        MessageMetadataModifier this$modifierBasedOnlyOnPort = this.getModifierBasedOnlyOnPort();
        MessageMetadataModifier other$modifierBasedOnlyOnPort = other.getModifierBasedOnlyOnPort();
        if (this$modifierBasedOnlyOnPort == null ? other$modifierBasedOnlyOnPort != null : !this$modifierBasedOnlyOnPort.equals(other$modifierBasedOnlyOnPort)) {
            return false;
        }
        Map<String, CompletableFuture<RbelElement>> this$requestLogIdToParsingFuture = this.getRequestLogIdToParsingFuture();
        Map<String, CompletableFuture<RbelElement>> other$requestLogIdToParsingFuture = other.getRequestLogIdToParsingFuture();
        return !(this$requestLogIdToParsingFuture == null ? other$requestLogIdToParsingFuture != null : !((Object)this$requestLogIdToParsingFuture).equals(other$requestLogIdToParsingFuture));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTigerRouteCallback;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        TigerRoute $tigerRoute = this.getTigerRoute();
        result = result * 59 + ($tigerRoute == null ? 43 : $tigerRoute.hashCode());
        MessageMetadataModifier $modifierBasedOnProcessAndPort = this.getModifierBasedOnProcessAndPort();
        result = result * 59 + ($modifierBasedOnProcessAndPort == null ? 43 : $modifierBasedOnProcessAndPort.hashCode());
        MessageMetadataModifier $modifierBasedOnHostname = this.getModifierBasedOnHostname();
        result = result * 59 + ($modifierBasedOnHostname == null ? 43 : $modifierBasedOnHostname.hashCode());
        MessageMetadataModifier $modifierBasedOnlyOnPort = this.getModifierBasedOnlyOnPort();
        result = result * 59 + ($modifierBasedOnlyOnPort == null ? 43 : $modifierBasedOnlyOnPort.hashCode());
        Map<String, CompletableFuture<RbelElement>> $requestLogIdToParsingFuture = this.getRequestLogIdToParsingFuture();
        result = result * 59 + ($requestLogIdToParsingFuture == null ? 43 : ((Object)$requestLogIdToParsingFuture).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractTigerRouteCallback(tigerProxy=" + this.getTigerProxy() + ", tigerRoute=" + this.getTigerRoute() + ", modifierBasedOnProcessAndPort=" + this.getModifierBasedOnProcessAndPort() + ", modifierBasedOnHostname=" + this.getModifierBasedOnHostname() + ", modifierBasedOnlyOnPort=" + this.getModifierBasedOnlyOnPort() + ", requestLogIdToParsingFuture=" + this.getRequestLogIdToParsingFuture() + ")";
    }
}

