/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.common.config.RbelModificationDescription;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerRoute;
import de.gematik.test.tiger.common.data.config.tigerproxy.TigerTlsConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.matchers.TimeToLive;
import de.gematik.test.tiger.mockserver.matchers.Times;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.model.ExpectationId;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.netty.MockServer;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.ForwardProxyTLSX509CertificatesTrustManager;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactorySupplier;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.MockServerToRbelConverter;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.configuration.ProxyConfigurationConverter;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRouteConflictException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxySslException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import de.gematik.test.tiger.proxy.handler.ForwardAllCallback;
import de.gematik.test.tiger.proxy.handler.ForwardProxyCallback;
import de.gematik.test.tiger.proxy.handler.ReverseProxyCallback;
import de.gematik.test.tiger.proxy.tls.DynamicTigerKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.OcspUtils;
import de.gematik.test.tiger.proxy.tls.StaticTigerKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.TlsCertificateGenerator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import jakarta.annotation.PreDestroy;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kong.unirest.Unirest;
import kong.unirest.UnirestInstance;
import kong.unirest.apache.ApacheClient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.tomcat.util.buf.UriUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class TigerProxy
extends AbstractTigerProxy
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxy.class);
    private static final String CA_CERT_ALIAS = "caCert";
    private static final String JDK_TLS_NAMED_GROUPS = "jdk.tls.namedGroups";
    private final List<DynamicTigerKeyAndCertificateFactory> tlsFactories = new ArrayList<DynamicTigerKeyAndCertificateFactory>();
    private final List<Consumer<Throwable>> exceptionListeners = new ArrayList<Consumer<Throwable>>();
    private final MockServerToRbelConverter mockServerToRbelConverter;
    private final Map<String, TigerRoute> tigerRouteMap = new HashMap<String, TigerRoute>();
    private final List<TigerRemoteProxyClient> remoteProxyClients = new ArrayList<TigerRemoteProxyClient>();
    private final UUID healthEndpointRequestUuid = UUID.randomUUID();
    private MockServer mockServer;
    private TigerPkiIdentity generatedRootCa;

    public TigerProxy(TigerProxyConfiguration configuration) {
        super(configuration);
        this.mockServerToRbelConverter = new MockServerToRbelConverter(this.getRbelLogger().getRbelConverter());
        this.bootMockServer();
        if (!configuration.isSkipTrafficEndpointsSubscription()) {
            this.subscribeToTrafficEndpoints(configuration);
        }
        if (configuration.getModifications() != null) {
            int counter = 0;
            for (RbelModificationDescription modification : configuration.getModifications()) {
                if (modification.getName() == null) {
                    modification.setName("TigerModification #" + counter++);
                }
                this.getRbelLogger().getRbelModifier().addModification(modification);
            }
        }
    }

    private static void customizeServerBuilderCustomizer(Configuration mockServerConfiguration, TigerTlsConfiguration tlsConfiguration) {
        mockServerConfiguration.sslServerContextBuilderCustomizer(builder -> {
            if (tlsConfiguration.getServerSslSuites() != null) {
                builder.ciphers((Iterable)tlsConfiguration.getServerSslSuites());
            }
            if (tlsConfiguration.getServerTlsProtocols() != null) {
                builder.protocols((Iterable)tlsConfiguration.getServerTlsProtocols());
            }
            builder.sslProvider(SslProvider.OPENSSL);
            if (tlsConfiguration.getOcspSignerIdentity() != null) {
                builder.enableOcsp(true);
                mockServerConfiguration.ocspResponseSupplier(certificate -> OcspUtils.buildOcspResponse(certificate, tlsConfiguration.getOcspSignerIdentity()));
            }
            return builder;
        });
    }

    private static void customizeClientBuilderCustomizer(Configuration mockServerConfiguration, TigerTlsConfiguration tlsConfiguration) {
        mockServerConfiguration.sslClientContextBuilderCustomizer(builder -> {
            if (tlsConfiguration.getClientSslSuites() != null) {
                builder.ciphers((Iterable)tlsConfiguration.getClientSslSuites());
            }
            builder.sslProvider(SslProvider.JDK);
            return builder;
        });
    }

    private static URL buildUrlSafe(TigerRoute tigerRoute) {
        try {
            return new URL(tigerRoute.getFrom());
        }
        catch (MalformedURLException e) {
            throw new TigerProxyStartupException("Error while building route", e);
        }
    }

    private static CloseableHttpClient getHttpClient(SSLContext sslContext) {
        return HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()).build();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static SSLContext tryGetSslContext(SSLContext sslContext) {
        try (CloseableHttpClient httpClient = TigerProxy.getHttpClient(sslContext);){
            SSLContext sSLContext;
            block14: {
                UnirestInstance unirestInstance = Unirest.primaryInstance();
                try {
                    unirestInstance.config().httpClient(config -> ApacheClient.builder((HttpClient)httpClient).apply(config));
                    sSLContext = sslContext;
                    if (unirestInstance == null) break block14;
                }
                catch (Throwable throwable) {
                    if (unirestInstance != null) {
                        try {
                            unirestInstance.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                unirestInstance.close();
            }
            return sSLContext;
        }
        catch (IOException e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building HTTP Client for Tiger Proxy", e);
        }
    }

    public void restartMockserver() {
        if (this.getTigerProxyConfiguration().getProxyPort() == null) {
            this.getTigerProxyConfiguration().setProxyPort(Integer.valueOf(this.mockServer.getLocalPort()));
        }
        this.mockServer.stop();
        Map<String, TigerRoute> originalRoutes = Collections.unmodifiableMap(this.tigerRouteMap);
        this.tigerRouteMap.clear();
        this.bootMockServer();
        originalRoutes.values().stream().filter(r -> !r.isInternalRoute()).forEach(r -> {
            try {
                this.addRoute((TigerRoute)r);
            }
            catch (RuntimeException e) {
                log.trace("Ignored exception during re-adding of routes", (Throwable)e);
            }
        });
    }

    private void bootMockServer() {
        this.createNewMockServer();
        if (this.getTigerProxyConfiguration().isActivateForwardAllLogging()) {
            this.mockServer.when(HttpRequest.request().setPath(".*"), Times.unlimited(), TimeToLive.unlimited(), Integer.MIN_VALUE).forward(new ForwardAllCallback(this));
        }
        this.addRoutesToTigerProxy();
    }

    private void createNewMockServer() {
        Configuration mockServerConfiguration = Configuration.configuration();
        mockServerConfiguration.customKeyAndCertificateFactorySupplier(this.buildKeyAndCertificateFactory());
        mockServerConfiguration.forwardProxyTLSX509CertificatesTrustManagerType(ForwardProxyTLSX509CertificatesTrustManager.ANY);
        this.customizeSslSuitesIfApplicable(mockServerConfiguration);
        Optional<ProxyConfiguration> forwardProxyConfig = ProxyConfigurationConverter.convertForwardProxyConfigurationToMockServerConfiguration(this.getTigerProxyConfiguration());
        this.outputForwardProxyConfigLogs(forwardProxyConfig);
        this.mockServer = this.getTigerProxyConfiguration().getDirectReverseProxy() == null ? forwardProxyConfig.map(proxyConfiguration -> new MockServer(mockServerConfiguration, List.of(proxyConfiguration), this.getTigerProxyConfiguration().getPortAsArray())).orElseGet(() -> new MockServer(mockServerConfiguration, this.getTigerProxyConfiguration().getPortAsArray())) : this.spawnDirectInverseTigerProxy(mockServerConfiguration, forwardProxyConfig);
        String proxyName = this.getName().orElse("?");
        log.info("Proxy '{}' started on port {}", (Object)proxyName, (Object)this.mockServer.getLocalPort());
    }

    private void addRoutesToTigerProxy() {
        if (this.getTigerProxyConfiguration().getProxyRoutes() != null) {
            for (TigerRoute tigerRoute : this.getTigerProxyConfiguration().getProxyRoutes()) {
                this.addRoute(tigerRoute);
            }
        }
    }

    private MockServer spawnDirectInverseTigerProxy(Configuration mockServerConfiguration, Optional<ProxyConfiguration> forwardProxyConfig) {
        mockServerConfiguration.forwardBinaryRequestsWithoutWaitingForResponse(true);
        mockServerConfiguration.binaryProxyListener(new BinaryExchangeHandler(this));
        if (forwardProxyConfig.isPresent()) {
            throw new TigerProxyStartupException("DirectForwardProxy configured with additional forwardProxy: Not possible! (forwardProxy is always HTTP!)");
        }
        MockServer newMockServer = new MockServer(mockServerConfiguration, this.getTigerProxyConfiguration().getDirectReverseProxy().getPort(), this.getTigerProxyConfiguration().getDirectReverseProxy().getHostname(), this.getTigerProxyConfiguration().getPortAsArray());
        this.addReverseProxyRouteIfNotPresent();
        return newMockServer;
    }

    private void addReverseProxyRouteIfNotPresent() {
        if (this.getTigerProxyConfiguration().getProxyRoutes() == null) {
            this.getTigerProxyConfiguration().setProxyRoutes(new ArrayList());
        }
        this.getTigerProxyConfiguration().getProxyRoutes().add(TigerRoute.builder().from("/").to("http://" + this.getTigerProxyConfiguration().getDirectReverseProxy().getHostname() + ":" + this.getTigerProxyConfiguration().getDirectReverseProxy().getPort()).build());
    }

    private void customizeSslSuitesIfApplicable(Configuration mockServerConfiguration) {
        TigerTlsConfiguration tlsConfiguration = this.getTigerProxyConfiguration().getTls();
        TigerProxy.customizeServerBuilderCustomizer(mockServerConfiguration, tlsConfiguration);
        TigerProxy.customizeClientBuilderCustomizer(mockServerConfiguration, tlsConfiguration);
        this.customizeClientBuilderFunction(mockServerConfiguration, tlsConfiguration);
    }

    private void customizeClientBuilderFunction(Configuration mockServerConfiguration, TigerTlsConfiguration tlsConfiguration) {
        if (tlsConfiguration.getClientSupportedGroups() != null && !tlsConfiguration.getClientSupportedGroups().isEmpty()) {
            mockServerConfiguration.clientSslContextBuilderFunction(sslContextBuilder -> {
                String before = System.getProperty(JDK_TLS_NAMED_GROUPS);
                try {
                    System.setProperty(JDK_TLS_NAMED_GROUPS, String.join((CharSequence)",", tlsConfiguration.getClientSupportedGroups()));
                    sslContextBuilder.sslProvider(SslProvider.JDK);
                    SslContext sslContext = sslContextBuilder.build();
                    return sslContext;
                }
                catch (SSLException e) {
                    throw new TigerProxySslException("Error while building SSL context in Tiger-Proxy " + this.getName().orElse(""), e);
                }
                finally {
                    if (before != null) {
                        System.setProperty(JDK_TLS_NAMED_GROUPS, before);
                    } else {
                        System.clearProperty(JDK_TLS_NAMED_GROUPS);
                    }
                }
            });
        }
    }

    private KeyAndCertificateFactorySupplier buildKeyAndCertificateFactory() {
        return (isServerInstance, mockServerConfiguration) -> {
            if (isServerInstance) {
                if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getServerIdentity() != null) {
                    return new StaticTigerKeyAndCertificateFactory((TigerPkiIdentity)this.getTigerProxyConfiguration().getTls().getServerIdentity());
                }
                DynamicTigerKeyAndCertificateFactory dynamicTigerKeyAndCertificateFactory = new DynamicTigerKeyAndCertificateFactory(this.getTigerProxyConfiguration(), this.determineServerRootCa().orElseThrow(() -> new TigerProxyStartupException("Unrecoverable TLS startup state")), mockServerConfiguration);
                this.tlsFactories.add(dynamicTigerKeyAndCertificateFactory);
                return dynamicTigerKeyAndCertificateFactory;
            }
            if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity() != null) {
                return new StaticTigerKeyAndCertificateFactory((TigerPkiIdentity)this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity());
            }
            return new DynamicTigerKeyAndCertificateFactory(this.getTigerProxyConfiguration(), new TigerPkiIdentity("CertificateAuthorityCertificate.pem;CertificateAuthorityPrivateKey.pem;PKCS1"), mockServerConfiguration);
        };
    }

    private Optional<TigerPkiIdentity> determineServerRootCa() {
        if (this.getTigerProxyConfiguration().getTls().getServerRootCa() != null) {
            return Optional.of(this.getTigerProxyConfiguration().getTls().getServerRootCa());
        }
        if (this.generatedRootCa == null) {
            this.generatedRootCa = TlsCertificateGenerator.generateNewCaCertificate();
        }
        return Optional.of(this.generatedRootCa);
    }

    public void subscribeToTrafficEndpoints(TigerProxyConfiguration configuration) {
        Optional.of(configuration).map(TigerProxyConfiguration::getTrafficEndpoints).ifPresent(this::subscribeToTrafficEndpoints);
    }

    public void subscribeToTrafficEndpoints(List<String> trafficEndpointUrls) {
        ((Stream)Optional.of(trafficEndpointUrls).stream().flatMap(Collection::stream).parallel()).map(url -> new TigerRemoteProxyClient((String)url, TigerProxyConfiguration.builder().downloadInitialTrafficFromEndpoints(this.getTigerProxyConfiguration().isDownloadInitialTrafficFromEndpoints()).trafficEndpointFilterString(this.getTigerProxyConfiguration().getTrafficEndpointFilterString()).name(this.getTigerProxyConfiguration().getName()).connectionTimeoutInSeconds(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds()).build(), this)).forEach(this.remoteProxyClients::add);
        this.remoteProxyClients.parallelStream().forEach(TigerRemoteProxyClient::connect);
    }

    @Override
    public String getBaseUrl() {
        return "http://localhost:" + this.mockServer.getLocalPort();
    }

    @Override
    public int getProxyPort() {
        return this.mockServer.getLocalPort();
    }

    public int getAdminPort() {
        return this.getTigerProxyConfiguration().getAdminPort();
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return this.tigerRouteMap.values().stream().toList();
    }

    @Override
    public RbelModificationDescription addModificaton(RbelModificationDescription modification) {
        this.getRbelLogger().getRbelModifier().addModification(modification);
        return modification;
    }

    @Override
    public List<RbelModificationDescription> getModifications() {
        return this.getRbelLogger().getRbelModifier().getModifications();
    }

    @Override
    public void removeModification(String modificationId) {
        this.getRbelLogger().getRbelModifier().deleteModification(modificationId);
    }

    @Override
    public synchronized TigerRoute addRoute(TigerRoute tigerRoute) {
        this.assertThatRouteIsUnique(tigerRoute);
        log.info("Adding route {} -> {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        Expectation[] expectations = this.buildRouteAndReturnExpectation(tigerRoute);
        if (expectations.length > 1) {
            log.warn("Unexpected number of expectations created! Got {}, expected 1", (Object)expectations.length);
        }
        if (expectations.length == 0) {
            throw new TigerProxyConfigurationException("Error while adding route from '{}' to '{}': Got 0 new expectations");
        }
        TigerRoute createdTigerRoute = tigerRoute.withId(expectations[0].getId());
        this.tigerRouteMap.put(expectations[0].getId(), createdTigerRoute);
        log.debug("Created route from {} to {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        return createdTigerRoute;
    }

    private void assertThatRouteIsUnique(TigerRoute tigerRoute) {
        this.tigerRouteMap.values().stream().filter(existingRoute -> this.uriTwoIsBelowUriOne(existingRoute.getFrom(), tigerRoute.getFrom()) || this.uriTwoIsBelowUriOne(tigerRoute.getFrom(), existingRoute.getFrom())).findAny().ifPresent(existingRoute -> {
            throw new TigerProxyRouteConflictException((TigerRoute)existingRoute);
        });
    }

    private boolean uriTwoIsBelowUriOne(String value1, String value2) {
        try {
            URI uri1 = new URI(value1);
            URI uri2WithUri1Scheme = new URIBuilder(value2).setScheme(uri1.getScheme()).build();
            return !new URI(value1).relativize(uri2WithUri1Scheme).equals(uri2WithUri1Scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private Expectation[] buildRouteAndReturnExpectation(TigerRoute tigerRoute) {
        if (UriUtil.hasScheme((CharSequence)tigerRoute.getFrom())) {
            return this.buildForwardProxyRoute(tigerRoute);
        }
        return this.buildReverseProxyRoute(tigerRoute);
    }

    private Expectation[] buildReverseProxyRoute(TigerRoute tigerRoute) {
        return this.mockServer.when(HttpRequest.request().setPath(tigerRoute.getFrom() + ".*")).forward(new ReverseProxyCallback(this, tigerRoute));
    }

    private Expectation[] buildForwardProxyRoute(TigerRoute tigerRoute) {
        URL url = TigerProxy.buildUrlSafe(tigerRoute);
        return this.mockServer.when(HttpRequest.request().withHeader("Host", url.getAuthority()).setSecure(url.getProtocol().equals("https"))).forward(new ForwardProxyCallback(this, tigerRoute));
    }

    public void addAlternativeName(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return;
        }
        ArrayList<String> newAlternativeNames = new ArrayList<String>();
        if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getAlternativeNames() != null) {
            newAlternativeNames.addAll(this.getTigerProxyConfiguration().getTls().getAlternativeNames());
        }
        newAlternativeNames.add(host);
        Objects.requireNonNull(this.getTigerProxyConfiguration().getTls()).setAlternativeNames(newAlternativeNames);
        for (DynamicTigerKeyAndCertificateFactory tlsFactory : this.tlsFactories) {
            tlsFactory.addAlternativeName(host);
            tlsFactory.resetEeCertificate();
        }
    }

    @Override
    public void removeRoute(String routeId) {
        if (!this.mockServer.isRunning()) {
            return;
        }
        this.mockServer.removeExpectation(new ExpectationId().id(routeId));
        TigerRoute route = this.tigerRouteMap.remove(routeId);
        log.info("Deleted route {}. Current # expectations {}", (Object)route, (Object)this.mockServer.retrieveActiveExpectations(HttpRequest.request()).size());
    }

    public SSLContext getConfiguredTigerProxySslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.buildTrustManagerForTigerProxy()}, null);
            SSLContext.setDefault(sslContext);
            return sslContext;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while configuring SSL Context for Tiger Proxy", e);
        }
    }

    public X509TrustManager buildTrustManagerForTigerProxy() {
        try {
            final X509TrustManager defaultTrustManager = this.extractTrustManager(null);
            final X509TrustManager customTrustManager = this.extractTrustManager(this.buildTruststore());
            return new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return defaultTrustManager.getAcceptedIssuers();
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    try {
                        customTrustManager.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException e) {
                        defaultTrustManager.checkServerTrusted(chain, authType);
                    }
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    defaultTrustManager.checkClientTrusted(chain, authType);
                }
            };
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building TrustManager for Tiger Proxy", e);
        }
    }

    private X509TrustManager extractTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        return (X509TrustManager)Arrays.stream(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).findAny().orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Error while configuring TrustManager for Tiger Proxy"));
    }

    public KeyStore buildTruststore() {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            TigerPkiIdentity serverIdentity = this.determineServerRootCa().or(() -> Optional.ofNullable(this.getTigerProxyConfiguration().getTls()).map(TigerTlsConfiguration::getServerIdentity)).orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Unrecoverable state: Server-Identity null and Server-CA empty"));
            ks.setCertificateEntry(CA_CERT_ALIAS, serverIdentity.getCertificate());
            int chainCertCtr = 0;
            for (X509Certificate chainCert : serverIdentity.getCertificateChain()) {
                ks.setCertificateEntry("chainCert" + chainCertCtr++, chainCert);
            }
            if (this.getTigerProxyConfiguration().getTls().getOcspSignerIdentity() != null) {
                ks.setCertificateEntry("ocspSignerCert", this.getTigerProxyConfiguration().getTls().getOcspSignerIdentity().getCertificate());
            }
            return ks;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    public SSLContext buildSslContext() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.buildTruststore());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = tmf.getTrustManagers();
            sslContext.init(null, trustManagers, null);
            return TigerProxy.tryGetSslContext(sslContext);
        }
        catch (RuntimeException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    private void outputForwardProxyConfigLogs(Optional<ProxyConfiguration> forwardProxyConfig) {
        if (forwardProxyConfig.isEmpty()) {
            log.info("Tigerproxy has NO forward proxy configured!");
        } else {
            ProxyConfiguration configNotEmpty = forwardProxyConfig.get();
            if (configNotEmpty.getUsername() == null) {
                log.info("Forward proxy is set to {}://{}:{}", new Object[]{configNotEmpty.getType(), configNotEmpty.getProxyAddress().getHostName(), configNotEmpty.getProxyAddress().getPort()});
            } else if (configNotEmpty.getUsername() != null) {
                log.info("Forward proxy is set to {}://{}:{}@{}:{}", new Object[]{configNotEmpty.getType(), configNotEmpty.getProxyAddress().getHostName(), configNotEmpty.getProxyAddress().getPort(), configNotEmpty.getUsername(), configNotEmpty.getPassword()});
            }
        }
    }

    public void propagateException(Throwable exception) {
        this.exceptionListeners.forEach(consumer -> consumer.accept(exception));
    }

    public void addNewExceptionConsumer(Consumer<Throwable> newConsumer) {
        this.exceptionListeners.add(newConsumer);
    }

    @Override
    @PreDestroy
    public void close() {
        String tigerProxyName = this.getName().orElse("");
        log.info("Shutting down Tiger-Proxy {}", (Object)tigerProxyName);
        super.close();
        this.remoteProxyClients.forEach(TigerRemoteProxyClient::close);
        this.mockServer.stop();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerProxy)) {
            return false;
        }
        TigerProxy other = (TigerProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<DynamicTigerKeyAndCertificateFactory> this$tlsFactories = this.tlsFactories;
        List<DynamicTigerKeyAndCertificateFactory> other$tlsFactories = other.tlsFactories;
        if (this$tlsFactories == null ? other$tlsFactories != null : !((Object)this$tlsFactories).equals(other$tlsFactories)) {
            return false;
        }
        List<Consumer<Throwable>> this$exceptionListeners = this.exceptionListeners;
        List<Consumer<Throwable>> other$exceptionListeners = other.exceptionListeners;
        if (this$exceptionListeners == null ? other$exceptionListeners != null : !((Object)this$exceptionListeners).equals(other$exceptionListeners)) {
            return false;
        }
        MockServerToRbelConverter this$mockServerToRbelConverter = this.getMockServerToRbelConverter();
        MockServerToRbelConverter other$mockServerToRbelConverter = other.getMockServerToRbelConverter();
        if (this$mockServerToRbelConverter == null ? other$mockServerToRbelConverter != null : !this$mockServerToRbelConverter.equals(other$mockServerToRbelConverter)) {
            return false;
        }
        Map<String, TigerRoute> this$tigerRouteMap = this.tigerRouteMap;
        Map<String, TigerRoute> other$tigerRouteMap = other.tigerRouteMap;
        if (this$tigerRouteMap == null ? other$tigerRouteMap != null : !((Object)this$tigerRouteMap).equals(other$tigerRouteMap)) {
            return false;
        }
        List<TigerRemoteProxyClient> this$remoteProxyClients = this.remoteProxyClients;
        List<TigerRemoteProxyClient> other$remoteProxyClients = other.remoteProxyClients;
        if (this$remoteProxyClients == null ? other$remoteProxyClients != null : !((Object)this$remoteProxyClients).equals(other$remoteProxyClients)) {
            return false;
        }
        UUID this$healthEndpointRequestUuid = this.getHealthEndpointRequestUuid();
        UUID other$healthEndpointRequestUuid = other.getHealthEndpointRequestUuid();
        if (this$healthEndpointRequestUuid == null ? other$healthEndpointRequestUuid != null : !((Object)this$healthEndpointRequestUuid).equals(other$healthEndpointRequestUuid)) {
            return false;
        }
        MockServer this$mockServer = this.mockServer;
        MockServer other$mockServer = other.mockServer;
        if (this$mockServer == null ? other$mockServer != null : !this$mockServer.equals(other$mockServer)) {
            return false;
        }
        TigerPkiIdentity this$generatedRootCa = this.generatedRootCa;
        TigerPkiIdentity other$generatedRootCa = other.generatedRootCa;
        return !(this$generatedRootCa == null ? other$generatedRootCa != null : !this$generatedRootCa.equals(other$generatedRootCa));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerProxy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<DynamicTigerKeyAndCertificateFactory> $tlsFactories = this.tlsFactories;
        result = result * 59 + ($tlsFactories == null ? 43 : ((Object)$tlsFactories).hashCode());
        List<Consumer<Throwable>> $exceptionListeners = this.exceptionListeners;
        result = result * 59 + ($exceptionListeners == null ? 43 : ((Object)$exceptionListeners).hashCode());
        MockServerToRbelConverter $mockServerToRbelConverter = this.getMockServerToRbelConverter();
        result = result * 59 + ($mockServerToRbelConverter == null ? 43 : $mockServerToRbelConverter.hashCode());
        Map<String, TigerRoute> $tigerRouteMap = this.tigerRouteMap;
        result = result * 59 + ($tigerRouteMap == null ? 43 : ((Object)$tigerRouteMap).hashCode());
        List<TigerRemoteProxyClient> $remoteProxyClients = this.remoteProxyClients;
        result = result * 59 + ($remoteProxyClients == null ? 43 : ((Object)$remoteProxyClients).hashCode());
        UUID $healthEndpointRequestUuid = this.getHealthEndpointRequestUuid();
        result = result * 59 + ($healthEndpointRequestUuid == null ? 43 : ((Object)$healthEndpointRequestUuid).hashCode());
        MockServer $mockServer = this.mockServer;
        result = result * 59 + ($mockServer == null ? 43 : $mockServer.hashCode());
        TigerPkiIdentity $generatedRootCa = this.generatedRootCa;
        result = result * 59 + ($generatedRootCa == null ? 43 : $generatedRootCa.hashCode());
        return result;
    }

    @Generated
    public MockServerToRbelConverter getMockServerToRbelConverter() {
        return this.mockServerToRbelConverter;
    }

    @Generated
    public UUID getHealthEndpointRequestUuid() {
        return this.healthEndpointRequestUuid;
    }

    private static class TigerProxyTrustManagerBuildingException
    extends RuntimeException {
        public TigerProxyTrustManagerBuildingException(String s, Exception e) {
            super(s, e);
        }

        public TigerProxyTrustManagerBuildingException(String s) {
            super(s);
        }
    }
}

