/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.socket.tls;

import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.model.Protocol;
import de.gematik.test.tiger.mockserver.socket.tls.KeyAndCertificateFactory;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.AbstractSniHandler;
import io.netty.handler.ssl.OpenSslEngine;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import java.security.cert.Certificate;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SniHandler
extends AbstractSniHandler<SslContext> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SniHandler.class);
    private static final AttributeKey<SSLEngine> UPSTREAM_SSL_ENGINE = AttributeKey.valueOf((String)"UPSTREAM_SSL_ENGINE");
    private static final AttributeKey<SslHandler> UPSTREAM_SSL_HANDLER = AttributeKey.valueOf((String)"UPSTREAM_SSL_HANDLER");
    private static final AttributeKey<Certificate[]> UPSTREAM_CLIENT_CERTIFICATES = AttributeKey.valueOf((String)"UPSTREAM_CLIENT_CERTIFICATES");
    private static final AttributeKey<Protocol> NEGOTIATED_APPLICATION_PROTOCOL = AttributeKey.valueOf((String)"NEGOTIATED_APPLICATION_PROTOCOL");
    private final Configuration configuration;
    private final NettySslContextFactory nettySslContextFactory;

    public SniHandler(Configuration configuration, NettySslContextFactory nettySslContextFactory) {
        this.configuration = configuration;
        this.nettySslContextFactory = nettySslContextFactory;
    }

    protected Future<SslContext> lookup(ChannelHandlerContext ctx, String hostname) {
        if (StringUtils.isNotBlank((CharSequence)hostname)) {
            this.configuration.addSubjectAlternativeName(hostname);
        }
        return ctx.executor().newSucceededFuture((Object)this.nettySslContextFactory.createServerSslContext());
    }

    protected void onLookupComplete(ChannelHandlerContext ctx, String hostname, Future<SslContext> sslContextFuture) {
        if (!sslContextFuture.isSuccess()) {
            Throwable cause = sslContextFuture.cause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            throw new DecoderException("Failed to get the SslContext for " + hostname, cause);
        }
        try {
            this.replaceHandler(ctx, sslContextFuture);
        }
        catch (RuntimeException cause) {
            PlatformDependent.throwException((Throwable)cause);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replaceHandler(ChannelHandlerContext ctx, Future<SslContext> sslContext) {
        SslHandler sslHandler = null;
        try {
            sslHandler = ((SslContext)sslContext.getNow()).newHandler(ctx.alloc());
            SSLEngine sSLEngine = sslHandler.engine();
            if (sSLEngine instanceof OpenSslEngine) {
                OpenSslEngine openSslEngine = (OpenSslEngine)sSLEngine;
                if (this.configuration.ocspResponseSupplier() != null) {
                    try {
                        KeyAndCertificateFactory keyAndCertificateFactory = ((NettySslContextFactory)ctx.channel().attr(AttributeKey.valueOf((String)"NETTY_SSL_CONTEXT_FACTORY")).get()).createKeyAndCertificateFactory();
                        openSslEngine.setOcspResponse(this.configuration.ocspResponseSupplier().apply(keyAndCertificateFactory.x509Certificate()));
                    }
                    catch (Exception e) {
                        log.warn("Failed to set OCSP response", (Throwable)e);
                    }
                }
            }
            ctx.channel().attr(UPSTREAM_SSL_ENGINE).set((Object)sslHandler.engine());
            ctx.channel().attr(UPSTREAM_SSL_HANDLER).set((Object)sslHandler);
            ctx.pipeline().replace((ChannelHandler)this, "SslHandler#0", (ChannelHandler)sslHandler);
            sslHandler = null;
        }
        finally {
            if (sslHandler != null) {
                ReferenceCountUtil.safeRelease((Object)sslHandler.engine());
            }
        }
    }

    public static Certificate[] retrieveClientCertificates(ChannelHandlerContext ctx) {
        SSLSession sslSession;
        SSLEngine sslEngine;
        Certificate[] clientCertificates = null;
        if (ctx.channel().attr(UPSTREAM_CLIENT_CERTIFICATES).get() != null) {
            clientCertificates = (Certificate[])ctx.channel().attr(UPSTREAM_CLIENT_CERTIFICATES).get();
        } else if (ctx.channel().attr(UPSTREAM_SSL_ENGINE).get() != null && (sslEngine = (SSLEngine)ctx.channel().attr(UPSTREAM_SSL_ENGINE).get()) != null && (sslSession = sslEngine.getSession()) != null) {
            try {
                Certificate[] peerCertificates = sslSession.getPeerCertificates();
                ctx.channel().attr(UPSTREAM_CLIENT_CERTIFICATES).set((Object)peerCertificates);
                return peerCertificates;
            }
            catch (SSLPeerUnverifiedException ignore) {
                log.trace("no client certificate chain as client did not complete mTLS");
            }
        }
        return clientCertificates;
    }

    public static Protocol getALPNProtocol(ChannelHandlerContext ctx) {
        Protocol protocol = null;
        try {
            if (ctx != null && ctx.channel() != null) {
                SslHandler sslHandler;
                String negotiatedApplicationProtocol;
                if (ctx.channel().attr(NEGOTIATED_APPLICATION_PROTOCOL).get() != null) {
                    return (Protocol)((Object)ctx.channel().attr(NEGOTIATED_APPLICATION_PROTOCOL).get());
                }
                if (ctx.channel().attr(UPSTREAM_SSL_HANDLER).get() != null && StringUtils.isNotBlank((CharSequence)(negotiatedApplicationProtocol = (sslHandler = (SslHandler)ctx.channel().attr(UPSTREAM_SSL_HANDLER).get()).applicationProtocol()))) {
                    if (negotiatedApplicationProtocol.equalsIgnoreCase("h2")) {
                        protocol = Protocol.HTTP_2;
                    } else if (negotiatedApplicationProtocol.equalsIgnoreCase("http/1.1")) {
                        protocol = Protocol.HTTP_1_1;
                    }
                    ctx.channel().attr(NEGOTIATED_APPLICATION_PROTOCOL).set((Object)protocol);
                    log.trace("found ALPN protocol:{}", (Object)negotiatedApplicationProtocol);
                }
            }
        }
        catch (RuntimeException throwable) {
            log.warn("exception reading ALPN protocol", (Throwable)throwable);
        }
        return protocol;
    }
}

