/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.responsewriter;

import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.cors.CORSHeaders;
import de.gematik.test.tiger.mockserver.model.Header;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpResponseStatus;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResponseWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResponseWriter.class);
    protected final Configuration configuration;
    private final CORSHeaders corsHeaders;

    protected ResponseWriter(Configuration configuration) {
        this.configuration = configuration;
        this.corsHeaders = new CORSHeaders(configuration);
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus) {
        this.writeResponse(request, responseStatus, "", "application/json");
    }

    public void writeResponse(HttpRequest request, HttpResponseStatus responseStatus, String body, String contentType) {
        HttpResponse response = HttpResponse.response().withStatusCode(responseStatus.code()).withReasonPhrase(responseStatus.reasonPhrase()).withBody(body);
        if (body != null && !body.isEmpty()) {
            response.replaceHeader(Header.header(HttpHeaderNames.CONTENT_TYPE.toString(), contentType + "; charset=utf-8"));
        }
        this.writeResponse(request, response, true);
    }

    public void writeResponse(HttpRequest request, HttpResponse response, boolean apiResponse) {
        if (response == null) {
            response = HttpResponse.notFoundResponse();
        }
        if (this.configuration.enableCORSForAllResponses().booleanValue()) {
            this.corsHeaders.addCORSHeaders(request, response);
        } else if (apiResponse && this.configuration.enableCORSForAPI().booleanValue()) {
            this.corsHeaders.addCORSHeaders(request, response);
        }
        String contentLengthHeader = response.getFirstHeader(HttpHeaderNames.CONTENT_LENGTH.toString());
        if (StringUtils.isNotBlank((CharSequence)contentLengthHeader)) {
            try {
                int contentLength = Integer.parseInt(contentLengthHeader);
                if (response.getBodyAsRawBytes().length > contentLength) {
                    log.info("returning response with content-length header {} which is smaller then response body length {}, body will likely be truncated by client receiving request", (Object)contentLength, (Object)response.getBodyAsRawBytes().length);
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (request.getStreamId() != null) {
            response.withStreamId(request.getStreamId());
        }
        this.sendResponse(request, this.addConnectionHeader(request, response));
    }

    public abstract void sendResponse(HttpRequest var1, HttpResponse var2);

    protected HttpResponse addConnectionHeader(HttpRequest request, HttpResponse response) {
        HttpResponse responseWithConnectionHeader = response.clone();
        if (Boolean.TRUE.equals(request.getKeepAlive())) {
            responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.KEEP_ALIVE.toString()));
        } else {
            responseWithConnectionHeader.replaceHeader(Header.header(HttpHeaderNames.CONNECTION.toString(), HttpHeaderValues.CLOSE.toString()));
        }
        return responseWithConnectionHeader;
    }
}

