/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty.responsewriter;

import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.responsewriter.ResponseWriter;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.GenericFutureListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyResponseWriter
extends ResponseWriter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NettyResponseWriter.class);
    private final ChannelHandlerContext ctx;

    public NettyResponseWriter(Configuration configuration, ChannelHandlerContext ctx) {
        super(configuration);
        this.ctx = ctx;
    }

    @Override
    public void sendResponse(HttpRequest request, HttpResponse response) {
        this.writeAndCloseSocket(this.ctx, request, response);
    }

    private void writeAndCloseSocket(ChannelHandlerContext ctx, HttpRequest request, HttpResponse response) {
        boolean closeChannel = request.getKeepAlive() == null || request.getKeepAlive() == false;
        ChannelFuture channelFuture = ctx.writeAndFlush((Object)response);
        if (closeChannel || this.configuration.alwaysCloseSocketConnections().booleanValue()) {
            channelFuture.addListener((GenericFutureListener)((ChannelFutureListener)this::disconnectAndCloseChannel));
        }
    }

    private void disconnectAndCloseChannel(ChannelFuture future) {
        future.channel().disconnect().addListener(disconnectFuture -> {
            if (disconnectFuture.isSuccess()) {
                future.channel().close().addListener(closeFuture -> {
                    if (disconnectFuture.isSuccess()) {
                        if (log.isTraceEnabled()) {
                            log.trace("disconnected and closed socket {}", (Object)future.channel().localAddress());
                        }
                    } else if (log.isWarnEnabled()) {
                        log.warn("exception closing socket {}", (Object)future.channel().localAddress(), (Object)disconnectFuture.cause());
                    }
                });
            } else if (log.isWarnEnabled()) {
                log.warn("exception disconnecting socket {}", (Object)future.channel().localAddress(), (Object)disconnectFuture.cause());
            }
        });
    }
}

