/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.netty;

import com.google.common.collect.ImmutableList;
import de.gematik.test.tiger.mockserver.ExpectationBuilder;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.lifecycle.ExpectationsListener;
import de.gematik.test.tiger.mockserver.lifecycle.LifeCycle;
import de.gematik.test.tiger.mockserver.matchers.TimeToLive;
import de.gematik.test.tiger.mockserver.matchers.Times;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.mock.action.http.HttpActionHandler;
import de.gematik.test.tiger.mockserver.model.ExpectationId;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.RequestDefinition;
import de.gematik.test.tiger.mockserver.netty.HttpRequestHandler;
import de.gematik.test.tiger.mockserver.netty.MockServerUnificationInitializer;
import de.gematik.test.tiger.mockserver.proxyconfiguration.ProxyConfiguration;
import de.gematik.test.tiger.mockserver.socket.tls.NettySslContextFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetSocketAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockServer
extends LifeCycle {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MockServer.class);
    private InetSocketAddress remoteSocket;
    private HttpActionHandler actionHandler;

    public MockServer(Integer ... localPorts) {
        this(null, ProxyConfiguration.proxyConfiguration(Configuration.configuration()), localPorts);
    }

    public MockServer(Configuration configuration, Integer ... localPorts) {
        this(configuration, ProxyConfiguration.proxyConfiguration(configuration), localPorts);
    }

    public MockServer(ProxyConfiguration proxyConfiguration, Integer ... localPorts) {
        this(null, (List<ProxyConfiguration>)ImmutableList.of((Object)proxyConfiguration), localPorts);
    }

    public MockServer(Configuration configuration, List<ProxyConfiguration> proxyConfigurations, Integer ... localPorts) {
        super(configuration);
        this.createServerBootstrap(configuration, proxyConfigurations, localPorts);
        this.getLocalPort();
    }

    public MockServer(Integer remotePort, @Nullable String remoteHost, Integer ... localPorts) {
        this(null, ProxyConfiguration.proxyConfiguration(Configuration.configuration()), remoteHost, remotePort, localPorts);
    }

    public MockServer(Configuration configuration, Integer remotePort, @Nullable String remoteHost, Integer ... localPorts) {
        this(configuration, ProxyConfiguration.proxyConfiguration(configuration), remoteHost, remotePort, localPorts);
    }

    public MockServer(Configuration configuration, ProxyConfiguration proxyConfiguration, @Nullable String remoteHost, Integer remotePort, Integer ... localPorts) {
        this(configuration, (List<ProxyConfiguration>)ImmutableList.of((Object)proxyConfiguration), remoteHost, remotePort, localPorts);
    }

    public MockServer(Configuration configuration, List<ProxyConfiguration> proxyConfigurations, @Nullable String remoteHost, Integer remotePort, Integer ... localPorts) {
        super(configuration);
        if (remotePort == null) {
            throw new IllegalArgumentException("You must specify a remote hostname");
        }
        if (StringUtils.isBlank((CharSequence)remoteHost)) {
            remoteHost = "localhost";
        }
        this.remoteSocket = new InetSocketAddress(remoteHost, (int)remotePort);
        log.info("using proxy configuration for forwarded requests:{}", proxyConfigurations);
        this.createServerBootstrap(configuration, proxyConfigurations, localPorts);
        this.getLocalPort();
    }

    private void createServerBootstrap(Configuration configuration, List<ProxyConfiguration> proxyConfigurations, Integer ... localPorts) {
        if (configuration == null) {
            configuration = Configuration.configuration();
        }
        List<Integer> portBindings = Collections.singletonList(0);
        if (localPorts != null && localPorts.length > 0) {
            portBindings = Arrays.asList(localPorts);
        }
        NettySslContextFactory nettyServerSslContextFactory = new NettySslContextFactory(configuration, true);
        NettySslContextFactory nettyClientSslContextFactory = new NettySslContextFactory(configuration, false);
        this.actionHandler = new HttpActionHandler(configuration, this.getEventLoopGroup(), this.httpState, proxyConfigurations, nettyClientSslContextFactory);
        this.serverServerBootstrap = ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)new ServerBootstrap().group(this.bossGroup, this.workerGroup).option(ChannelOption.SO_BACKLOG, (Object)1024)).channel(NioServerSocketChannel.class)).childOption(ChannelOption.AUTO_READ, (Object)true).childOption(ChannelOption.ALLOCATOR, (Object)PooledByteBufAllocator.DEFAULT).option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(8192, 32768))).childHandler((ChannelHandler)new MockServerUnificationInitializer(configuration, this, this.httpState, this.actionHandler, nettyServerSslContextFactory)).childAttr(HttpActionHandler.REMOTE_SOCKET, (Object)this.remoteSocket).childAttr(HttpRequestHandler.PROXYING, (Object)(this.remoteSocket != null ? 1 : 0));
        try {
            this.bindServerPorts(portBindings);
        }
        catch (RuntimeException throwable) {
            log.error("exception binding to port(s) {}", portBindings, (Object)throwable);
            this.stop();
            throw throwable;
        }
        this.startedServer(this.getLocalPorts());
    }

    public InetSocketAddress getRemoteAddress() {
        return this.remoteSocket;
    }

    @Override
    public MockServer registerListener(ExpectationsListener expectationsListener) {
        super.registerListener(expectationsListener);
        return this;
    }

    public ExpectationBuilder when(RequestDefinition requestDefinition, Times times, TimeToLive timeToLive, Integer priority) {
        return new ExpectationBuilder(new Expectation(requestDefinition, times, timeToLive, priority), this);
    }

    public ExpectationBuilder when(HttpRequest requestDefinition) {
        return new ExpectationBuilder(new Expectation(requestDefinition, Times.unlimited(), TimeToLive.unlimited(), 0), this);
    }

    public void removeExpectation(ExpectationId expectationId) {
        this.httpState.getRequestMatchers().clear(expectationId);
    }

    public List<Expectation> retrieveActiveExpectations(HttpRequest request) {
        return this.httpState.getRequestMatchers().retrieveActiveExpectations(request);
    }

    @Generated
    public InetSocketAddress getRemoteSocket() {
        return this.remoteSocket;
    }

    @Generated
    public HttpActionHandler getActionHandler() {
        return this.actionHandler;
    }
}

