/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock.listeners;

import de.gematik.test.tiger.mockserver.mock.RequestMatchers;
import de.gematik.test.tiger.mockserver.mock.listeners.MockServerMatcherListener;
import de.gematik.test.tiger.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import de.gematik.test.tiger.mockserver.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class MockServerMatcherNotifier
extends ObjectWithReflectiveEqualsHashCodeToString {
    private boolean listenerAdded = false;
    private final List<MockServerMatcherListener> listeners = Collections.synchronizedList(new ArrayList());
    private final Scheduler scheduler;

    public MockServerMatcherNotifier(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    protected void notifyListeners(RequestMatchers notifier, Cause cause) {
        if (this.listenerAdded && !this.listeners.isEmpty()) {
            for (MockServerMatcherListener listener : this.listeners.toArray(new MockServerMatcherListener[0])) {
                this.scheduler.submit(() -> listener.updated(notifier, cause));
            }
        }
    }

    public void registerListener(MockServerMatcherListener listener) {
        this.listeners.add(listener);
        this.listenerAdded = true;
    }

    public static class Cause {
        public static final Cause API = new Cause("", Type.API);
        private final String source;
        private final Type type;

        public Cause(String source, Type type) {
            this.source = source;
            this.type = type;
        }

        public String getSource() {
            return this.source;
        }

        public Type getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cause cause = (Cause)o;
            return Objects.equals(this.source, cause.source) && this.type == cause.type;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.source, this.type});
        }

        public static enum Type {
            FILE_INITIALISER,
            CLASS_INITIALISER,
            API;

        }
    }
}

