/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock;

import de.gematik.test.tiger.mockserver.collections.CircularHashMap;
import de.gematik.test.tiger.mockserver.collections.CircularPriorityQueue;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.matchers.HttpRequestMatcher;
import de.gematik.test.tiger.mockserver.matchers.MatchDifference;
import de.gematik.test.tiger.mockserver.matchers.MatcherBuilder;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.mock.SortableExpectationId;
import de.gematik.test.tiger.mockserver.mock.listeners.MockServerMatcherNotifier;
import de.gematik.test.tiger.mockserver.model.ExpectationId;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.RequestDefinition;
import de.gematik.test.tiger.mockserver.scheduler.Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestMatchers
extends MockServerMatcherNotifier {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RequestMatchers.class);
    private static final int MAX_EXPECTATIONS = 1000;
    final CircularPriorityQueue<String, HttpRequestMatcher, SortableExpectationId> httpRequestMatchers;
    final CircularHashMap<String, RequestDefinition> expectationRequestDefinitions;
    private final Configuration configuration;
    private final Scheduler scheduler;
    private MatcherBuilder matcherBuilder;

    public RequestMatchers(Configuration configuration, Scheduler scheduler) {
        super(scheduler);
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.matcherBuilder = new MatcherBuilder(configuration);
        this.httpRequestMatchers = new CircularPriorityQueue<String, HttpRequestMatcher, SortableExpectationId>(1000, SortableExpectationId.EXPECTATION_SORTABLE_PRIORITY_COMPARATOR, httpRequestMatcher -> httpRequestMatcher.getExpectation() != null ? httpRequestMatcher.getExpectation().getSortableId() : SortableExpectationId.NULL, httpRequestMatcher -> httpRequestMatcher.getExpectation() != null ? httpRequestMatcher.getExpectation().getId() : "");
        this.expectationRequestDefinitions = new CircularHashMap(1000);
        log.trace("expectation circular priority queue created");
    }

    public Expectation add(Expectation expectation, MockServerMatcherNotifier.Cause cause) {
        Expectation upsertedExpectation = null;
        if (expectation != null) {
            this.expectationRequestDefinitions.put(expectation.getId(), expectation.getHttpRequest());
            upsertedExpectation = this.httpRequestMatchers.getByKey(expectation.getId()).map(httpRequestMatcher -> {
                if (httpRequestMatcher.getExpectation() != null) {
                    expectation.withCreated(httpRequestMatcher.getExpectation().getCreated());
                }
                this.httpRequestMatchers.removePriorityKey((HttpRequestMatcher)httpRequestMatcher);
                if (httpRequestMatcher.update(expectation)) {
                    this.httpRequestMatchers.addPriorityKey((HttpRequestMatcher)httpRequestMatcher);
                    log.info("updated expectation:{} with id:{}", (Object)expectation.clone(), (Object)expectation.getId());
                } else {
                    this.httpRequestMatchers.addPriorityKey((HttpRequestMatcher)httpRequestMatcher);
                }
                return httpRequestMatcher;
            }).orElseGet(() -> this.addPrioritisedExpectation(expectation, cause)).getExpectation();
            this.notifyListeners(this, cause);
        }
        return upsertedExpectation;
    }

    private HttpRequestMatcher addPrioritisedExpectation(Expectation expectation, MockServerMatcherNotifier.Cause cause) {
        HttpRequestMatcher httpRequestMatcher = this.matcherBuilder.transformsToMatcher(expectation);
        this.httpRequestMatchers.add(httpRequestMatcher);
        httpRequestMatcher.withSource(cause);
        log.trace("creating expectation: {} with id:{}", (Object)expectation.getHttpRequest(), (Object)expectation.getId());
        return httpRequestMatcher;
    }

    public int size() {
        return this.httpRequestMatchers.size();
    }

    public void reset(MockServerMatcherNotifier.Cause cause) {
        this.httpRequestMatchers.stream().forEach(httpRequestMatcher -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher, cause, false));
        this.expectationRequestDefinitions.clear();
        this.notifyListeners(this, cause);
    }

    public void reset() {
        this.reset(MockServerMatcherNotifier.Cause.API);
    }

    public Expectation firstMatchingExpectation(HttpRequest httpRequest) {
        Optional<Expectation> first = this.getHttpRequestMatchersCopy().map(httpRequestMatcher -> {
            Expectation matchingExpectation = null;
            boolean remainingMatchesDecremented = false;
            if (httpRequestMatcher.matches(new MatchDifference(this.configuration.detailedMatchFailures(), httpRequest), httpRequest)) {
                matchingExpectation = httpRequestMatcher.getExpectation();
                httpRequestMatcher.setResponseInProgress(true);
                if (matchingExpectation.decrementRemainingMatches()) {
                    remainingMatchesDecremented = true;
                }
            } else if (!httpRequestMatcher.isResponseInProgress() && !httpRequestMatcher.isActive()) {
                this.scheduler.submit(() -> this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher));
            }
            if (remainingMatchesDecremented) {
                this.notifyListeners(this, MockServerMatcherNotifier.Cause.API);
            }
            return matchingExpectation;
        }).filter(Objects::nonNull).findFirst();
        return first.orElse(null);
    }

    public void clear(RequestDefinition requestDefinition) {
        if (requestDefinition != null) {
            HttpRequestMatcher clearHttpRequestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
            this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
                RequestDefinition request = httpRequestMatcher.getExpectation().getHttpRequest();
                if (StringUtils.isNotBlank((CharSequence)requestDefinition.getLogCorrelationId())) {
                    request = request.shallowClone().withLogCorrelationId(requestDefinition.getLogCorrelationId());
                }
                if (clearHttpRequestMatcher.matches(request)) {
                    this.removeHttpRequestMatcher((HttpRequestMatcher)httpRequestMatcher);
                }
            });
            log.info("cleared expectations that match: {}", (Object)requestDefinition);
        } else {
            this.reset();
        }
    }

    public void clear(ExpectationId expectationId) {
        if (expectationId != null) {
            this.httpRequestMatchers.getByKey(expectationId.id()).ifPresent(this::removeHttpRequestMatcher);
            log.info("cleared expectations that have id:{}", (Object)expectationId.id());
        } else {
            this.reset();
        }
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher) {
        this.removeHttpRequestMatcher(httpRequestMatcher, MockServerMatcherNotifier.Cause.API, true);
    }

    private void removeHttpRequestMatcher(HttpRequestMatcher httpRequestMatcher, MockServerMatcherNotifier.Cause cause, boolean notifyAndUpdateMetrics) {
        if (this.httpRequestMatchers.remove(httpRequestMatcher)) {
            if (httpRequestMatcher.getExpectation() != null && log.isInfoEnabled()) {
                Expectation expectation = httpRequestMatcher.getExpectation().clone();
                log.info("removed expectation:{} with id:{}", (Object)expectation, (Object)expectation.getId());
            }
            if (notifyAndUpdateMetrics) {
                this.notifyListeners(this, cause);
            }
        }
    }

    public List<Expectation> retrieveActiveExpectations(RequestDefinition requestDefinition) {
        if (requestDefinition == null) {
            return this.httpRequestMatchers.stream().map(HttpRequestMatcher::getExpectation).collect(Collectors.toList());
        }
        ArrayList<Expectation> expectations = new ArrayList<Expectation>();
        HttpRequestMatcher requestMatcher = this.matcherBuilder.transformsToMatcher(requestDefinition);
        this.getHttpRequestMatchersCopy().forEach(httpRequestMatcher -> {
            if (requestMatcher.matches(httpRequestMatcher.getExpectation().getHttpRequest())) {
                expectations.add(httpRequestMatcher.getExpectation());
            }
        });
        return expectations;
    }

    public boolean isEmpty() {
        return this.httpRequestMatchers.isEmpty();
    }

    @Override
    protected void notifyListeners(RequestMatchers notifier, MockServerMatcherNotifier.Cause cause) {
        super.notifyListeners(notifier, cause);
    }

    private Stream<HttpRequestMatcher> getHttpRequestMatchersCopy() {
        return this.httpRequestMatchers.stream();
    }
}

