/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock;

import com.google.common.annotations.VisibleForTesting;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.mock.RequestMatchers;
import de.gematik.test.tiger.mockserver.mock.listeners.MockServerMatcherNotifier;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.RequestDefinition;
import de.gematik.test.tiger.mockserver.scheduler.Scheduler;
import de.gematik.test.tiger.mockserver.uuid.UUIDService;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpState {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpState.class);
    private static final ThreadLocal<Integer> LOCAL_PORT = new ThreadLocal();
    private final String uniqueLoopPreventionHeaderValue = "MockServer_" + UUIDService.getUUID();
    private final Scheduler scheduler;
    private final RequestMatchers requestMatchers;
    private final Configuration configuration;

    public static void setPort(HttpRequest request) {
        if (request != null && request.getSocketAddress() != null) {
            HttpState.setPort(request.getSocketAddress().getPort());
            request.setSocketAddress(null);
        }
    }

    public static void clearPort() {
        LOCAL_PORT.remove();
    }

    public static void setPort(Integer port) {
        LOCAL_PORT.set(port);
    }

    public static void setPort(Integer ... port) {
        if (port != null && port.length > 0) {
            HttpState.setPort(port[0]);
        }
    }

    public static void setPort(List<Integer> port) {
        if (port != null && !port.isEmpty()) {
            HttpState.setPort(port.get(0));
        }
    }

    public static Integer getPort() {
        return LOCAL_PORT.get();
    }

    public HttpState(Configuration configuration, Scheduler scheduler) {
        this.configuration = configuration;
        this.scheduler = scheduler;
        this.requestMatchers = new RequestMatchers(configuration, scheduler);
    }

    public void reset() {
        this.requestMatchers.reset();
        log.info("resetting all expectations and request logs");
    }

    public List<Expectation> add(Expectation ... expectations) {
        ArrayList<Expectation> upsertedExpectations = new ArrayList<Expectation>();
        for (Expectation expectation : expectations) {
            String hostHeader;
            RequestDefinition requestDefinition = expectation.getHttpRequest();
            if (requestDefinition instanceof HttpRequest && StringUtils.isNotBlank((CharSequence)(hostHeader = ((HttpRequest)requestDefinition).getFirstHeader(HttpHeaderNames.HOST.toString())))) {
                this.scheduler.submit(() -> this.configuration.addSubjectAlternativeName(hostHeader));
            }
            upsertedExpectations.add(this.requestMatchers.add(expectation, MockServerMatcherNotifier.Cause.API));
        }
        return upsertedExpectations;
    }

    public Expectation firstMatchingExpectation(HttpRequest request) {
        if (this.requestMatchers.isEmpty()) {
            return null;
        }
        return this.requestMatchers.firstMatchingExpectation(request);
    }

    @VisibleForTesting
    public List<Expectation> allMatchingExpectation(HttpRequest request) {
        if (this.requestMatchers.isEmpty()) {
            return Collections.emptyList();
        }
        return this.requestMatchers.retrieveActiveExpectations(request);
    }

    public boolean handle(HttpRequest request) {
        request.withLogCorrelationId(UUIDService.getUUID());
        HttpState.setPort(request);
        log.trace("received request:{}", (Object)request);
        return false;
    }

    public RequestMatchers getRequestMatchers() {
        return this.requestMatchers;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public String getUniqueLoopPreventionHeaderName() {
        return "x-forwarded-by";
    }

    public String getUniqueLoopPreventionHeaderValue() {
        return this.uniqueLoopPreventionHeaderValue;
    }

    public void stop() {
    }
}

