/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.mock;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.matchers.TimeToLive;
import de.gematik.test.tiger.mockserver.matchers.Times;
import de.gematik.test.tiger.mockserver.mock.HttpAction;
import de.gematik.test.tiger.mockserver.mock.SortableExpectationId;
import de.gematik.test.tiger.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import de.gematik.test.tiger.mockserver.model.HttpOverrideForwardedRequest;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.HttpResponse;
import de.gematik.test.tiger.mockserver.model.ObjectWithJsonToString;
import de.gematik.test.tiger.mockserver.model.RequestDefinition;
import de.gematik.test.tiger.mockserver.uuid.UUIDService;
import java.util.concurrent.atomic.AtomicInteger;
import lombok.Generated;

public class Expectation
extends ObjectWithJsonToString {
    private static final AtomicInteger EXPECTATION_COUNTER = new AtomicInteger(0);
    private static final long START_TIME = System.currentTimeMillis();
    private String id;
    @JsonIgnore
    private long created;
    private int priority;
    private SortableExpectationId sortableExpectationId;
    private final RequestDefinition httpRequest;
    private final Times times;
    private final TimeToLive timeToLive;
    private HttpAction httpAction;

    public static Expectation when(HttpRequest httpRequest) {
        return new Expectation(httpRequest);
    }

    public static Expectation when(HttpRequest httpRequest, int priority) {
        return new Expectation(httpRequest, Times.unlimited(), TimeToLive.unlimited(), priority);
    }

    public static Expectation when(HttpRequest httpRequest, Times times, TimeToLive timeToLive) {
        return new Expectation(httpRequest, times, timeToLive, 0);
    }

    public static Expectation when(HttpRequest httpRequest, Times times, TimeToLive timeToLive, int priority) {
        return new Expectation(httpRequest, times, timeToLive, priority);
    }

    public Expectation(RequestDefinition requestDefinition) {
        this(requestDefinition, Times.unlimited(), TimeToLive.unlimited(), 0);
    }

    public Expectation(RequestDefinition requestDefinition, Times times, TimeToLive timeToLive, int priority) {
        EXPECTATION_COUNTER.compareAndSet(Integer.MAX_VALUE, 0);
        this.created = System.currentTimeMillis() - START_TIME + (long)EXPECTATION_COUNTER.incrementAndGet();
        this.httpRequest = requestDefinition;
        this.times = times;
        this.timeToLive = timeToLive;
        this.priority = priority;
    }

    public Expectation withId(String id) {
        this.id = id;
        this.sortableExpectationId = null;
        return this;
    }

    public String getId() {
        if (this.id == null) {
            this.withId(UUIDService.getUUID());
        }
        return this.id;
    }

    public Expectation withCreated(long created) {
        this.created = created;
        this.sortableExpectationId = null;
        return this;
    }

    @JsonIgnore
    public SortableExpectationId getSortableId() {
        if (this.sortableExpectationId == null) {
            this.sortableExpectationId = new SortableExpectationId(this.getId(), this.priority, this.created);
        }
        return this.sortableExpectationId;
    }

    public Expectation thenRespond(HttpResponse httpResponse) {
        this.httpAction = HttpAction.of(httpResponse);
        return this;
    }

    public Expectation thenForward(ExpectationForwardAndResponseCallback callback) {
        this.httpAction = HttpAction.of(new HttpOverrideForwardedRequest()).setExpectationForwardAndResponseCallback(callback);
        return this;
    }

    @JsonIgnore
    public boolean isActive() {
        return this.hasRemainingMatches() && this.isStillAlive();
    }

    private boolean hasRemainingMatches() {
        return this.times == null || this.times.greaterThenZero();
    }

    private boolean isStillAlive() {
        return this.timeToLive == null || this.timeToLive.stillAlive();
    }

    public boolean decrementRemainingMatches() {
        if (this.times != null) {
            return this.times.decrement();
        }
        return false;
    }

    public boolean contains(HttpRequest httpRequest) {
        return httpRequest != null && this.httpRequest.equals(httpRequest);
    }

    public Expectation clone() {
        return new Expectation(this.httpRequest, this.times.clone(), this.timeToLive, this.priority).withId(this.id).withCreated(this.created).setHttpAction(this.httpAction);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Expectation)) {
            return false;
        }
        Expectation other = (Expectation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPriority() != other.getPriority()) {
            return false;
        }
        RequestDefinition this$httpRequest = this.getHttpRequest();
        RequestDefinition other$httpRequest = other.getHttpRequest();
        if (this$httpRequest == null ? other$httpRequest != null : !((Object)this$httpRequest).equals(other$httpRequest)) {
            return false;
        }
        Times this$times = this.getTimes();
        Times other$times = other.getTimes();
        if (this$times == null ? other$times != null : !((Object)this$times).equals(other$times)) {
            return false;
        }
        TimeToLive this$timeToLive = this.getTimeToLive();
        TimeToLive other$timeToLive = other.getTimeToLive();
        if (this$timeToLive == null ? other$timeToLive != null : !((Object)this$timeToLive).equals(other$timeToLive)) {
            return false;
        }
        HttpAction this$httpAction = this.getHttpAction();
        HttpAction other$httpAction = other.getHttpAction();
        return !(this$httpAction == null ? other$httpAction != null : !((Object)this$httpAction).equals(other$httpAction));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Expectation;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPriority();
        RequestDefinition $httpRequest = this.getHttpRequest();
        result = result * 59 + ($httpRequest == null ? 43 : ((Object)$httpRequest).hashCode());
        Times $times = this.getTimes();
        result = result * 59 + ($times == null ? 43 : ((Object)$times).hashCode());
        TimeToLive $timeToLive = this.getTimeToLive();
        result = result * 59 + ($timeToLive == null ? 43 : ((Object)$timeToLive).hashCode());
        HttpAction $httpAction = this.getHttpAction();
        result = result * 59 + ($httpAction == null ? 43 : ((Object)$httpAction).hashCode());
        return result;
    }

    @Generated
    public long getCreated() {
        return this.created;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public SortableExpectationId getSortableExpectationId() {
        return this.sortableExpectationId;
    }

    @Generated
    public RequestDefinition getHttpRequest() {
        return this.httpRequest;
    }

    @Generated
    public Times getTimes() {
        return this.times;
    }

    @Generated
    public TimeToLive getTimeToLive() {
        return this.timeToLive;
    }

    @Generated
    public HttpAction getHttpAction() {
        return this.httpAction;
    }

    @Generated
    public Expectation setHttpAction(HttpAction httpAction) {
        this.httpAction = httpAction;
        return this;
    }
}

