/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.matchers.BodyMatcher;
import de.gematik.test.tiger.mockserver.matchers.MatchDifference;
import java.util.regex.PatternSyntaxException;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegexStringMatcher
extends BodyMatcher<String> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(RegexStringMatcher.class);
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final String matcher;
    private final boolean controlPlaneMatcher;

    public RegexStringMatcher(boolean controlPlaneMatcher) {
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = null;
    }

    RegexStringMatcher(String matcher, boolean controlPlaneMatcher) {
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = matcher;
    }

    public boolean matches(String matched) {
        return this.matches((MatchDifference)null, matched);
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result = this.matcher == null || this.matches(context, this.matcher, matched);
        return this.not != result;
    }

    public boolean matches(String matcher, String matched) {
        return this.matches(null, matcher, matched);
    }

    public boolean matches(MatchDifference context, String matcherValue, String matchedValue) {
        block12: {
            if (matcherValue == null) {
                return true;
            }
            if (StringUtils.isBlank((CharSequence)matcherValue)) {
                return true;
            }
            if (matchedValue != null) {
                if (matchedValue.equals(matcherValue) || matchedValue.equalsIgnoreCase(matcherValue)) {
                    return true;
                }
                try {
                    if (matchedValue.matches(matcherValue)) {
                        return true;
                    }
                }
                catch (PatternSyntaxException pse) {
                    log.debug("error while matching regex [{}] for string [{}]", new Object[]{this.matcher, matchedValue, pse});
                }
                try {
                    if (this.controlPlaneMatcher && matcherValue.matches(matchedValue)) {
                        return true;
                    }
                    if (matcherValue.matches(matchedValue)) {
                        log.debug("matcher{}would match{}if matcher was used for control plane", (Object)this.matcher, (Object)matchedValue);
                    }
                }
                catch (PatternSyntaxException pse) {
                    if (!this.controlPlaneMatcher) break block12;
                    log.debug("error while matching regex [{}] for string [{}]", new Object[]{matchedValue, this.matcher, pse});
                }
            }
        }
        if (context != null) {
            context.addDifference("string or regex match failed expected:{}found:{}", this.matcher, matchedValue);
        }
        return false;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank((CharSequence)this.matcher);
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

