/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.collections.NottableStringMultiMap;
import de.gematik.test.tiger.mockserver.matchers.MatchDifference;
import de.gematik.test.tiger.mockserver.matchers.NotMatcher;
import de.gematik.test.tiger.mockserver.model.KeyMatchStyle;
import de.gematik.test.tiger.mockserver.model.KeyToMultiValue;
import de.gematik.test.tiger.mockserver.model.KeysToMultiValues;

public class MultiValueMapMatcher
extends NotMatcher<KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues>> {
    private static final String[] EXCLUDED_FIELDS = new String[]{"mockServerLogger"};
    private final NottableStringMultiMap matcher;
    private final KeysToMultiValues keysToMultiValues;
    private final boolean controlPlaneMatcher;
    private Boolean allKeysNotted;
    private Boolean allKeysOptional;

    MultiValueMapMatcher(KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues> keysToMultiValues, boolean controlPlaneMatcher) {
        this.keysToMultiValues = keysToMultiValues;
        this.controlPlaneMatcher = controlPlaneMatcher;
        this.matcher = keysToMultiValues != null ? new NottableStringMultiMap(this.controlPlaneMatcher, keysToMultiValues.getKeyMatchStyle(), keysToMultiValues.getEntries()) : null;
    }

    @Override
    public boolean matches(MatchDifference context, KeysToMultiValues<? extends KeyToMultiValue, ? extends KeysToMultiValues> matched) {
        boolean result;
        if (this.matcher == null || this.matcher.isEmpty()) {
            result = true;
        } else if (matched == null || matched.isEmpty()) {
            if (this.allKeysNotted == null) {
                this.allKeysNotted = this.matcher.allKeysNotted();
            }
            if (this.allKeysOptional == null) {
                this.allKeysOptional = this.matcher.allKeysOptional();
            }
            result = this.allKeysNotted != false || this.allKeysOptional != false;
        } else {
            result = new NottableStringMultiMap(this.controlPlaneMatcher, matched.getKeyMatchStyle(), matched.getEntries()).containsAll(context, this.matcher);
        }
        if (!result && context != null) {
            Object[] objectArray = new Object[3];
            objectArray[0] = this.keysToMultiValues;
            Object object = objectArray[1] = matched != null ? matched : "none";
            objectArray[2] = matched != null ? (this.matcher.getKeyMatchStyle() == KeyMatchStyle.SUB_SET ? "multimap is not a subset" : "multimap values don't match") : "none is not a subset";
            context.addDifference("multimap match failed expected:{}found:{}failed because:{}", objectArray);
        }
        return this.not != result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || this.matcher.isEmpty();
    }

    @Override
    @JsonIgnore
    protected String[] fieldsExcludedFromEqualsAndHashCode() {
        return EXCLUDED_FIELDS;
    }
}

