/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.matchers;

import de.gematik.test.tiger.mockserver.cache.LRUCache;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.matchers.HttpRequestMatcher;
import de.gematik.test.tiger.mockserver.matchers.HttpRequestPropertiesMatcher;
import de.gematik.test.tiger.mockserver.mock.Expectation;
import de.gematik.test.tiger.mockserver.model.RequestDefinition;
import java.util.concurrent.TimeUnit;

public class MatcherBuilder {
    private final Configuration configuration;
    private final LRUCache<RequestDefinition, HttpRequestMatcher> requestMatcherLRUCache;

    public MatcherBuilder(Configuration configuration) {
        this.configuration = configuration;
        this.requestMatcherLRUCache = new LRUCache(250, TimeUnit.MINUTES.toMillis(10L));
    }

    public HttpRequestMatcher transformsToMatcher(RequestDefinition requestDefinition) {
        HttpRequestMatcher httpRequestMatcher = this.requestMatcherLRUCache.get(requestDefinition);
        if (httpRequestMatcher == null) {
            httpRequestMatcher = new HttpRequestPropertiesMatcher(this.configuration);
            httpRequestMatcher.update(requestDefinition);
            this.requestMatcherLRUCache.put(requestDefinition, httpRequestMatcher);
        }
        return httpRequestMatcher;
    }

    public HttpRequestMatcher transformsToMatcher(Expectation expectation) {
        HttpRequestPropertiesMatcher httpRequestMatcher = new HttpRequestPropertiesMatcher(this.configuration);
        httpRequestMatcher.update(expectation);
        return httpRequestMatcher;
    }
}

