/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.google.common.base.Joiner;
import de.gematik.test.tiger.mockserver.character.Character;
import de.gematik.test.tiger.mockserver.codec.PathParametersDecoder;
import de.gematik.test.tiger.mockserver.configuration.Configuration;
import de.gematik.test.tiger.mockserver.matchers.AbstractHttpRequestMatcher;
import de.gematik.test.tiger.mockserver.matchers.BooleanMatcher;
import de.gematik.test.tiger.mockserver.matchers.ExactStringMatcher;
import de.gematik.test.tiger.mockserver.matchers.MatchDifference;
import de.gematik.test.tiger.mockserver.matchers.MatchDifferenceCount;
import de.gematik.test.tiger.mockserver.matchers.Matcher;
import de.gematik.test.tiger.mockserver.matchers.MultiValueMapMatcher;
import de.gematik.test.tiger.mockserver.matchers.RegexStringMatcher;
import de.gematik.test.tiger.mockserver.model.Headers;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.Parameter;
import de.gematik.test.tiger.mockserver.model.Parameters;
import de.gematik.test.tiger.mockserver.model.Protocol;
import de.gematik.test.tiger.mockserver.model.RequestDefinition;
import de.gematik.test.tiger.mockserver.serialization.ObjectMapperFactory;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpRequestPropertiesMatcher
extends AbstractHttpRequestMatcher {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpRequestPropertiesMatcher.class);
    private static final String[] excludedFields = new String[]{"mockServerLogger", "methodMatcher", "pathMatcher", "pathParameterMatcher", "queryStringParameterMatcher", "bodyMatcher", "headerMatcher", "cookieMatcher", "keepAliveMatcher", "bodyDTOMatcher", "sslMatcher", "controlPlaneMatcher", "responseInProgress", "objectMapper"};
    private static final String COMMA = ",";
    private static final String REQUEST_NOT_OPERATOR_IS_ENABLED = "," + Character.NEW_LINE + "request 'not' operator is enabled";
    private static final String EXPECTATION_REQUEST_NOT_OPERATOR_IS_ENABLED = "," + Character.NEW_LINE + "expectation's request 'not' operator is enabled";
    private static final String EXPECTATION_REQUEST_MATCHER_NOT_OPERATOR_IS_ENABLED = "," + Character.NEW_LINE + "expectation's request matcher 'not' operator is enabled";
    private static final PathParametersDecoder pathParametersParser = new PathParametersDecoder();
    private static final ObjectWriter TO_STRING_OBJECT_WRITER = ObjectMapperFactory.createObjectMapper(true, false, new JsonSerializer[0]);
    private int hashCode;
    private HttpRequest httpRequest;
    private List<HttpRequest> httpRequests;
    private RegexStringMatcher methodMatcher = null;
    private RegexStringMatcher pathMatcher = null;
    private MultiValueMapMatcher pathParameterMatcher = null;
    private MultiValueMapMatcher headerMatcher = null;
    private BooleanMatcher keepAliveMatcher = null;
    private BooleanMatcher sslMatcher = null;
    private ExactStringMatcher protocolMatcher = null;

    public HttpRequestPropertiesMatcher(Configuration configuration) {
        super(configuration);
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    @Override
    public List<HttpRequest> getHttpRequests() {
        return this.httpRequests;
    }

    @Override
    public boolean apply(RequestDefinition requestDefinition) {
        HttpRequest httpRequest;
        HttpRequest httpRequest2 = httpRequest = requestDefinition instanceof HttpRequest ? (HttpRequest)requestDefinition : null;
        if (this.httpRequest == null || !this.httpRequest.equals(httpRequest)) {
            this.hashCode = 0;
            this.httpRequest = httpRequest;
            this.httpRequests = Collections.singletonList(this.httpRequest);
            if (httpRequest != null) {
                this.withMethod(httpRequest.getMethod());
                this.withPath(httpRequest);
                this.withPathParameters(httpRequest.getPathParameters());
                this.withHeaders(httpRequest.getHeaders());
                this.withKeepAlive(httpRequest.getKeepAlive());
                this.withSsl(httpRequest.isSecure());
                this.withProtocol(httpRequest.getProtocol());
            }
            return true;
        }
        return false;
    }

    private void withMethod(String method) {
        this.methodMatcher = new RegexStringMatcher(method, this.controlPlaneMatcher);
    }

    private void withPath(HttpRequest httpRequest) {
        this.pathMatcher = new RegexStringMatcher(pathParametersParser.normalisePathWithParametersForMatching(httpRequest), this.controlPlaneMatcher);
    }

    private void withPathParameters(Parameters parameters) {
        this.pathParameterMatcher = new MultiValueMapMatcher(parameters, this.controlPlaneMatcher);
    }

    private void withHeaders(Headers headers) {
        this.headerMatcher = new MultiValueMapMatcher(headers, this.controlPlaneMatcher);
    }

    private void withKeepAlive(Boolean keepAlive) {
        this.keepAliveMatcher = new BooleanMatcher(keepAlive);
    }

    private void withSsl(Boolean isSsl) {
        this.sslMatcher = new BooleanMatcher(isSsl);
    }

    private void withProtocol(Protocol protocol) {
        this.protocolMatcher = new ExactStringMatcher(protocol != null ? protocol.name() : null);
    }

    @Override
    public boolean matches(MatchDifference context, RequestDefinition requestDefinition) {
        if (requestDefinition instanceof HttpRequest) {
            HttpRequest request = (HttpRequest)requestDefinition;
            StringBuilder becauseBuilder = new StringBuilder();
            boolean overallMatch = this.matches(context, request, becauseBuilder);
            if (!this.controlPlaneMatcher) {
                if (overallMatch) {
                    log.trace(this.expectation == null ? "request:{}matched request:{}" : "request:{} matched expectation:{}", (Object)request, (Object)(this.expectation == null ? this : this.expectation.clone()));
                }
            } else {
                becauseBuilder.replace(0, 1, "");
                String because = becauseBuilder.toString();
                log.trace(this.expectation == null ? this.didNotMatchRequestBecause : (becauseBuilder.length() > 0 ? this.didNotMatchExpectationBecause : this.didNotMatchExpectationWithoutBecause), new Object[]{request, this.expectation == null ? this : this.expectation.clone(), because});
            }
            return overallMatch;
        }
        return requestDefinition == null;
    }

    private boolean matches(MatchDifference context, HttpRequest request, StringBuilder becauseBuilder) {
        if (this.isActive()) {
            if (request == this.httpRequest) {
                return true;
            }
            if (this.httpRequest == null) {
                return true;
            }
            MatchDifferenceCount matchDifferenceCount = new MatchDifferenceCount(request);
            if (request != null) {
                Parameters pathParameters;
                boolean pathMatches;
                block19: {
                    boolean methodMatches;
                    boolean bl = methodMatches = StringUtils.isBlank((CharSequence)request.getMethod()) || this.matches(MatchDifference.Field.METHOD, context, this.methodMatcher, request.getMethod());
                    if (this.failFast(this.methodMatcher, context, matchDifferenceCount, becauseBuilder, methodMatches, MatchDifference.Field.METHOD)) {
                        return false;
                    }
                    pathMatches = StringUtils.isBlank((CharSequence)request.getPath()) || this.matches(MatchDifference.Field.PATH, context, this.pathMatcher, this.controlPlaneMatcher ? pathParametersParser.normalisePathWithParametersForMatching(request) : request.getPath());
                    pathParameters = null;
                    try {
                        pathParameters = pathParametersParser.extractPathParameters(this.httpRequest, request);
                    }
                    catch (IllegalArgumentException iae) {
                        if (this.httpRequest.getPath().isBlank()) break block19;
                        if (context != null) {
                            context.currentField(MatchDifference.Field.PATH);
                            context.addDifference(iae.getMessage(), new Object[0]);
                        }
                        pathMatches = false;
                    }
                }
                if (this.failFast(this.pathMatcher, context, matchDifferenceCount, becauseBuilder, pathMatches, MatchDifference.Field.PATH)) {
                    return false;
                }
                boolean headersMatch = this.matches(MatchDifference.Field.HEADERS, context, this.headerMatcher, request.getHeaders());
                if (this.failFast(this.headerMatcher, context, matchDifferenceCount, becauseBuilder, headersMatch, MatchDifference.Field.HEADERS)) {
                    return false;
                }
                boolean pathParametersMatches = true;
                if (!this.httpRequest.getPath().isBlank()) {
                    MultiValueMapMatcher pathParameterMatcher = this.pathParameterMatcher;
                    if (this.controlPlaneMatcher) {
                        Parameters controlPlaneParameters;
                        try {
                            controlPlaneParameters = pathParametersParser.extractPathParameters(request, this.httpRequest);
                        }
                        catch (IllegalArgumentException iae) {
                            controlPlaneParameters = new Parameters(new Parameter[0]);
                        }
                        pathParameterMatcher = new MultiValueMapMatcher(controlPlaneParameters, this.controlPlaneMatcher);
                    }
                    pathParametersMatches = this.matches(MatchDifference.Field.PATH_PARAMETERS, context, pathParameterMatcher, pathParameters);
                }
                if (this.failFast(this.pathParameterMatcher, context, matchDifferenceCount, becauseBuilder, pathParametersMatches, MatchDifference.Field.PATH_PARAMETERS)) {
                    return false;
                }
                boolean keepAliveMatches = this.matches(MatchDifference.Field.KEEP_ALIVE, context, this.keepAliveMatcher, request.getKeepAlive());
                if (this.failFast(this.keepAliveMatcher, context, matchDifferenceCount, becauseBuilder, keepAliveMatches, MatchDifference.Field.KEEP_ALIVE)) {
                    return false;
                }
                boolean sslMatches = this.matches(MatchDifference.Field.SECURE, context, this.sslMatcher, request.isSecure());
                if (this.failFast(this.sslMatcher, context, matchDifferenceCount, becauseBuilder, sslMatches, MatchDifference.Field.SECURE)) {
                    return false;
                }
                boolean protocolMatches = this.matches(MatchDifference.Field.PROTOCOL, context, this.protocolMatcher, request.getProtocol() != null ? request.getProtocol().name() : null);
                if (this.failFast(this.protocolMatcher, context, matchDifferenceCount, becauseBuilder, protocolMatches, MatchDifference.Field.PROTOCOL)) {
                    return false;
                }
                boolean combinedResultAreTrue = HttpRequestPropertiesMatcher.combinedResultAreTrue(matchDifferenceCount.getFailures() == 0, request.isNot(), this.httpRequest.isNot(), this.not);
                if (!this.controlPlaneMatcher && combinedResultAreTrue) {
                    request.withPathParameters(pathParameters);
                }
                return combinedResultAreTrue;
            }
            return HttpRequestPropertiesMatcher.combinedResultAreTrue(true, this.httpRequest.isNot(), this.not);
        }
        return false;
    }

    private boolean failFast(Matcher<?> matcher, MatchDifference context, MatchDifferenceCount matchDifferenceCount, StringBuilder becauseBuilder, boolean fieldMatches, MatchDifference.Field fieldName) {
        if (!this.controlPlaneMatcher) {
            becauseBuilder.append(Character.NEW_LINE).append(fieldName.getName()).append(fieldMatches ? " matched" : " didn't match");
            if (context != null && context.getDifferences(fieldName) != null && !context.getDifferences(fieldName).isEmpty()) {
                becauseBuilder.append(COLON_NEW_LINES).append(Joiner.on((String)Character.NEW_LINE).join(context.getDifferences(fieldName)));
            }
        }
        if (!fieldMatches && !this.controlPlaneMatcher) {
            if (matchDifferenceCount.getHttpRequest().isNot()) {
                becauseBuilder.append(REQUEST_NOT_OPERATOR_IS_ENABLED);
            }
            if (this.httpRequest.isNot()) {
                becauseBuilder.append(EXPECTATION_REQUEST_NOT_OPERATOR_IS_ENABLED);
            }
            if (this.not) {
                becauseBuilder.append(EXPECTATION_REQUEST_MATCHER_NOT_OPERATOR_IS_ENABLED);
            }
        }
        if (!fieldMatches) {
            matchDifferenceCount.incrementFailures();
        }
        if (matcher != null && !matcher.isBlank() && this.configuration.matchersFailFast().booleanValue()) {
            return HttpRequestPropertiesMatcher.combinedResultAreTrue(matchDifferenceCount.getFailures() != 0, matchDifferenceCount.getHttpRequest().isNot(), this.httpRequest.isNot(), this.not);
        }
        return false;
    }

    private static boolean combinedResultAreTrue(boolean ... inputs) {
        int count = 0;
        for (boolean input : inputs) {
            count += input ? 1 : 0;
        }
        return count % 2 != 0;
    }

    private <T> boolean matches(MatchDifference.Field field, MatchDifference context, Matcher<T> matcher, T t) {
        if (context != null) {
            context.currentField(field);
        }
        boolean result = false;
        if (matcher == null) {
            result = true;
        } else if (matcher.matches(context, t)) {
            result = true;
        }
        return result;
    }

    @Override
    public String toString() {
        try {
            return TO_STRING_OBJECT_WRITER.writeValueAsString((Object)this.httpRequest);
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (this.hashCode() != o.hashCode()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpRequestPropertiesMatcher that = (HttpRequestPropertiesMatcher)o;
        return Objects.equals(this.httpRequest, that.httpRequest);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Objects.hash(super.hashCode(), this.httpRequest);
        }
        return this.hashCode;
    }
}

