/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.matchers;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.gematik.test.tiger.mockserver.matchers.BodyMatcher;
import de.gematik.test.tiger.mockserver.matchers.MatchDifference;
import org.apache.commons.lang3.StringUtils;

public class ExactStringMatcher
extends BodyMatcher<String> {
    private static final String[] excludedFields = new String[]{"mockServerLogger"};
    private final String matcher;

    ExactStringMatcher(String matcher) {
        this.matcher = matcher;
    }

    public static boolean matches(String matcher, String matched, boolean ignoreCase) {
        if (StringUtils.isBlank((CharSequence)matcher)) {
            return true;
        }
        if (matched != null) {
            if (matched.equals(matcher)) {
                return true;
            }
            if (ignoreCase) {
                return matched.equalsIgnoreCase(matcher);
            }
        }
        return false;
    }

    @Override
    public boolean matches(MatchDifference context, String matched) {
        boolean result = false;
        if (this.matcher == null) {
            return true;
        }
        if (matched != null && ExactStringMatcher.matches(this.matcher, matched, false)) {
            result = true;
        }
        if (!result && context != null) {
            context.addDifference("exact string match failed expected:{}found:{}", this.matcher, matched);
        }
        if (matched == null) {
            return false;
        }
        return result;
    }

    @Override
    public boolean isBlank() {
        return this.matcher == null || StringUtils.isBlank((CharSequence)this.matcher);
    }

    @Override
    @JsonIgnore
    public String[] fieldsExcludedFromEqualsAndHashCode() {
        return excludedFields;
    }
}

