/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.collections;

import de.gematik.test.tiger.mockserver.collections.ImmutableEntry;
import de.gematik.test.tiger.mockserver.matchers.MatchDifference;
import de.gematik.test.tiger.mockserver.matchers.RegexStringMatcher;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SubSetMatcher {
    static boolean containsSubset(MatchDifference context, RegexStringMatcher regexStringMatcher, List<ImmutableEntry> subset, List<ImmutableEntry> superset) {
        boolean result = true;
        HashSet<Integer> matchingIndexes = new HashSet<Integer>();
        for (ImmutableEntry subsetItem : subset) {
            Set<Integer> subsetItemMatchingIndexes = SubSetMatcher.matchesIndexes(context, regexStringMatcher, subsetItem, superset);
            if (subsetItemMatchingIndexes.isEmpty()) {
                result = false;
                break;
            }
            matchingIndexes.addAll(subsetItemMatchingIndexes);
        }
        if (result) {
            long subsetNonOptionalSize = subset.size();
            result = (long)matchingIndexes.size() >= subsetNonOptionalSize;
        }
        return result;
    }

    private static Set<Integer> matchesIndexes(MatchDifference context, RegexStringMatcher regexStringMatcher, ImmutableEntry matcherItem, List<ImmutableEntry> matchedList) {
        HashSet<Integer> matchingIndexes = new HashSet<Integer>();
        for (int i = 0; i < matchedList.size(); ++i) {
            ImmutableEntry matchedItem = matchedList.get(i);
            boolean keyMatches = regexStringMatcher.matches(context, (String)matcherItem.getKey(), (String)matchedItem.getKey());
            boolean valueMatches = regexStringMatcher.matches(context, (String)matcherItem.getValue(), (String)matchedItem.getValue());
            if (!keyMatches || !valueMatches) continue;
            matchingIndexes.add(i);
        }
        return matchingIndexes;
    }

    private static boolean containsKey(RegexStringMatcher regexStringMatcher, ImmutableEntry matcherItem, List<ImmutableEntry> matchedList) {
        for (ImmutableEntry matchedItem : matchedList) {
            if (!regexStringMatcher.matches((String)matcherItem.getKey(), (String)matchedItem.getKey())) continue;
            return true;
        }
        return false;
    }
}

