/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.collections;

import com.google.common.annotations.VisibleForTesting;
import de.gematik.test.tiger.mockserver.collections.ImmutableEntry;
import de.gematik.test.tiger.mockserver.collections.SubSetMatcher;
import de.gematik.test.tiger.mockserver.matchers.MatchDifference;
import de.gematik.test.tiger.mockserver.matchers.RegexStringMatcher;
import de.gematik.test.tiger.mockserver.model.KeyMatchStyle;
import de.gematik.test.tiger.mockserver.model.KeyToMultiValue;
import de.gematik.test.tiger.mockserver.model.ObjectWithReflectiveEqualsHashCodeToString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class NottableStringMultiMap
extends ObjectWithReflectiveEqualsHashCodeToString {
    private final Map<String, List<String>> backingMap = new LinkedHashMap<String, List<String>>();
    private final RegexStringMatcher regexStringMatcher;
    private final KeyMatchStyle keyMatchStyle;

    public NottableStringMultiMap(boolean controlPlaneMatcher, KeyMatchStyle keyMatchStyle, List<? extends KeyToMultiValue> entries) {
        this.keyMatchStyle = keyMatchStyle;
        this.regexStringMatcher = new RegexStringMatcher(controlPlaneMatcher);
        for (KeyToMultiValue keyToMultiValue : entries) {
            this.backingMap.put(keyToMultiValue.getName(), keyToMultiValue.getValues());
        }
    }

    @VisibleForTesting
    public NottableStringMultiMap(boolean controlPlaneMatcher, KeyMatchStyle keyMatchStyle, String[] ... keyAndValues) {
        this.keyMatchStyle = keyMatchStyle;
        this.regexStringMatcher = new RegexStringMatcher(controlPlaneMatcher);
        for (String[] keyAndValue : keyAndValues) {
            if (keyAndValue.length <= 0) continue;
            this.backingMap.put(keyAndValue[0], keyAndValue.length > 1 ? Arrays.asList(keyAndValue).subList(1, keyAndValue.length) : Collections.emptyList());
        }
    }

    public KeyMatchStyle getKeyMatchStyle() {
        return this.keyMatchStyle;
    }

    public boolean containsAll(MatchDifference context, NottableStringMultiMap subset) {
        switch (subset.keyMatchStyle) {
            case SUB_SET: {
                boolean isSubset = SubSetMatcher.containsSubset(context, this.regexStringMatcher, subset.entryList(), this.entryList());
                if (!isSubset && context != null) {
                    context.addDifference("multimap subset match failed subset:{}was not a subset of:{}", subset.entryList(), this.entryList());
                }
                return isSubset;
            }
            case MATCHING_KEY: {
                for (String matcherKey : subset.backingMap.keySet()) {
                    List<String> matchedValuesForKey = this.getAll(matcherKey);
                    if (matchedValuesForKey.isEmpty()) {
                        if (context != null) {
                            context.addDifference("multimap subset match failed subset:{}did not have expected key:{}", subset, matcherKey);
                        }
                        return false;
                    }
                    List<String> matcherValuesForKey = subset.getAll(matcherKey);
                    for (String matchedValue : matchedValuesForKey) {
                        boolean matchesValue = false;
                        for (String matcherValue : matcherValuesForKey) {
                            if (this.regexStringMatcher.matches(context, matcherValue, matchedValue)) {
                                matchesValue = true;
                                break;
                            }
                            if (context == null) continue;
                            context.addDifference("multimap matching key match failed for key:{}", matcherKey);
                        }
                        if (matchesValue) continue;
                        return false;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean allKeysNotted() {
        return false;
    }

    public boolean allKeysOptional() {
        return false;
    }

    public boolean isEmpty() {
        return this.backingMap.isEmpty();
    }

    private List<String> getAll(String key) {
        if (!this.isEmpty()) {
            ArrayList<String> values = new ArrayList<String>();
            for (Map.Entry<String, List<String>> entry : this.backingMap.entrySet()) {
                if (!this.regexStringMatcher.matches(key, entry.getKey())) continue;
                values.addAll((Collection<String>)entry.getValue());
            }
            return values;
        }
        return Collections.emptyList();
    }

    private List<ImmutableEntry> entryList() {
        if (!this.isEmpty()) {
            ArrayList<ImmutableEntry> entrySet = new ArrayList<ImmutableEntry>();
            for (Map.Entry<String, List<String>> entry : this.backingMap.entrySet()) {
                for (String value : entry.getValue()) {
                    entrySet.add(ImmutableEntry.entry(this.regexStringMatcher, entry.getKey(), value));
                }
            }
            return entrySet;
        }
        return Collections.emptyList();
    }
}

