/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.collections;

import de.gematik.test.tiger.mockserver.matchers.RegexStringMatcher;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;

public class ImmutableEntry
extends Pair<String, String>
implements Map.Entry<String, String> {
    private final RegexStringMatcher regexStringMatcher;
    private final String key;
    private final String value;

    public static ImmutableEntry entry(RegexStringMatcher regexStringMatcher, String key, String value) {
        return new ImmutableEntry(regexStringMatcher, key, value);
    }

    ImmutableEntry(RegexStringMatcher regexStringMatcher, String key, String value) {
        this.regexStringMatcher = regexStringMatcher;
        this.key = key;
        this.value = value;
    }

    public String getLeft() {
        return this.key;
    }

    public String getRight() {
        return this.value;
    }

    @Override
    public String setValue(String value) {
        throw new UnsupportedOperationException("ImmutableEntry is immutable");
    }

    public String toString() {
        return "(" + this.key + ": " + this.value + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ImmutableEntry that = (ImmutableEntry)o;
        return this.regexStringMatcher.matches(this.key, that.key) && this.regexStringMatcher.matches(this.value, that.value) || !this.regexStringMatcher.matches(this.key, that.key);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.regexStringMatcher != null ? this.regexStringMatcher.hashCode() : 0);
        result = 31 * result + (this.key != null ? this.key.hashCode() : 0);
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }
}

