/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.mockserver.codec;

import com.google.common.base.Joiner;
import de.gematik.test.tiger.mockserver.model.HttpRequest;
import de.gematik.test.tiger.mockserver.model.Parameter;
import de.gematik.test.tiger.mockserver.model.Parameters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class PathParametersDecoder {
    private static final Pattern PATH_VARIABLE_NAME_PATTERN = Pattern.compile("\\{[.;]?([^*]+)\\*?}");

    public String validatePath(HttpRequest matcher) {
        Object error = "";
        if (matcher.getPath() != null && matcher.getPathParameters() != null && !matcher.getPathParameters().isEmpty()) {
            ArrayList<String> actualParameterNames = new ArrayList<String>();
            for (String matcherPathPart : matcher.getPath().split("/")) {
                Matcher pathParameterName = PATH_VARIABLE_NAME_PATTERN.matcher(matcherPathPart);
                if (!pathParameterName.matches()) continue;
                actualParameterNames.add(pathParameterName.group(1));
            }
            List expectedParameterNames = matcher.getPathParameters().keySet().stream().toList();
            if (!expectedParameterNames.equals(actualParameterNames)) {
                error = "path parameters specified " + expectedParameterNames + " but found " + actualParameterNames + " in path matcher";
            }
        }
        return error;
    }

    public String normalisePathWithParametersForMatching(HttpRequest matcher) {
        Object result = null;
        if (matcher.getPath() != null) {
            if (matcher.getPathParameters() != null && !matcher.getPathParameters().isEmpty()) {
                String value = matcher.getPath();
                if (value.contains("{")) {
                    ArrayList<String> pathParts = new ArrayList<String>();
                    for (String pathPart : matcher.getPath().split("/")) {
                        Matcher pathParameterName = PATH_VARIABLE_NAME_PATTERN.matcher(pathPart);
                        if (pathParameterName.matches()) {
                            pathParts.add(".*");
                            continue;
                        }
                        pathParts.add(pathPart);
                    }
                    result = Joiner.on((String)"/").join(pathParts) + (value.endsWith("/") ? "/" : "");
                } else {
                    result = matcher.getPath();
                }
            } else {
                result = matcher.getPath();
            }
        }
        return result;
    }

    public Parameters extractPathParameters(HttpRequest matcher, HttpRequest matched) {
        Parameters parsedParameters;
        Parameters parameters = parsedParameters = matched.getPathParameters() != null ? matched.getPathParameters() : new Parameters(new Parameter[0]);
        if (matcher.getPathParameters() != null && !matcher.getPathParameters().isEmpty()) {
            String[] matchedPathParts;
            String[] matcherPathParts = this.getPathParts(matcher.getPath());
            if (matcherPathParts.length != (matchedPathParts = this.getPathParts(matched.getPath())).length) {
                throw new IllegalArgumentException("expected path " + matcher.getPath() + " has " + matcherPathParts.length + " parts but path " + matched.getPath() + " has " + matchedPathParts.length + " part" + (matchedPathParts.length > 1 ? "s " : " "));
            }
            for (int i = 0; i < matcherPathParts.length; ++i) {
                Matcher pathParameterName = PATH_VARIABLE_NAME_PATTERN.matcher(matcherPathParts[i]);
                if (!pathParameterName.matches()) continue;
                String parameterName = pathParameterName.group(1);
                ArrayList<String> parameterValues = new ArrayList<String>();
                Matcher pathParameterValue = Pattern.compile("[.;]?(?:" + parameterName + "=)?([^,]++)[.,;]?").matcher(matchedPathParts[i]);
                while (pathParameterValue.find()) {
                    parameterValues.add(pathParameterValue.group(1));
                }
                parsedParameters.withEntry(parameterName, parameterValues);
            }
        }
        return parsedParameters;
    }

    private String[] getPathParts(String path) {
        return path != null ? (String[])Arrays.stream(StringUtils.removeStart((String)path, (String)"/").split("/")).filter(StringUtils::isNotBlank).toArray(String[]::new) : new String[]{};
    }
}

