/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tracing;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextStoppedEvent;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.TaskScheduler;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.scheduling.concurrent.ThreadPoolTaskScheduler;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.TomcatRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

@Configuration
@EnableWebSocketMessageBroker
public class TracingEndpointConfiguration
implements WebSocketMessageBrokerConfigurer,
ApplicationListener<ContextStoppedEvent> {
    private final TigerProxyConfiguration tigerProxyConfiguration;
    private final ThreadPoolTaskExecutor taskExecutor = TracingEndpointConfiguration.getThreadPoolTaskExecutor();
    private final ThreadPoolTaskScheduler scheduler = TracingEndpointConfiguration.getThreadPoolTaskScheduler();

    private static ThreadPoolTaskExecutor getThreadPoolTaskExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setWaitForTasksToCompleteOnShutdown(true);
        threadPoolTaskExecutor.setAwaitTerminationSeconds(2);
        return threadPoolTaskExecutor;
    }

    private static ThreadPoolTaskScheduler getThreadPoolTaskScheduler() {
        ThreadPoolTaskScheduler scheduler = new ThreadPoolTaskScheduler();
        scheduler.setThreadNamePrefix("TGR_scheduler-");
        scheduler.setWaitForTasksToCompleteOnShutdown(true);
        scheduler.setAwaitTerminationSeconds(2);
        scheduler.initialize();
        return scheduler;
    }

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/topic"});
        config.setApplicationDestinationPrefixes(new String[]{this.tigerProxyConfiguration.getTrafficEndpointConfiguration().getStompTopic()});
        config.configureBrokerChannel().taskExecutor(this.taskExecutor);
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        registry.addEndpoint(new String[]{this.tigerProxyConfiguration.getTrafficEndpointConfiguration().getWsEndpoint()}).withSockJS().setTaskScheduler((TaskScheduler)this.scheduler);
        registry.addEndpoint(new String[]{this.tigerProxyConfiguration.getTrafficEndpointConfiguration().getWsEndpoint()}).setHandshakeHandler((HandshakeHandler)new DefaultHandshakeHandler((RequestUpgradeStrategy)new TomcatRequestUpgradeStrategy())).setAllowedOrigins(new String[]{"*"});
        registry.addEndpoint(new String[]{"/newMessages"}).setHandshakeHandler((HandshakeHandler)new DefaultHandshakeHandler((RequestUpgradeStrategy)new TomcatRequestUpgradeStrategy())).withSockJS();
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor(this.taskExecutor);
    }

    public void configureClientInboundChannel(ChannelRegistration registration) {
        registration.taskExecutor(this.taskExecutor);
    }

    public void onApplicationEvent(ContextStoppedEvent event) {
        this.taskExecutor.shutdown();
        this.scheduler.shutdown();
    }

    @ConstructorProperties(value={"tigerProxyConfiguration"})
    @Generated
    public TracingEndpointConfiguration(TigerProxyConfiguration tigerProxyConfiguration) {
        this.tigerProxyConfiguration = tigerProxyConfiguration;
    }
}

