/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.proxy.configuration.ProxyConfigurationConverter;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import lombok.Generated;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.BasicConstraints;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.bc.BcX509ExtensionUtils;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cert.jcajce.JcaX509v3CertificateBuilder;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.util.IPAddress;
import org.mockserver.configuration.Configuration;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.log.model.LogEntry;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.bouncycastle.BCKeyAndCertificateFactory;
import org.slf4j.event.Level;

public class DynamicTigerKeyAndCertificateFactory
extends BCKeyAndCertificateFactory {
    private static final Duration MAXIMUM_VALIDITY = Duration.ofDays(397L);
    private final TigerPkiIdentity caIdentity;
    private final MockServerLogger mockServerLogger;
    private final List<X509Certificate> certificateChain;
    private final String serverName;
    private final List<String> serverAlternativeNames;
    private TigerPkiIdentity eeIdentity;
    private List<String> hostsCoveredByGeneratedIdentity = List.of();
    private final Configuration mockServerConfiguration;

    public DynamicTigerKeyAndCertificateFactory(MockServerLogger mockServerLogger, TigerProxyConfiguration tigerProxyConfiguration, TigerPkiIdentity caIdentity, Configuration mockServerConfiguration) {
        super(ProxyConfigurationConverter.convertToMockServerConfiguration(tigerProxyConfiguration), mockServerLogger);
        this.certificateChain = new ArrayList<X509Certificate>();
        this.mockServerLogger = mockServerLogger;
        this.caIdentity = caIdentity;
        this.eeIdentity = null;
        this.serverName = tigerProxyConfiguration.getTls().getDomainName();
        this.serverAlternativeNames = new ArrayList<String>();
        if (tigerProxyConfiguration.getTls().getAlternativeNames() != null) {
            this.serverAlternativeNames.addAll(tigerProxyConfiguration.getTls().getAlternativeNames());
        }
        this.mockServerConfiguration = mockServerConfiguration;
    }

    public boolean certificateAuthorityCertificateNotYetCreated() {
        return false;
    }

    public X509Certificate certificateAuthorityX509Certificate() {
        this.buildAndSavePrivateKeyAndX509Certificate();
        if (this.caIdentity != null) {
            return this.caIdentity.getCertificate();
        }
        if (this.eeIdentity.getCertificateChain() != null && this.eeIdentity.getCertificateChain().size() > 0) {
            return (X509Certificate)this.eeIdentity.getCertificateChain().get(0);
        }
        throw new TigerProxyConfigurationException("Discovered illegal configuration in TLS-setup: Dynamic certificate generation, but no CA certificate present!");
    }

    public PrivateKey privateKey() {
        this.buildAndSavePrivateKeyAndX509Certificate();
        return this.eeIdentity.getPrivateKey();
    }

    public X509Certificate x509Certificate() {
        this.buildAndSavePrivateKeyAndX509Certificate();
        return this.eeIdentity.getCertificate();
    }

    public void buildAndSavePrivateKeyAndX509Certificate() {
        this.assureCurrentCertificateCoversAllNecessaryHosts();
        if (this.eeIdentity == null) {
            try {
                KeyPair keyPair = this.generateRsaKeyPair(2048);
                X509Certificate x509Certificate = this.createCertificateSignedByCa(keyPair.getPublic(), this.caIdentity.getCertificate(), this.caIdentity.getPrivateKey());
                this.eeIdentity = new TigerPkiIdentity(x509Certificate, keyPair.getPrivate());
                this.certificateChain.clear();
                this.certificateChain.add(x509Certificate);
                this.certificateChain.add(this.caIdentity.getCertificate());
                if (MockServerLogger.isEnabled((Level)Level.TRACE)) {
                    this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.TRACE).setMessageFormat("created new X509 {} with SAN Domain Names {} and IPs {}").setArguments(new Object[]{this.x509Certificate(), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameDomains().toArray()), Arrays.toString(ConfigurationProperties.sslSubjectAlternativeNameIps().toArray())}));
                }
            }
            catch (Exception e) {
                this.mockServerLogger.logEvent(new LogEntry().setLogLevel(Level.ERROR).setMessageFormat("exception while generating private key and X509 certificate").setThrowable((Throwable)e));
            }
        }
    }

    private void assureCurrentCertificateCoversAllNecessaryHosts() {
        for (String hostThatShouldBePresent : this.mockServerConfiguration.sslSubjectAlternativeNameDomains()) {
            if (this.hostsCoveredByGeneratedIdentity.contains(hostThatShouldBePresent)) continue;
            this.eeIdentity = null;
        }
    }

    public List<X509Certificate> certificateChain() {
        this.buildAndSavePrivateKeyAndX509Certificate();
        return this.certificateChain;
    }

    private X509Certificate createCertificateSignedByCa(PublicKey publicKey, X509Certificate certificateAuthorityCert, PrivateKey certificateAuthorityPrivateKey) throws GeneralSecurityException, IOException, OperatorCreationException {
        X500Name issuer = new X509CertificateHolder(certificateAuthorityCert.getEncoded()).getSubject();
        X500Name subject = new X500Name("CN=" + this.serverName + ", O=Gematik, L=Berlin, ST=Berlin, C=DE");
        BigInteger serial = BigInteger.valueOf(new Random().nextInt(Integer.MAX_VALUE));
        JcaX509v3CertificateBuilder builder = new JcaX509v3CertificateBuilder(issuer, serial, Date.from(ZonedDateTime.now().minusDays(10L).toInstant()), Date.from(ZonedDateTime.now().plus(MAXIMUM_VALIDITY).minusDays(10L).toInstant()), subject, publicKey);
        builder.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)this.createNewSubjectKeyIdentifier(publicKey));
        builder.addExtension(Extension.basicConstraints, false, (ASN1Encodable)new BasicConstraints(false));
        this.hostsCoveredByGeneratedIdentity = new ArrayList<String>();
        this.hostsCoveredByGeneratedIdentity.addAll(this.serverAlternativeNames);
        this.hostsCoveredByGeneratedIdentity.addAll(this.mockServerConfiguration.sslSubjectAlternativeNameDomains());
        this.hostsCoveredByGeneratedIdentity.add(this.serverName);
        DERSequence subjectAlternativeNamesExtension = new DERSequence((ASN1Encodable[])this.hostsCoveredByGeneratedIdentity.stream().distinct().filter(Objects::nonNull).map(this::mapAlternativeNameToAsn1Encodable).toArray(ASN1Encodable[]::new));
        builder.addExtension(Extension.subjectAlternativeName, false, (ASN1Encodable)subjectAlternativeNamesExtension);
        return this.signTheCertificate((X509v3CertificateBuilder)builder, certificateAuthorityPrivateKey);
    }

    private ASN1Encodable mapAlternativeNameToAsn1Encodable(String alternativeName) {
        if (IPAddress.isValidIPv6WithNetmask((String)alternativeName) || IPAddress.isValidIPv6((String)alternativeName) || IPAddress.isValidIPv4WithNetmask((String)alternativeName) || IPAddress.isValidIPv4((String)alternativeName)) {
            return new GeneralName(7, alternativeName);
        }
        return new GeneralName(2, alternativeName);
    }

    private X509Certificate signTheCertificate(X509v3CertificateBuilder certificateBuilder, PrivateKey privateKey) throws OperatorCreationException, CertificateException {
        ContentSigner signer = privateKey instanceof RSAPrivateKey ? new JcaContentSignerBuilder("SHA256WithRSAEncryption").setProvider("BC").build(privateKey) : new JcaContentSignerBuilder("SHA256withECDSA").setProvider("BC").build(privateKey);
        return new JcaX509CertificateConverter().setProvider("BC").getCertificate(certificateBuilder.build(signer));
    }

    private KeyPair generateRsaKeyPair(int keySize) throws GeneralSecurityException {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("RSA", "BC");
        generator.initialize(keySize, new SecureRandom());
        return generator.generateKeyPair();
    }

    private SubjectKeyIdentifier createNewSubjectKeyIdentifier(Key key) throws IOException {
        try (ASN1InputStream is = new ASN1InputStream((InputStream)new ByteArrayInputStream(key.getEncoded()));){
            ASN1Sequence seq = (ASN1Sequence)is.readObject();
            SubjectPublicKeyInfo info = SubjectPublicKeyInfo.getInstance((Object)seq);
            SubjectKeyIdentifier subjectKeyIdentifier = new BcX509ExtensionUtils().createSubjectKeyIdentifier(info);
            return subjectKeyIdentifier;
        }
    }

    public boolean certificateNotYetCreated() {
        return this.eeIdentity == null;
    }

    public void resetEeCertificate() {
        this.eeIdentity = null;
    }

    public void addAlternativeName(String host) {
        this.serverAlternativeNames.add(host);
    }

    @Generated
    public static DynamicTigerKeyAndCertificateFactoryBuilder builder() {
        return new DynamicTigerKeyAndCertificateFactoryBuilder();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Generated
    public static class DynamicTigerKeyAndCertificateFactoryBuilder {
        @Generated
        private MockServerLogger mockServerLogger;
        @Generated
        private TigerProxyConfiguration tigerProxyConfiguration;
        @Generated
        private TigerPkiIdentity caIdentity;
        @Generated
        private Configuration mockServerConfiguration;

        @Generated
        DynamicTigerKeyAndCertificateFactoryBuilder() {
        }

        @Generated
        public DynamicTigerKeyAndCertificateFactoryBuilder mockServerLogger(MockServerLogger mockServerLogger) {
            this.mockServerLogger = mockServerLogger;
            return this;
        }

        @Generated
        public DynamicTigerKeyAndCertificateFactoryBuilder tigerProxyConfiguration(TigerProxyConfiguration tigerProxyConfiguration) {
            this.tigerProxyConfiguration = tigerProxyConfiguration;
            return this;
        }

        @Generated
        public DynamicTigerKeyAndCertificateFactoryBuilder caIdentity(TigerPkiIdentity caIdentity) {
            this.caIdentity = caIdentity;
            return this;
        }

        @Generated
        public DynamicTigerKeyAndCertificateFactoryBuilder mockServerConfiguration(Configuration mockServerConfiguration) {
            this.mockServerConfiguration = mockServerConfiguration;
            return this;
        }

        @Generated
        public DynamicTigerKeyAndCertificateFactory build() {
            return new DynamicTigerKeyAndCertificateFactory(this.mockServerLogger, this.tigerProxyConfiguration, this.caIdentity, this.mockServerConfiguration);
        }

        @Generated
        public String toString() {
            return "DynamicTigerKeyAndCertificateFactory.DynamicTigerKeyAndCertificateFactoryBuilder(mockServerLogger=" + this.mockServerLogger + ", tigerProxyConfiguration=" + this.tigerProxyConfiguration + ", caIdentity=" + this.caIdentity + ", mockServerConfiguration=" + this.mockServerConfiguration + ")";
        }
    }
}

