/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.test.tiger.proxy.configuration.ApplicationConfiguration;
import de.gematik.test.tiger.spring_utils.TigerBuildPropertiesService;
import java.beans.ConstructorProperties;
import java.io.IOException;
import javax.servlet.ServletContextListener;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.Banner;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.annotation.Bean;

@SpringBootApplication(scanBasePackageClasses={TigerBuildPropertiesService.class, TigerProxyApplication.class})
public class TigerProxyApplication
implements ServletContextListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxyApplication.class);
    private final ApplicationConfiguration applicationConfiguration;

    public static void main(String[] args) {
        System.setProperty("java.util.logging.config.file", "SKIP_MOCKSERVER_LOG_INIT!");
        new SpringApplicationBuilder(new Class[0]).bannerMode(Banner.Mode.OFF).sources(new Class[]{TigerProxyApplication.class}).initializers(new ApplicationContextInitializer[0]).run(args);
    }

    @Bean
    public SimpleModule rbelElementDeserializer() {
        SimpleModule module = new SimpleModule();
        module.addSerializer(RbelElement.class, (JsonSerializer)new JsonSerializer<RbelElement>(){

            public void serialize(RbelElement value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
                gen.writeStartObject();
                gen.writeStringField("uuid", value.getUuid());
                gen.writeArrayFieldStart("facets");
                for (RbelFacet facet : value.getFacets()) {
                    gen.writeString(facet.getClass().getSimpleName());
                }
                gen.writeEndArray();
                gen.writeEndObject();
            }
        });
        return module;
    }

    @Bean
    public RbelHtmlRenderer rbelHtmlRenderer() {
        RbelHtmlRenderer renderer = new RbelHtmlRenderer();
        renderer.setMaximumEntitySizeInBytes(this.applicationConfiguration.getSkipDisplayWhenMessageLargerThanKb() * 1024);
        return renderer;
    }

    @ConstructorProperties(value={"applicationConfiguration"})
    @Generated
    public TigerProxyApplication(ApplicationConfiguration applicationConfiguration) {
        this.applicationConfiguration = applicationConfiguration;
    }

    @Generated
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }
}

