/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.handler.AbstractRouteProxyCallback;
import lombok.Generated;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardProxyCallback
extends AbstractRouteProxyCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForwardProxyCallback.class);

    public ForwardProxyCallback(TigerProxy tigerProxy, TigerRoute tigerRoute) {
        super(tigerProxy, tigerRoute);
        tigerProxy.addAlternativeName(this.getSourceUri().getHost());
    }

    @Override
    public HttpRequest handleRequest(HttpRequest req) {
        this.applyModifications(req);
        req.replaceHeader(Header.header((String)"Host", (String[])new String[]{this.getTargetUrl().getHost() + ":" + this.getPort()}));
        if (this.getTigerRoute().getBasicAuth() != null) {
            req.replaceHeader(Header.header((String)"Authorization", (String[])new String[]{this.getTigerRoute().getBasicAuth().toAuthorizationHeaderValue()}));
        }
        String path = req.getPath().toString().equals("/") ? this.getTargetUrl().getPath() + "/" : this.getTargetUrl().getPath() + req.getPath();
        return this.cloneRequest(req).withPath(path).withSecure(Boolean.valueOf(this.getTigerRoute().getTo().startsWith("https://"))).withQueryStringParameters(req.getQueryStringParameters());
    }

    @Override
    protected String extractProtocolAndHostForRequest(HttpRequest request) {
        return this.getSourceUri().getScheme() + "://" + this.getSourceUri().getHost();
    }
}

