/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;

class DataStompHandler
implements StompFrameHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DataStompHandler.class);
    private final TigerRemoteProxyClient remoteProxyClient;

    public Type getPayloadType(StompHeaders stompHeaders) {
        return TracingMessagePart.class;
    }

    public void handleFrame(StompHeaders stompHeaders, Object frameContent) {
        if (log.isTraceEnabled()) {
            log.trace("Received new frame of type {} in proxy {}", (Object)frameContent.getClass().getSimpleName(), (Object)this.remoteProxyClient.getName().orElse("<>"));
        }
        if (frameContent instanceof TracingMessagePart) {
            TracingMessagePart tracingMessagePart = (TracingMessagePart)frameContent;
            log.trace("Received part {} of {} for UUID {}", new Object[]{tracingMessagePart.getIndex() + 1, tracingMessagePart.getNumberOfMessages(), tracingMessagePart.getUuid()});
            this.remoteProxyClient.receiveNewMessagePart(tracingMessagePart);
        }
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public DataStompHandler(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }
}

