/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tls;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.proxy.configuration.ProxyConfigurationConverter;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.List;
import lombok.Generated;
import org.apache.commons.collections.ListUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.socket.tls.bouncycastle.BCKeyAndCertificateFactory;

public class StaticTigerKeyAndCertificateFactory
extends BCKeyAndCertificateFactory {
    private final TigerPkiIdentity identity;

    public StaticTigerKeyAndCertificateFactory(MockServerLogger mockServerLogger, TigerProxyConfiguration tigerProxyConfiguration, TigerPkiIdentity eeIdentity) {
        super(ProxyConfigurationConverter.convertToMockServerConfiguration(tigerProxyConfiguration), mockServerLogger);
        this.identity = eeIdentity;
    }

    public boolean certificateAuthorityCertificateNotYetCreated() {
        return false;
    }

    public X509Certificate certificateAuthorityX509Certificate() {
        if (!this.identity.getCertificateChain().isEmpty()) {
            return (X509Certificate)this.identity.getCertificateChain().get(this.identity.getCertificateChain().size() - 1);
        }
        return this.identity.getCertificate();
    }

    public PrivateKey privateKey() {
        return this.identity.getPrivateKey();
    }

    public X509Certificate x509Certificate() {
        return this.identity.getCertificate();
    }

    public void buildAndSavePrivateKeyAndX509Certificate() {
    }

    public List<X509Certificate> certificateChain() {
        return ListUtils.sum(List.of(this.identity.getCertificate()), (List)this.identity.getCertificateChain());
    }

    public boolean certificateNotYetCreated() {
        return false;
    }

    @Generated
    public static StaticTigerKeyAndCertificateFactoryBuilder builder() {
        return new StaticTigerKeyAndCertificateFactoryBuilder();
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }

    @Generated
    public static class StaticTigerKeyAndCertificateFactoryBuilder {
        @Generated
        private MockServerLogger mockServerLogger;
        @Generated
        private TigerProxyConfiguration tigerProxyConfiguration;
        @Generated
        private TigerPkiIdentity eeIdentity;

        @Generated
        StaticTigerKeyAndCertificateFactoryBuilder() {
        }

        @Generated
        public StaticTigerKeyAndCertificateFactoryBuilder mockServerLogger(MockServerLogger mockServerLogger) {
            this.mockServerLogger = mockServerLogger;
            return this;
        }

        @Generated
        public StaticTigerKeyAndCertificateFactoryBuilder tigerProxyConfiguration(TigerProxyConfiguration tigerProxyConfiguration) {
            this.tigerProxyConfiguration = tigerProxyConfiguration;
            return this;
        }

        @Generated
        public StaticTigerKeyAndCertificateFactoryBuilder eeIdentity(TigerPkiIdentity eeIdentity) {
            this.eeIdentity = eeIdentity;
            return this;
        }

        @Generated
        public StaticTigerKeyAndCertificateFactory build() {
            return new StaticTigerKeyAndCertificateFactory(this.mockServerLogger, this.tigerProxyConfiguration, this.eeIdentity);
        }

        @Generated
        public String toString() {
            return "StaticTigerKeyAndCertificateFactory.StaticTigerKeyAndCertificateFactoryBuilder(mockServerLogger=" + this.mockServerLogger + ", tigerProxyConfiguration=" + this.tigerProxyConfiguration + ", eeIdentity=" + this.eeIdentity + ")";
        }
    }
}

