/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TracingMessageFrame;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TracingMessagePair
implements TracingMessageFrame {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingMessagePair.class);
    private PartialTracingMessage request;
    private PartialTracingMessage response;
    private final TigerRemoteProxyClient remoteProxyClient;

    @Override
    public void checkForCompletePairAndPropagateIfComplete() {
        if (this.request != null && this.response != null && this.request.isComplete() && this.response.isComplete()) {
            this.remoteProxyClient.submitNewMessageTask(this::parseAndPropagate);
        }
    }

    private void parseAndPropagate() {
        if (this.remoteProxyClient.messageUuidKnown(this.request.getTracingDto().getRequestUuid()) || this.remoteProxyClient.messageUuidKnown(this.request.getTracingDto().getResponseUuid())) {
            log.trace("{}Skipping parsing of pair with UUIDs ({} and {}) (received from PUSH): UUID already known", new Object[]{this.remoteProxyClient.proxyName(), this.request.getTracingDto().getRequestUuid(), this.request.getTracingDto().getResponseUuid()});
            return;
        }
        Optional<RbelElement> requestParsed = this.remoteProxyClient.buildNewRbelMessage(this.request.getSender(), this.request.getReceiver(), this.request.buildCompleteContent(), Optional.ofNullable(this.request.getTransmissionTime()), this.request.getTracingDto().getRequestUuid());
        Optional<RbelElement> responseParsed = this.remoteProxyClient.buildNewRbelMessage(this.response.getSender(), this.response.getReceiver(), this.response.buildCompleteContent(), Optional.ofNullable(this.response.getTransmissionTime()), this.response.getTracingDto().getResponseUuid());
        if (requestParsed.isEmpty() || responseParsed.isEmpty()) {
            return;
        }
        TracingMessagePairFacet pairFacet = TracingMessagePairFacet.builder().response(responseParsed.get()).request(requestParsed.get()).build();
        responseParsed.get().addFacet((RbelFacet)pairFacet);
        if (log.isTraceEnabled()) {
            log.trace("{}Received pair to {} (UUIDs {} and {})", new Object[]{this.remoteProxyClient.proxyName(), requestParsed.map(RbelElement::getRawStringContent).map(s -> Stream.of(s.split(" ")).skip(1L).limit(1L).collect(Collectors.joining(","))).orElse("<>"), requestParsed.get().getUuid(), responseParsed.get().getUuid()});
        }
        this.remoteProxyClient.getLastMessageUuid().set(responseParsed.get().getUuid());
        if (this.remoteProxyClient.messageMatchesFilterCriterion(requestParsed.get()) || this.remoteProxyClient.messageMatchesFilterCriterion(responseParsed.get())) {
            this.remoteProxyClient.propagateMessage(requestParsed.get());
            this.remoteProxyClient.propagateMessage(responseParsed.get());
        } else {
            this.remoteProxyClient.removeMessage(requestParsed.get());
            this.remoteProxyClient.removeMessage(responseParsed.get());
        }
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public TracingMessagePair(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }

    @Generated
    public PartialTracingMessage getRequest() {
        return this.request;
    }

    @Generated
    public PartialTracingMessage getResponse() {
        return this.response;
    }

    @Generated
    public TigerRemoteProxyClient getRemoteProxyClient() {
        return this.remoteProxyClient;
    }

    @Generated
    public void setRequest(PartialTracingMessage request) {
        this.request = request;
    }

    @Generated
    public void setResponse(PartialTracingMessage response) {
        this.response = response;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TracingMessagePair)) {
            return false;
        }
        TracingMessagePair other = (TracingMessagePair)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PartialTracingMessage this$request = this.getRequest();
        PartialTracingMessage other$request = other.getRequest();
        if (this$request == null ? other$request != null : !((Object)this$request).equals(other$request)) {
            return false;
        }
        PartialTracingMessage this$response = this.getResponse();
        PartialTracingMessage other$response = other.getResponse();
        if (this$response == null ? other$response != null : !((Object)this$response).equals(other$response)) {
            return false;
        }
        TigerRemoteProxyClient this$remoteProxyClient = this.getRemoteProxyClient();
        TigerRemoteProxyClient other$remoteProxyClient = other.getRemoteProxyClient();
        return !(this$remoteProxyClient == null ? other$remoteProxyClient != null : !((Object)this$remoteProxyClient).equals(other$remoteProxyClient));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TracingMessagePair;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PartialTracingMessage $request = this.getRequest();
        result = result * 59 + ($request == null ? 43 : ((Object)$request).hashCode());
        PartialTracingMessage $response = this.getResponse();
        result = result * 59 + ($response == null ? 43 : ((Object)$response).hashCode());
        TigerRemoteProxyClient $remoteProxyClient = this.getRemoteProxyClient();
        result = result * 59 + ($remoteProxyClient == null ? 43 : ((Object)$remoteProxyClient).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TracingMessagePair(request=" + this.getRequest() + ", response=" + this.getResponse() + ")";
    }
}

