/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.test.tiger.proxy.client.DataStompHandler;
import de.gematik.test.tiger.proxy.client.ErrorsStompHandler;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TracingStompHandler;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.stomp.ConnectionLostException;
import org.springframework.messaging.simp.stomp.StompCommand;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;
import org.springframework.messaging.simp.stomp.StompSession;
import org.springframework.messaging.simp.stomp.StompSessionHandlerAdapter;

class TigerStompSessionHandler
extends StompSessionHandlerAdapter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerStompSessionHandler.class);
    private final TigerRemoteProxyClient remoteProxyClient;
    private TracingStompHandler tracingStompHandler;
    private DataStompHandler dataStompHandler;
    private ErrorsStompHandler errorStompHandler;

    public void afterConnected(StompSession stompSession, StompHeaders stompHeaders) {
        log.info("Connecting to tracing point {}", (Object)this.remoteProxyClient.getRemoteProxyUrl());
        this.tracingStompHandler = new TracingStompHandler(this.remoteProxyClient);
        stompSession.subscribe("/topic/traces", (StompFrameHandler)this.tracingStompHandler);
        this.dataStompHandler = new DataStompHandler(this.remoteProxyClient);
        stompSession.subscribe("/topic/data", (StompFrameHandler)this.dataStompHandler);
        this.errorStompHandler = new ErrorsStompHandler(this.remoteProxyClient);
        stompSession.subscribe("/topic/errors", (StompFrameHandler)this.errorStompHandler);
    }

    public void handleException(StompSession stompSession, StompCommand stompCommand, StompHeaders stompHeaders, byte[] bytes, Throwable throwable) {
        log.error("handle exception with remote url '{}': {}, {}", new Object[]{this.remoteProxyClient.getRemoteProxyUrl(), new String(bytes), throwable});
        throw new TigerRemoteProxyClientException(throwable);
    }

    public void handleTransportError(StompSession session, Throwable exception) {
        if (exception instanceof ConnectionLostException) {
            if (this.remoteProxyClient.isShuttingDown()) {
                log.warn("Remote client lost connection to url {} in session {} (isConnected = {}). Client in shutdown, skipping reconnect!", new Object[]{this.remoteProxyClient.getRemoteProxyUrl(), session.getSessionId(), session.isConnected()});
                return;
            }
        } else {
            log.error("handle transport error from url '{}': {}", (Object)this.remoteProxyClient.getRemoteProxyUrl(), (Object)exception);
            throw new TigerRemoteProxyClientException(exception);
        }
        log.warn("Remote client lost connection to url {} in session {} (isConnected = {}). Reconnecting...", new Object[]{this.remoteProxyClient.getRemoteProxyUrl(), session.getSessionId(), session.isConnected()});
        this.remoteProxyClient.connectToRemoteUrl(this, this.remoteProxyClient.getTigerProxyConfiguration().getConnectionTimeoutInSeconds(), true);
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public TigerStompSessionHandler(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }

    @Generated
    public TracingStompHandler getTracingStompHandler() {
        return this.tracingStompHandler;
    }

    @Generated
    public DataStompHandler getDataStompHandler() {
        return this.dataStompHandler;
    }

    @Generated
    public ErrorsStompHandler getErrorStompHandler() {
        return this.errorStompHandler;
    }
}

