/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.proxy.TigerProxy;
import java.time.LocalDateTime;
import java.util.Optional;
import kong.unirest.Unirest;
import kong.unirest.UnirestException;
import kong.unirest.UnirestInstance;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthIndicator;
import org.springframework.boot.actuate.health.Status;
import org.springframework.stereotype.Component;

@Component(value="messageQueue")
public class TigerProxyHealthIndicator
implements HealthIndicator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxyHealthIndicator.class);
    private final TigerProxy tigerProxy;
    private Optional<LocalDateTime> lastSuccessfulRequest = Optional.empty();
    private Optional<LocalDateTime> firstFailedRequest = Optional.empty();

    public TigerProxyHealthIndicator(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
    }

    public Health health() {
        Status status = this.checkProxyAlive();
        long bufferSize = this.tigerProxy.getRbelLogger().getRbelConverter().getCurrentBufferSize();
        return Health.status((Status)status).withDetail("tigerProxyHealthy", (Object)this.tigerProxyHealthy()).withDetail("rbelMessages", (Object)this.tigerProxy.getRbelLogger().getMessageHistory().size()).withDetail("rbelMessageBuffer", (Object)bufferSize).withDetail("lastSuccessfulMockserverRequest", this.lastSuccessfulRequest).withDetail("firstFailedMockserverRequest", this.firstFailedRequest).build();
    }

    private Status checkProxyAlive() {
        Status status;
        block9: {
            int adminPort = this.tigerProxy.getAdminPort();
            LocalDateTime timestamp = LocalDateTime.now();
            UnirestInstance unirestInstance = Unirest.spawnInstance();
            try {
                unirestInstance.config().proxy("localhost", this.tigerProxy.getProxyPort());
                unirestInstance.config().connectTimeout(2000);
                unirestInstance.config().socketTimeout(2000);
                unirestInstance.get("http://localhost:" + adminPort + "/?healthEndPointUuid=" + this.tigerProxy.getHealthEndpointRequestUuid()).asString();
                this.lastSuccessfulRequest = Optional.of(timestamp);
                this.firstFailedRequest = Optional.empty();
                status = Status.UP;
                if (unirestInstance == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (unirestInstance != null) {
                        try {
                            unirestInstance.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (UnirestException rte) {
                    if (this.firstFailedRequest.isEmpty()) {
                        this.firstFailedRequest = Optional.of(timestamp);
                    }
                    return Status.DOWN;
                }
            }
            unirestInstance.close();
        }
        return status;
    }

    private boolean tigerProxyHealthy() {
        return this.firstFailedRequest.isEmpty() && this.lastSuccessfulRequest.isPresent();
    }
}

