/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.test.tiger.common.config.RbelModificationDescription;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerTlsConfiguration;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.MockServerToRbelConverter;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.configuration.ProxyConfigurationConverter;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRouteConflictException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.handler.BinaryExchangeHandler;
import de.gematik.test.tiger.proxy.handler.ForwardAllCallback;
import de.gematik.test.tiger.proxy.handler.ForwardProxyCallback;
import de.gematik.test.tiger.proxy.handler.ReverseProxyCallback;
import de.gematik.test.tiger.proxy.tls.DynamicTigerKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.StaticTigerKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.tls.TlsCertificateGenerator;
import io.netty.handler.ssl.SslProvider;
import jakarta.annotation.PreDestroy;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import kong.unirest.Client;
import kong.unirest.Config;
import kong.unirest.Unirest;
import kong.unirest.apache.ApacheClient;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.tomcat.util.buf.UriUtil;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.Configuration;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.model.BinaryProxyListener;
import org.mockserver.model.ExpectationId;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.RequestDefinition;
import org.mockserver.netty.MockServer;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.ForwardProxyTLSX509CertificatesTrustManager;
import org.mockserver.socket.tls.KeyAndCertificateFactoryFactory;
import org.mockserver.socket.tls.KeyAndCertificateFactorySupplier;
import org.mockserver.socket.tls.NettySslContextFactory;
import org.mockserver.socket.tls.bouncycastle.BCKeyAndCertificateFactory;
import org.springframework.stereotype.Component;

@Component
public class TigerProxy
extends AbstractTigerProxy
implements AutoCloseable {
    public static final String CA_CERT_ALIAS = "caCert";
    private final List<DynamicTigerKeyAndCertificateFactory> tlsFactories = new ArrayList<DynamicTigerKeyAndCertificateFactory>();
    private final List<Consumer<Throwable>> exceptionListeners = new ArrayList<Consumer<Throwable>>();
    private MockServer mockServer;
    private MockServerClient mockServerClient;
    private final MockServerToRbelConverter mockServerToRbelConverter;
    private final Map<String, TigerRoute> tigerRouteMap = new HashMap<String, TigerRoute>();
    private final List<TigerRemoteProxyClient> remoteProxyClients = new ArrayList<TigerRemoteProxyClient>();
    private TigerPkiIdentity generatedRootCa;
    private final UUID healthEndpointRequestUuid = UUID.randomUUID();

    public TigerProxy(TigerProxyConfiguration configuration) {
        super(configuration);
        this.mockServerToRbelConverter = new MockServerToRbelConverter(this.getRbelLogger().getRbelConverter());
        this.bootMockServer();
        if (!configuration.isSkipTrafficEndpointsSubscription()) {
            this.subscribeToTrafficEndpoints(configuration);
        }
        if (configuration.getModifications() != null) {
            int counter = 0;
            for (RbelModificationDescription modification : configuration.getModifications()) {
                if (modification.getName() == null) {
                    modification.setName("TigerModification #" + counter++);
                }
                this.getRbelLogger().getRbelModifier().addModification(modification);
            }
        }
    }

    public void restartMockserver() {
        if (this.getTigerProxyConfiguration().getProxyPort() == null) {
            this.getTigerProxyConfiguration().setProxyPort(Integer.valueOf(this.mockServer.getLocalPort()));
        }
        this.mockServer.stop();
        this.mockServerClient.stop();
        Map<String, TigerRoute> originalRoutes = Collections.unmodifiableMap(this.tigerRouteMap);
        this.tigerRouteMap.clear();
        this.bootMockServer();
        originalRoutes.values().stream().filter(r -> !r.isInternalRoute()).forEach(r -> {
            try {
                this.addRoute((TigerRoute)r);
            }
            catch (RuntimeException e) {
                this.log.trace("Ignored exception during re-adding of routes", (Throwable)e);
            }
        });
    }

    private void bootMockServer() {
        this.createNewMockServer();
        this.buildMockServerClient();
    }

    private void buildMockServerClient() {
        this.mockServerClient = new MockServerClient("localhost", this.mockServer.getLocalPort());
        if (this.getTigerProxyConfiguration().isActivateForwardAllLogging()) {
            this.mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(".*"), Times.unlimited(), TimeToLive.unlimited(), Integer.valueOf(Integer.MIN_VALUE)).forward((ExpectationForwardCallback)new ForwardAllCallback(this));
        }
        this.addRoutesToTigerProxy();
    }

    private void createNewMockServer() {
        KeyAndCertificateFactoryFactory.setCustomKeyAndCertificateFactorySupplier((KeyAndCertificateFactorySupplier)this.buildKeyAndCertificateFactory());
        Configuration mockServerConfiguration = Configuration.configuration();
        mockServerConfiguration.forwardProxyTLSX509CertificatesTrustManagerType(ForwardProxyTLSX509CertificatesTrustManager.ANY);
        mockServerConfiguration.maxLogEntries(Integer.valueOf(0));
        if (StringUtils.isNotEmpty((CharSequence)this.getTigerProxyConfiguration().getProxyLogLevel())) {
            mockServerConfiguration.logLevel(this.getTigerProxyConfiguration().getProxyLogLevel());
        } else {
            mockServerConfiguration.logLevel("WARN");
        }
        this.customizeSslSuitesIfApplicable();
        Optional<ProxyConfiguration> forwardProxyConfig = ProxyConfigurationConverter.convertForwardProxyConfigurationToMockServerConfiguration(this.getTigerProxyConfiguration());
        this.outputForwardProxyConfigLogs(forwardProxyConfig);
        this.mockServer = this.getTigerProxyConfiguration().getDirectReverseProxy() == null ? forwardProxyConfig.map(proxyConfiguration -> new MockServer(proxyConfiguration, this.getTigerProxyConfiguration().getPortAsArray())).orElseGet(() -> new MockServer(this.getTigerProxyConfiguration().getPortAsArray())) : this.spawnDirectInverseTigerProxy(mockServerConfiguration, forwardProxyConfig);
        this.log.info("Proxy '{}' started on port {}", (Object)this.getName().orElse("?"), (Object)this.mockServer.getLocalPort());
    }

    private void addRoutesToTigerProxy() {
        if (this.getTigerProxyConfiguration().getProxyRoutes() != null) {
            for (TigerRoute tigerRoute : this.getTigerProxyConfiguration().getProxyRoutes()) {
                this.addRoute(tigerRoute);
            }
        }
    }

    private MockServer spawnDirectInverseTigerProxy(Configuration mockServerConfiguration, Optional<ProxyConfiguration> forwardProxyConfig) {
        mockServerConfiguration.forwardBinaryRequestsWithoutWaitingForResponse(Boolean.valueOf(true));
        mockServerConfiguration.binaryProxyListener((BinaryProxyListener)new BinaryExchangeHandler(this));
        if (forwardProxyConfig.isPresent()) {
            throw new TigerProxyStartupException("DirectForwardProxy configured with additional forwardProxy: Not possible! (forwardProxy is always HTTP!)");
        }
        MockServer mockServer = new MockServer(mockServerConfiguration, this.getTigerProxyConfiguration().getDirectReverseProxy().getPort(), this.getTigerProxyConfiguration().getDirectReverseProxy().getHostname(), this.getTigerProxyConfiguration().getPortAsArray());
        this.addReverseProxyRouteIfNotPresent();
        return mockServer;
    }

    private void addReverseProxyRouteIfNotPresent() {
        if (this.getTigerProxyConfiguration().getProxyRoutes() == null) {
            this.getTigerProxyConfiguration().setProxyRoutes(new ArrayList());
        }
        this.getTigerProxyConfiguration().getProxyRoutes().add(TigerRoute.builder().from("/").to("http://" + this.getTigerProxyConfiguration().getDirectReverseProxy().getHostname() + ":" + this.getTigerProxyConfiguration().getDirectReverseProxy().getPort()).build());
    }

    private void customizeSslSuitesIfApplicable() {
        TigerTlsConfiguration tlsConfiguration = this.getTigerProxyConfiguration().getTls();
        NettySslContextFactory.sslServerContextBuilderCustomizer = tlsConfiguration.getServerSslSuites() != null || tlsConfiguration.getServerTlsProtocols() != null ? builder -> {
            if (tlsConfiguration.getServerSslSuites() != null) {
                builder.ciphers((Iterable)tlsConfiguration.getServerSslSuites());
            }
            if (tlsConfiguration.getServerTlsProtocols() != null) {
                builder.protocols((Iterable)tlsConfiguration.getServerTlsProtocols());
            }
            builder.sslProvider(SslProvider.JDK);
            return builder;
        } : UnaryOperator.identity();
        NettySslContextFactory.sslClientContextBuilderCustomizer = tlsConfiguration.getClientSslSuites() != null ? builder -> {
            builder.ciphers((Iterable)tlsConfiguration.getClientSslSuites());
            builder.sslProvider(SslProvider.JDK);
            return builder;
        } : UnaryOperator.identity();
    }

    private KeyAndCertificateFactorySupplier buildKeyAndCertificateFactory() {
        return (mockServerLogger, isServerInstance, mockServerConfiguration) -> {
            if (isServerInstance) {
                if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getServerIdentity() != null) {
                    return new StaticTigerKeyAndCertificateFactory(mockServerLogger, this.getTigerProxyConfiguration(), (TigerPkiIdentity)this.getTigerProxyConfiguration().getTls().getServerIdentity());
                }
                DynamicTigerKeyAndCertificateFactory dynamicTigerKeyAndCertificateFactory = new DynamicTigerKeyAndCertificateFactory(mockServerLogger, this.getTigerProxyConfiguration(), this.determineServerRootCa().orElseThrow(() -> new TigerProxyStartupException("Unrecoverable TLS startup state")));
                this.tlsFactories.add(dynamicTigerKeyAndCertificateFactory);
                return dynamicTigerKeyAndCertificateFactory;
            }
            if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity() != null) {
                return new StaticTigerKeyAndCertificateFactory(mockServerLogger, this.getTigerProxyConfiguration(), (TigerPkiIdentity)this.getTigerProxyConfiguration().getTls().getForwardMutualTlsIdentity());
            }
            return new BCKeyAndCertificateFactory(mockServerConfiguration, mockServerLogger);
        };
    }

    private Optional<TigerPkiIdentity> determineServerRootCa() {
        if (this.getTigerProxyConfiguration().getTls().getServerRootCa() != null) {
            return Optional.ofNullable(this.getTigerProxyConfiguration().getTls().getServerRootCa());
        }
        if (this.generatedRootCa == null) {
            this.generatedRootCa = TlsCertificateGenerator.generateNewCaCertificate();
        }
        return Optional.of(this.generatedRootCa);
    }

    public void subscribeToTrafficEndpoints(TigerProxyConfiguration configuration) {
        Optional.of(configuration).filter(Objects::nonNull).map(TigerProxyConfiguration::getTrafficEndpoints).ifPresent(this::subscribeToTrafficEndpoints);
    }

    public void subscribeToTrafficEndpoints(List<String> trafficEndpointUrls) {
        ((Stream)Optional.of(trafficEndpointUrls).filter(Objects::nonNull).stream().flatMap(Collection::stream).parallel()).map(url -> new TigerRemoteProxyClient((String)url, TigerProxyConfiguration.builder().downloadInitialTrafficFromEndpoints(this.getTigerProxyConfiguration().isDownloadInitialTrafficFromEndpoints()).trafficEndpointFilterString(this.getTigerProxyConfiguration().getTrafficEndpointFilterString()).name(this.getTigerProxyConfiguration().getName()).connectionTimeoutInSeconds(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds()).build(), this)).forEach(this.remoteProxyClients::add);
        this.remoteProxyClients.parallelStream().forEach(TigerRemoteProxyClient::connect);
    }

    @Override
    public String getBaseUrl() {
        return "http://localhost:" + this.mockServer.getLocalPort();
    }

    @Override
    public int getProxyPort() {
        return this.mockServer.getLocalPort();
    }

    public int getAdminPort() {
        return this.getTigerProxyConfiguration().getAdminPort();
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return this.tigerRouteMap.values().stream().collect(Collectors.toUnmodifiableList());
    }

    @Override
    public RbelModificationDescription addModificaton(RbelModificationDescription modification) {
        this.getRbelLogger().getRbelModifier().addModification(modification);
        return modification;
    }

    @Override
    public List<RbelModificationDescription> getModifications() {
        return this.getRbelLogger().getRbelModifier().getModifications();
    }

    @Override
    public void removeModification(String modificationId) {
        this.getRbelLogger().getRbelModifier().deleteModification(modificationId);
    }

    @Override
    public synchronized TigerRoute addRoute(TigerRoute tigerRoute) {
        this.assertThatRouteIsUnique(tigerRoute);
        this.log.info("Adding route {} -> {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        Expectation[] expectations = this.buildRouteAndReturnExpectation(tigerRoute);
        if (expectations.length > 1) {
            this.log.warn("Unexpected number of expectations created! Got {}, expected 1", (Object)expectations.length);
        }
        if (expectations.length == 0) {
            throw new TigerProxyConfigurationException("Error while adding route from '{}' to '{}': Got 0 new expectations");
        }
        TigerRoute createdTigerRoute = tigerRoute.withId(expectations[0].getId());
        this.tigerRouteMap.put(expectations[0].getId(), createdTigerRoute);
        this.log.info("Created route {} with expectation {}", (Object)createdTigerRoute, (Object)expectations[0]);
        return createdTigerRoute;
    }

    private void assertThatRouteIsUnique(TigerRoute tigerRoute) {
        this.tigerRouteMap.values().stream().filter(existingRoute -> this.uriTwoIsBelowUriOne(existingRoute.getFrom(), tigerRoute.getFrom()) || this.uriTwoIsBelowUriOne(tigerRoute.getFrom(), existingRoute.getFrom())).findAny().ifPresent(existingRoute -> {
            throw new TigerProxyRouteConflictException((TigerRoute)existingRoute);
        });
    }

    private boolean uriTwoIsBelowUriOne(String value1, String value2) {
        try {
            URI uri1 = new URI(value1);
            URI uri2WithUri1Scheme = new URIBuilder(value2).setScheme(uri1.getScheme()).build();
            return !new URI(value1).relativize(uri2WithUri1Scheme).equals(uri2WithUri1Scheme);
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private Expectation[] buildRouteAndReturnExpectation(TigerRoute tigerRoute) {
        if (UriUtil.hasScheme((CharSequence)tigerRoute.getFrom())) {
            return this.buildForwardProxyRoute(tigerRoute);
        }
        return this.buildReverseProxyRoute(tigerRoute);
    }

    private Expectation[] buildReverseProxyRoute(TigerRoute tigerRoute) {
        return this.mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(tigerRoute.getFrom() + ".*")).forward((ExpectationForwardCallback)new ReverseProxyCallback(this, tigerRoute));
    }

    private Expectation[] buildForwardProxyRoute(TigerRoute tigerRoute) {
        URL url = TigerProxy.buildUrlSafe(tigerRoute);
        return this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", new String[]{url.getAuthority()}).withSecure(Boolean.valueOf(url.getProtocol().equals("https")))).forward((ExpectationForwardCallback)new ForwardProxyCallback(this, tigerRoute));
    }

    private static URL buildUrlSafe(TigerRoute tigerRoute) {
        try {
            return new URL(tigerRoute.getFrom());
        }
        catch (MalformedURLException e) {
            throw new TigerProxyStartupException("Error while building route", e);
        }
    }

    public void addAlternativeName(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return;
        }
        ArrayList<String> newAlternativeNames = new ArrayList<String>();
        if (this.getTigerProxyConfiguration().getTls() != null && this.getTigerProxyConfiguration().getTls().getAlternativeNames() != null) {
            newAlternativeNames.addAll(this.getTigerProxyConfiguration().getTls().getAlternativeNames());
        }
        newAlternativeNames.add(host);
        this.getTigerProxyConfiguration().getTls().setAlternativeNames(newAlternativeNames);
        for (DynamicTigerKeyAndCertificateFactory tlsFactory : this.tlsFactories) {
            tlsFactory.addAlternativeName(host);
            tlsFactory.resetEeCertificate();
        }
    }

    @Override
    public void removeRoute(String routeId) {
        if (!this.mockServer.isRunning()) {
            return;
        }
        this.mockServerClient.clear(new ExpectationId().withId(routeId));
        TigerRoute route = this.tigerRouteMap.remove(routeId);
        this.log.info("Deleted route {}. Current # expectations {}", (Object)route, (Object)this.mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request()).length);
    }

    public SSLContext getConfiguredTigerProxySslContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, new TrustManager[]{this.buildTrustManagerForTigerProxy()}, null);
            SSLContext.setDefault(sslContext);
            return sslContext;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while configuring SSL Context for Tiger Proxy", e);
        }
    }

    public X509TrustManager buildTrustManagerForTigerProxy() {
        try {
            final X509TrustManager defaultTrustManager = this.extractTrustManager(null);
            final X509TrustManager customTrustManager = this.extractTrustManager(this.buildTruststore());
            return new X509TrustManager(){

                @Override
                public X509Certificate[] getAcceptedIssuers() {
                    return defaultTrustManager.getAcceptedIssuers();
                }

                @Override
                public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    try {
                        customTrustManager.checkServerTrusted(chain, authType);
                    }
                    catch (CertificateException e) {
                        defaultTrustManager.checkServerTrusted(chain, authType);
                    }
                }

                @Override
                public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                    defaultTrustManager.checkClientTrusted(chain, authType);
                }
            };
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building TrustManager for Tiger Proxy", e);
        }
    }

    private X509TrustManager extractTrustManager(KeyStore keystore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(keystore);
        return (X509TrustManager)Arrays.stream(trustManagerFactory.getTrustManagers()).filter(X509TrustManager.class::isInstance).findAny().orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Error while configuring TrustManager for Tiger Proxy"));
    }

    public KeyStore buildTruststore() {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            TigerPkiIdentity serverIdentity = this.determineServerRootCa().or(() -> Optional.ofNullable(this.getTigerProxyConfiguration().getTls()).map(TigerTlsConfiguration::getServerIdentity).filter(Objects::nonNull)).orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Unrecoverable state: Server-Identity null and Server-CA empty"));
            ks.setCertificateEntry(CA_CERT_ALIAS, serverIdentity.getCertificate());
            int chainCertCtr = 0;
            for (X509Certificate chainCert : serverIdentity.getCertificateChain()) {
                ks.setCertificateEntry("chainCert" + chainCertCtr++, chainCert);
            }
            return ks;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    public SSLContext buildSslContext() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.buildTruststore());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            TrustManager[] trustManagers = tmf.getTrustManagers();
            sslContext.init(null, trustManagers, null);
            CloseableHttpClient httpClient = HttpClients.custom().setSSLContext(sslContext).setSSLHostnameVerifier((HostnameVerifier)new DefaultHostnameVerifier()).build();
            Unirest.primaryInstance().config().httpClient(arg_0 -> TigerProxy.lambda$buildSslContext$14((HttpClient)httpClient, arg_0));
            return sslContext;
        }
        catch (RuntimeException | KeyManagementException | KeyStoreException | NoSuchAlgorithmException e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for Tiger Proxy", e);
        }
    }

    private void outputForwardProxyConfigLogs(Optional<ProxyConfiguration> forwardProxyConfig) {
        if (forwardProxyConfig.isEmpty()) {
            this.log.info("Tigerproxy has NO forward proxy configured!");
        } else {
            ProxyConfiguration configNotEmpty = forwardProxyConfig.get();
            if (configNotEmpty.getUsername() == null) {
                this.log.info("Forward proxy is set to " + configNotEmpty.getType() + "://" + configNotEmpty.getProxyAddress().getHostName() + ":" + configNotEmpty.getProxyAddress().getPort());
            } else if (configNotEmpty.getUsername() != null) {
                this.log.info("Forward proxy is set to " + configNotEmpty.getType() + "://" + configNotEmpty.getProxyAddress().getHostName() + ":" + configNotEmpty.getProxyAddress().getPort() + "@" + configNotEmpty.getUsername() + ":" + configNotEmpty.getPassword());
            }
        }
    }

    public void propagateException(Throwable exception) {
        this.exceptionListeners.forEach(consumer -> consumer.accept(exception));
    }

    public void addNewExceptionConsumer(Consumer<Throwable> newConsumer) {
        this.exceptionListeners.add(newConsumer);
    }

    @Override
    @PreDestroy
    public void close() {
        this.log.info("Shutting down Tiger-Proxy {}", (Object)this.getName().orElse(""));
        super.close();
        this.remoteProxyClients.forEach(TigerRemoteProxyClient::close);
        this.mockServerClient.stop();
        this.mockServer.stop();
        NettySslContextFactory.sslServerContextBuilderCustomizer = UnaryOperator.identity();
        KeyAndCertificateFactoryFactory.setCustomKeyAndCertificateFactorySupplier(null);
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerProxy)) {
            return false;
        }
        TigerProxy other = (TigerProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<DynamicTigerKeyAndCertificateFactory> this$tlsFactories = this.tlsFactories;
        List<DynamicTigerKeyAndCertificateFactory> other$tlsFactories = other.tlsFactories;
        if (this$tlsFactories == null ? other$tlsFactories != null : !((Object)this$tlsFactories).equals(other$tlsFactories)) {
            return false;
        }
        List<Consumer<Throwable>> this$exceptionListeners = this.exceptionListeners;
        List<Consumer<Throwable>> other$exceptionListeners = other.exceptionListeners;
        if (this$exceptionListeners == null ? other$exceptionListeners != null : !((Object)this$exceptionListeners).equals(other$exceptionListeners)) {
            return false;
        }
        MockServer this$mockServer = this.mockServer;
        MockServer other$mockServer = other.mockServer;
        if (this$mockServer == null ? other$mockServer != null : !this$mockServer.equals(other$mockServer)) {
            return false;
        }
        MockServerClient this$mockServerClient = this.mockServerClient;
        MockServerClient other$mockServerClient = other.mockServerClient;
        if (this$mockServerClient == null ? other$mockServerClient != null : !this$mockServerClient.equals(other$mockServerClient)) {
            return false;
        }
        MockServerToRbelConverter this$mockServerToRbelConverter = this.getMockServerToRbelConverter();
        MockServerToRbelConverter other$mockServerToRbelConverter = other.getMockServerToRbelConverter();
        if (this$mockServerToRbelConverter == null ? other$mockServerToRbelConverter != null : !this$mockServerToRbelConverter.equals(other$mockServerToRbelConverter)) {
            return false;
        }
        Map<String, TigerRoute> this$tigerRouteMap = this.tigerRouteMap;
        Map<String, TigerRoute> other$tigerRouteMap = other.tigerRouteMap;
        if (this$tigerRouteMap == null ? other$tigerRouteMap != null : !((Object)this$tigerRouteMap).equals(other$tigerRouteMap)) {
            return false;
        }
        List<TigerRemoteProxyClient> this$remoteProxyClients = this.remoteProxyClients;
        List<TigerRemoteProxyClient> other$remoteProxyClients = other.remoteProxyClients;
        if (this$remoteProxyClients == null ? other$remoteProxyClients != null : !((Object)this$remoteProxyClients).equals(other$remoteProxyClients)) {
            return false;
        }
        TigerPkiIdentity this$generatedRootCa = this.generatedRootCa;
        TigerPkiIdentity other$generatedRootCa = other.generatedRootCa;
        if (this$generatedRootCa == null ? other$generatedRootCa != null : !this$generatedRootCa.equals(other$generatedRootCa)) {
            return false;
        }
        UUID this$healthEndpointRequestUuid = this.getHealthEndpointRequestUuid();
        UUID other$healthEndpointRequestUuid = other.getHealthEndpointRequestUuid();
        return !(this$healthEndpointRequestUuid == null ? other$healthEndpointRequestUuid != null : !((Object)this$healthEndpointRequestUuid).equals(other$healthEndpointRequestUuid));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerProxy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<DynamicTigerKeyAndCertificateFactory> $tlsFactories = this.tlsFactories;
        result = result * 59 + ($tlsFactories == null ? 43 : ((Object)$tlsFactories).hashCode());
        List<Consumer<Throwable>> $exceptionListeners = this.exceptionListeners;
        result = result * 59 + ($exceptionListeners == null ? 43 : ((Object)$exceptionListeners).hashCode());
        MockServer $mockServer = this.mockServer;
        result = result * 59 + ($mockServer == null ? 43 : $mockServer.hashCode());
        MockServerClient $mockServerClient = this.mockServerClient;
        result = result * 59 + ($mockServerClient == null ? 43 : $mockServerClient.hashCode());
        MockServerToRbelConverter $mockServerToRbelConverter = this.getMockServerToRbelConverter();
        result = result * 59 + ($mockServerToRbelConverter == null ? 43 : $mockServerToRbelConverter.hashCode());
        Map<String, TigerRoute> $tigerRouteMap = this.tigerRouteMap;
        result = result * 59 + ($tigerRouteMap == null ? 43 : ((Object)$tigerRouteMap).hashCode());
        List<TigerRemoteProxyClient> $remoteProxyClients = this.remoteProxyClients;
        result = result * 59 + ($remoteProxyClients == null ? 43 : ((Object)$remoteProxyClients).hashCode());
        TigerPkiIdentity $generatedRootCa = this.generatedRootCa;
        result = result * 59 + ($generatedRootCa == null ? 43 : $generatedRootCa.hashCode());
        UUID $healthEndpointRequestUuid = this.getHealthEndpointRequestUuid();
        result = result * 59 + ($healthEndpointRequestUuid == null ? 43 : ((Object)$healthEndpointRequestUuid).hashCode());
        return result;
    }

    @Generated
    public MockServerToRbelConverter getMockServerToRbelConverter() {
        return this.mockServerToRbelConverter;
    }

    @Generated
    public UUID getHealthEndpointRequestUuid() {
        return this.healthEndpointRequestUuid;
    }

    private static /* synthetic */ Client lambda$buildSslContext$14(HttpClient httpClient, Config config) {
        return ApacheClient.builder((HttpClient)httpClient).apply(config);
    }

    private static class TigerProxyTrustManagerBuildingException
    extends RuntimeException {
        public TigerProxyTrustManagerBuildingException(String s, Exception e) {
            super(s, e);
        }

        public TigerProxyTrustManagerBuildingException(String s) {
            super(s);
        }
    }
}

