/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.handler.AbstractTigerRouteCallback;
import java.net.URL;
import lombok.Generated;
import org.mockserver.model.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxyCallback
extends AbstractTigerRouteCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyCallback.class);
    private static final String HTTPS_PREFIX = "https://";
    private final URL targetUrl;
    private final int port;
    private final boolean addTrailingSlash;

    public ReverseProxyCallback(TigerProxy tigerProxy, TigerRoute route) {
        super(tigerProxy, route);
        if (route.getTo().endsWith("/")) {
            this.targetUrl = new URL(route.getTo().substring(0, route.getTo().length() - 1));
            this.addTrailingSlash = true;
        } else {
            this.targetUrl = new URL(route.getTo());
            this.addTrailingSlash = false;
        }
        this.port = this.targetUrl.getPort() < 0 ? (route.getTo().startsWith(HTTPS_PREFIX) ? 443 : 80) : this.targetUrl.getPort();
    }

    @Override
    public HttpRequest handleRequest(HttpRequest httpRequest) {
        this.applyModifications(httpRequest);
        HttpRequest request = this.cloneRequest(httpRequest).withSocketAddress(Boolean.valueOf(this.getTigerRoute().getTo().startsWith(HTTPS_PREFIX)), this.targetUrl.getHost(), Integer.valueOf(this.port)).withSecure(Boolean.valueOf(this.getTigerRoute().getTo().startsWith(HTTPS_PREFIX))).withPath(this.patchPath(httpRequest.getPath().getValue()));
        if (this.getTigerProxy().getTigerProxyConfiguration().isRewriteHostHeader()) {
            request.removeHeader("Host").withHeader("Host", new String[]{this.targetUrl.getHost() + ":" + this.port});
        }
        if (this.getTigerRoute().getBasicAuth() != null) {
            request.withHeader("Authorization", new String[]{this.getTigerRoute().getBasicAuth().toAuthorizationHeaderValue()});
        }
        return request;
    }

    private String patchPath(String requestPath) {
        String patchedUrl = requestPath.replaceFirst(this.targetUrl.toString(), "");
        if (!this.getTigerRoute().getFrom().equals("/")) {
            patchedUrl = patchedUrl.substring(this.getTigerRoute().getFrom().length());
        }
        if (patchedUrl.startsWith("/")) {
            if (this.addTrailingSlash && !patchedUrl.endsWith("/") && (requestPath.equals("/") || requestPath.equals(""))) {
                return this.targetUrl.getPath() + patchedUrl + "/";
            }
            return this.targetUrl.getPath() + patchedUrl;
        }
        return this.targetUrl.getPath() + "/" + patchedUrl;
    }

    @Override
    protected String extractProtocolAndHostForRequest(HttpRequest request) {
        return this.getTigerRoute().getTo();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReverseProxyCallback)) {
            return false;
        }
        ReverseProxyCallback other = (ReverseProxyCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        if (this.addTrailingSlash != other.addTrailingSlash) {
            return false;
        }
        URL this$targetUrl = this.targetUrl;
        URL other$targetUrl = other.targetUrl;
        return !(this$targetUrl == null ? other$targetUrl != null : !((Object)this$targetUrl).equals(other$targetUrl));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReverseProxyCallback;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.port;
        result = result * 59 + (this.addTrailingSlash ? 79 : 97);
        URL $targetUrl = this.targetUrl;
        result = result * 59 + ($targetUrl == null ? 43 : ((Object)$targetUrl).hashCode());
        return result;
    }
}

