/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.handler.AbstractTigerRouteCallback;
import java.net.URL;
import lombok.Generated;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ForwardProxyCallback
extends AbstractTigerRouteCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ForwardProxyCallback.class);
    private final URL targetUrl;
    private final URL sourceUrl;
    private final int port;
    private final boolean addTrailingSlash;

    public ForwardProxyCallback(TigerProxy tigerProxy, TigerRoute tigerRoute) {
        super(tigerProxy, tigerRoute);
        if (tigerRoute.getTo().endsWith("/")) {
            this.targetUrl = new URL(tigerRoute.getTo().substring(0, tigerRoute.getTo().length() - 1));
            this.addTrailingSlash = true;
        } else {
            this.targetUrl = new URL(tigerRoute.getTo());
            this.addTrailingSlash = false;
        }
        this.sourceUrl = new URL(tigerRoute.getFrom());
        this.port = this.targetUrl.getPort() < 0 ? (tigerRoute.getTo().startsWith("https://") ? 443 : 80) : this.targetUrl.getPort();
        tigerProxy.addAlternativeName(this.sourceUrl.getHost());
    }

    @Override
    public HttpRequest handleRequest(HttpRequest req) {
        this.applyModifications(req);
        req.replaceHeader(Header.header((String)"Host", (String[])new String[]{this.targetUrl.getHost() + ":" + this.port}));
        if (this.getTigerRoute().getBasicAuth() != null) {
            req.replaceHeader(Header.header((String)"Authorization", (String[])new String[]{this.getTigerRoute().getBasicAuth().toAuthorizationHeaderValue()}));
        }
        String path = req.getPath().toString().equals("/") ? this.targetUrl.getPath() + "/" : this.targetUrl.getPath() + req.getPath();
        return this.cloneRequest(req).withPath(path).withSecure(Boolean.valueOf(this.getTigerRoute().getTo().startsWith("https://"))).withQueryStringParameters(req.getQueryStringParameters());
    }

    @Override
    protected String extractProtocolAndHostForRequest(HttpRequest request) {
        return this.sourceUrl.getProtocol() + "://" + this.sourceUrl.getHost();
    }
}

