/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.handler.AbstractTigerRouteCallback;
import java.net.URI;
import lombok.Generated;
import org.mockserver.model.HttpRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReverseProxyCallback
extends AbstractTigerRouteCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ReverseProxyCallback.class);
    private static final String HTTPS_PREFIX = "https://";
    private final URI targetUri;
    private final int port;

    public ReverseProxyCallback(TigerProxy tigerProxy, TigerRoute route) {
        super(tigerProxy, route);
        this.targetUri = new URI(route.getTo());
        this.port = this.targetUri.getPort() < 0 ? (route.getTo().startsWith(HTTPS_PREFIX) ? 443 : 80) : this.targetUri.getPort();
    }

    @Override
    public HttpRequest handleRequest(HttpRequest httpRequest) {
        this.applyModifications(httpRequest);
        HttpRequest request = this.cloneRequest(httpRequest).withSocketAddress(Boolean.valueOf(this.getTigerRoute().getTo().startsWith(HTTPS_PREFIX)), this.targetUri.getHost(), Integer.valueOf(this.port)).withSecure(Boolean.valueOf(this.getTigerRoute().getTo().startsWith(HTTPS_PREFIX))).withPath(this.patchPath(httpRequest.getPath().getValue()));
        if (this.getTigerProxy().getTigerProxyConfiguration().isRewriteHostHeader()) {
            request.removeHeader("Host").withHeader("Host", new String[]{this.targetUri.getHost() + ":" + this.port});
        }
        if (this.getTigerRoute().getBasicAuth() != null) {
            request.withHeader("Authorization", new String[]{this.getTigerRoute().getBasicAuth().toAuthorizationHeaderValue()});
        }
        return request;
    }

    private String patchPath(String requestPath) {
        String patchedUrl = requestPath.replaceFirst(this.targetUri.toString(), "");
        if (!this.getTigerRoute().getFrom().equals("/")) {
            patchedUrl = patchedUrl.substring(this.getTigerRoute().getFrom().length());
        }
        if (patchedUrl.startsWith("/")) {
            return this.targetUri.getPath() + patchedUrl;
        }
        return this.targetUri.getPath() + "/" + patchedUrl;
    }

    @Override
    protected String extractProtocolAndHostForRequest(HttpRequest request) {
        return this.getTigerRoute().getTo();
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReverseProxyCallback)) {
            return false;
        }
        ReverseProxyCallback other = (ReverseProxyCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.port != other.port) {
            return false;
        }
        URI this$targetUri = this.targetUri;
        URI other$targetUri = other.targetUri;
        return !(this$targetUri == null ? other$targetUri != null : !((Object)this$targetUri).equals(other$targetUri));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReverseProxyCallback;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.port;
        URI $targetUri = this.targetUri;
        result = result * 59 + ($targetUri == null ? 43 : ((Object)$targetUri).hashCode());
        return result;
    }
}

