/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.handler;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelBinaryFacet;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.TigerNonPairedMessageFacet;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import java.beans.ConstructorProperties;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.bouncycastle.util.Arrays;
import org.mockserver.model.BinaryMessage;
import org.mockserver.model.BinaryProxyListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BinaryExchangeHandler
implements BinaryProxyListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BinaryExchangeHandler.class);
    private final TigerProxy tigerProxy;
    private final Map<Pair<SocketAddress, SocketAddress>, byte[]> bufferedParts = new HashMap<Pair<SocketAddress, SocketAddress>, byte[]>();

    public void onProxy(BinaryMessage binaryRequest, CompletableFuture<BinaryMessage> binaryResponseFuture, SocketAddress serverAddress, SocketAddress clientAddress) {
        try {
            log.info("Finalizing binary exchange...");
            Optional<RbelElement> convertedRequest = this.convertBinaryMessageOrPushToBuffer(binaryRequest, clientAddress, serverAddress);
            log.info("converted request, now waiting on response...");
            boolean shouldWaitForResponse = this.shouldWaitForResponse(convertedRequest);
            if (!shouldWaitForResponse) {
                convertedRequest.ifPresent(msg -> {
                    msg.addFacet((RbelFacet)new TigerNonPairedMessageFacet());
                    this.getTigerProxy().triggerListener((RbelElement)msg);
                });
            }
            ((CompletableFuture)((CompletableFuture)binaryResponseFuture.thenApply(binaryResponse -> this.convertBinaryMessageOrPushToBuffer((BinaryMessage)binaryResponse, serverAddress, clientAddress))).thenAccept(convertedResponse -> {
                if (shouldWaitForResponse) {
                    if (convertedResponse.isPresent() && convertedRequest.isPresent()) {
                        TracingMessagePairFacet pairFacet = new TracingMessagePairFacet((RbelElement)convertedResponse.get(), (RbelElement)convertedRequest.get());
                        ((RbelElement)convertedRequest.get()).addFacet((RbelFacet)pairFacet);
                        ((RbelElement)convertedResponse.get()).addFacet((RbelFacet)pairFacet);
                        this.getTigerProxy().triggerListener((RbelElement)convertedRequest.get());
                        this.getTigerProxy().triggerListener((RbelElement)convertedResponse.get());
                    } else {
                        convertedRequest.or(() -> convertedResponse).ifPresent(msg -> {
                            msg.addFacet((RbelFacet)new TigerNonPairedMessageFacet());
                            this.getTigerProxy().triggerListener((RbelElement)msg);
                        });
                    }
                } else {
                    convertedResponse.ifPresent(msg -> {
                        msg.addFacet((RbelFacet)new TigerNonPairedMessageFacet());
                        this.getTigerProxy().triggerListener((RbelElement)msg);
                    });
                }
            })).exceptionally(t -> {
                log.warn("Exception during Direct-Proxy handling:", t);
                this.propagateExceptionMessageSafe((Throwable)t);
                return null;
            });
            log.trace("Returning from BinaryExchangeHandler!");
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of request", (Throwable)e);
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    private boolean shouldWaitForResponse(Optional<RbelElement> convertedRequest) {
        return convertedRequest.map(RbelElement::getFacets).stream().flatMap(Collection::stream).anyMatch(RbelFacet::shouldExpectReplyMessage);
    }

    private Optional<RbelElement> convertBinaryMessageOrPushToBuffer(BinaryMessage message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        if (message == null) {
            return Optional.empty();
        }
        Optional<RbelElement> rbelMessageOptional = this.tryToConvertMessageAndBufferUnusedBytes(message, senderAddress, receiverAddress);
        if (rbelMessageOptional.isEmpty()) {
            return Optional.empty();
        }
        rbelMessageOptional.get().addFacet((RbelFacet)RbelMessageTimingFacet.builder().transmissionTime(message.getTimestamp().atZone(ZoneId.systemDefault())).build());
        rbelMessageOptional.get().addFacet((RbelFacet)new RbelBinaryFacet());
        log.info("Finalized binary exchange {}", (Object)rbelMessageOptional.flatMap(msg -> msg.getFacet(RbelTcpIpMessageFacet.class)).map(RbelTcpIpMessageFacet::getSenderHostname).map(Objects::toString).orElse(""));
        return rbelMessageOptional;
    }

    private Optional<RbelElement> tryToConvertMessageAndBufferUnusedBytes(BinaryMessage message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        Optional<RbelElement> requestOptional = this.tryToConvertMessage(message.getBytes(), senderAddress, receiverAddress).or(() -> this.addBufferToMessage(message, senderAddress, receiverAddress).flatMap(addedBufferBytes -> this.tryToConvertMessage((byte[])addedBufferBytes, senderAddress, receiverAddress)));
        if (requestOptional.isEmpty()) {
            Pair key = Pair.of((Object)senderAddress, (Object)receiverAddress);
            byte[] previouslyBufferedBytes = this.bufferedParts.get(key);
            if (previouslyBufferedBytes == null) {
                this.bufferedParts.put((Pair<SocketAddress, SocketAddress>)key, message.getBytes());
            } else {
                this.bufferedParts.put((Pair<SocketAddress, SocketAddress>)key, Arrays.concatenate((byte[])previouslyBufferedBytes, (byte[])message.getBytes()));
            }
        }
        return requestOptional;
    }

    private Optional<byte[]> addBufferToMessage(BinaryMessage message, SocketAddress senderAddress, SocketAddress receiverAddress) {
        byte[] bufferedBytes = this.bufferedParts.get(Pair.of((Object)senderAddress, (Object)receiverAddress));
        if (bufferedBytes == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(Arrays.concatenate((byte[])bufferedBytes, (byte[])message.getBytes()));
    }

    private Optional<RbelElement> tryToConvertMessage(byte[] messageContent, SocketAddress senderAddress, SocketAddress receiverAddress) {
        RbelElement result = this.getTigerProxy().getRbelLogger().getRbelConverter().parseMessage(messageContent, this.toRbelHostname(senderAddress), this.toRbelHostname(receiverAddress), Optional.empty());
        if (result.getFacets().size() <= 1) {
            this.getTigerProxy().getRbelLogger().getRbelConverter().removeMessage(result);
            return Optional.empty();
        }
        return Optional.of(result);
    }

    private void propagateExceptionMessageSafe(Throwable exception) {
        try {
            this.tigerProxy.propagateException(exception);
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occured (ignoring):", (Throwable)handlingException);
        }
    }

    private RbelHostname toRbelHostname(SocketAddress socketAddress) {
        if (socketAddress instanceof InetSocketAddress) {
            return RbelHostname.builder().hostname(((InetSocketAddress)socketAddress).getHostName()).port(((InetSocketAddress)socketAddress).getPort()).build();
        }
        log.warn("Incompatible socketAddress encountered: " + socketAddress.getClass().getSimpleName());
        return null;
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public Map<Pair<SocketAddress, SocketAddress>, byte[]> getBufferedParts() {
        return this.bufferedParts;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BinaryExchangeHandler)) {
            return false;
        }
        BinaryExchangeHandler other = (BinaryExchangeHandler)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        Map<Pair<SocketAddress, SocketAddress>, byte[]> this$bufferedParts = this.getBufferedParts();
        Map<Pair<SocketAddress, SocketAddress>, byte[]> other$bufferedParts = other.getBufferedParts();
        return !(this$bufferedParts == null ? other$bufferedParts != null : !((Object)this$bufferedParts).equals(other$bufferedParts));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BinaryExchangeHandler;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        Map<Pair<SocketAddress, SocketAddress>, byte[]> $bufferedParts = this.getBufferedParts();
        result = result * 59 + ($bufferedParts == null ? 43 : ((Object)$bufferedParts).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BinaryExchangeHandler(tigerProxy=" + this.getTigerProxy() + ", bufferedParts=" + this.getBufferedParts() + ")";
    }

    @ConstructorProperties(value={"tigerProxy"})
    @Generated
    public BinaryExchangeHandler(TigerProxy tigerProxy) {
        this.tigerProxy = tigerProxy;
    }
}

