/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.controller;

import com.google.common.html.HtmlEscapers;
import de.gematik.rbellogger.converter.RbelJexlExecutor;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.util.RbelElementTreePrinter;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.rbellogger.renderer.RbelHtmlRenderingToolkit;
import de.gematik.rbellogger.util.RbelAnsiColors;
import de.gematik.rbellogger.util.RbelFileWriter;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.configuration.ApplicationConfiguration;
import de.gematik.test.tiger.proxy.data.GetMessagesAfterDto;
import de.gematik.test.tiger.proxy.data.HtmlMessage;
import de.gematik.test.tiger.proxy.data.JexlQueryResponseDto;
import de.gematik.test.tiger.proxy.data.MessageMetaDataDto;
import de.gematik.test.tiger.proxy.data.ResetMessagesDto;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyWebUiException;
import de.gematik.test.tiger.spring_utils.TigerBuildPropertiesService;
import j2html.TagCreator;
import j2html.tags.DomContent;
import j2html.tags.specialized.ATag;
import j2html.tags.specialized.ButtonTag;
import j2html.tags.specialized.DivTag;
import j2html.tags.specialized.ITag;
import j2html.tags.specialized.NavTag;
import j2html.tags.specialized.SpanTag;
import java.beans.ConstructorProperties;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"webui"})
@Validated
public class TigerWebUiController
implements ApplicationContextAware {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerWebUiController.class);
    private final TigerProxy tigerProxy;
    private final RbelHtmlRenderer renderer;
    private final ApplicationConfiguration applicationConfiguration;
    private ApplicationContext applicationContext;
    public final SimpMessagingTemplate template;
    private final TigerBuildPropertiesService buildProperties;
    private static final String COLOR_INHERIT = "color:inherit;";
    private static final String WS_NEWMESSAGES = "/topic/ws";

    @PostConstruct
    public void addWebSocketListener() {
        this.tigerProxy.addRbelMessageListener(this::informClientOfNewMessageArrival);
        this.renderer.setSubTitle(this.getVersionStringAsRawHtml() + this.renderer.getSubTitle());
    }

    private void informClientOfNewMessageArrival(RbelElement element) {
        log.trace("Propagating new message (uUID: {}) from proxy {}", (Object)element.getUuid(), (Object)this.tigerProxy.proxyName());
        this.template.convertAndSend((Object)WS_NEWMESSAGES, (Object)element.getUuid());
    }

    public void setApplicationContext(ApplicationContext appContext) throws BeansException {
        this.applicationContext = appContext;
    }

    @GetMapping(value={"/trafficLog*.tgr"}, produces={"application/octet-stream"})
    public String downloadTraffic(@RequestParam(name="lastMsgUuid", required=false) String lastMsgUuid, @RequestParam(name="pageSize", required=false) Optional<Integer> pageSize, HttpServletResponse response) {
        int actualPageSize = pageSize.orElse(this.getApplicationConfiguration().getMaximumTrafficDownloadPageSize());
        ArrayList filteredMessages = this.getTigerProxy().getRbelLogger().getMessageHistory().stream().dropWhile(TigerWebUiController.messageIsBefore(lastMsgUuid)).filter(msg -> !msg.getUuid().equals(lastMsgUuid)).collect(Collectors.toCollection(ArrayList::new));
        int returnedMessages = Math.min(filteredMessages.size(), actualPageSize);
        response.addHeader("available-messages", String.valueOf(filteredMessages.size()));
        response.addHeader("returned-messages", String.valueOf(returnedMessages));
        String result = filteredMessages.stream().limit(actualPageSize).map(arg_0 -> ((RbelFileWriter)this.tigerProxy.getRbelFileWriter()).convertToRbelFileString(arg_0)).collect(Collectors.joining("\n\n"));
        if (!result.isEmpty()) {
            response.addHeader("last-uuid", ((RbelElement)filteredMessages.get(returnedMessages - 1)).getUuid());
        }
        return result;
    }

    @GetMapping(value={""}, produces={"text/html"})
    public String getUI(@RequestParam(defaultValue="false") boolean embedded) {
        String html = this.renderer.getEmptyPage();
        String targetDiv = embedded ? "<div class=\"column msglist embeddedlist\">" : "<div class=\"column ml-6 msglist\">";
        html = this.replaceScript(html.replace("<div class=\"column ml-6\">", targetDiv));
        if (this.applicationConfiguration.isLocalResources()) {
            log.info("Running with local resources...");
            html = html.replace("https://cdn.jsdelivr.net/npm/bulma@0.9.1/css/bulma.min.css", "/webui/css/bulma.min.css").replace("https://jenil.github.io/bulmaswatch/simplex/bulmaswatch.min.css", "/webui/css/bulmaswatch.min.css").replace("https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.2/css/all.min.css", "/webui/css/all.min.css");
        }
        String navbar = embedded ? this.createNavbar(this.tigerProxy, "margin-bottom: 4em;", "margin-inline: auto;") : this.createNavbar(this.tigerProxy, "", "");
        String configJSSnippetStr = this.loadResourceToString("/configScript.html").replace("${ProxyPort}", String.valueOf(this.tigerProxy.getProxyPort())).replace("${FilenamePattern}", this.applicationConfiguration.getFilenamePattern()).replace("${UploadUrl}", this.applicationConfiguration.getUploadUrl());
        return html.replace("<div id=\"navbardiv\"></div>", navbar + this.loadResourceToString("/routeModal.html") + this.loadResourceToString("/filterModal.html") + this.loadResourceToString("/jexlModal.html") + this.loadResourceToString("/saveModal.html")).replace("</body>", configJSSnippetStr + "</body>");
    }

    private String getVersionStringAsRawHtml() {
        return "<div class=\"is-size-6\" style=\"text-align: right;margin-bottom: 1rem!important;margin-right: 1.5em;\">" + this.buildProperties.tigerVersionAsString() + " - " + this.buildProperties.tigerBuildDateAsString() + "</div>";
    }

    private String getNavbarItemNot4embedded() {
        return "navbar-item not4embedded";
    }

    private String navbarItem() {
        return "navbar-item";
    }

    private String darkButton() {
        return "button is-dark";
    }

    private String successOutlineButton() {
        return "button is-outlined is-success";
    }

    private String createNavbar(TigerProxy tigerProxy, String styleNavbar, String styleNavbarStart) {
        return ((NavTag)((NavTag)((NavTag)TagCreator.nav().withClass("navbar is-dark is-fixed-bottom")).withStyle(styleNavbar)).with((DomContent)((DivTag)TagCreator.div().withClass("navbar-menu")).with((DomContent)((DivTag)((DivTag)TagCreator.div().withClass("navbar-start")).withStyle(styleNavbarStart)).with(new DomContent[]{((DivTag)TagCreator.div().withClass(this.getNavbarItemNot4embedded())).with((DomContent)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button().withId("routeModalBtn")).withClass(this.successOutlineButton())).attr("data-target", (Object)"routeModalDialog")).with(new DomContent[]{TagCreator.i().withClass("fas fa-exchange-alt"), ((SpanTag)TagCreator.span((String)"Routes").withClass("ml-2")).withStyle(COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass(this.getNavbarItemNot4embedded())).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("scrollLockBtn")).withClass(this.darkButton())).with(new DomContent[]{((DivTag)TagCreator.div().withId("scrollLockLed")).withClass("led"), TagCreator.span((String)"Scroll Lock")})), ((DivTag)TagCreator.div().withClass("navbar-item dropdown is-up")).with(new DomContent[]{((DivTag)((DivTag)TagCreator.div().withId("dropdown-hide-button")).withClass("dropdown-trigger")).with((DomContent)((ButtonTag)TagCreator.button().withClass(this.darkButton())).with((DomContent)((SpanTag)TagCreator.span().withClass("icon is-small")).with((DomContent)TagCreator.i().withClass("fas fa-toggle-on")))), ((DivTag)((DivTag)TagCreator.div().withClass("dropdown-menu")).attr("role", (Object)"menu")).with((DomContent)((DivTag)TagCreator.div().withClass("dropdown-content-black")).with(new DomContent[]{((DivTag)TagCreator.div().withClass("dropdown-item dropdown")).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("collapsibleMessageHeaderBtn")).withClass(this.darkButton())).with(new DomContent[]{((DivTag)TagCreator.div().withId("collapsibleMessageHeader")).withClass("led"), TagCreator.span((String)"Hide Headers")})), ((DivTag)TagCreator.div().withClass("dropdown-item dropdown")).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("collapsibleMessageDetailsBtn")).withClass(this.darkButton())).with(new DomContent[]{((DivTag)TagCreator.div().withId("collapsibleMessageDetails")).withClass("led"), TagCreator.span((String)"Hide Details")}))}))}), ((DivTag)TagCreator.div().withClass(this.navbarItem())).with((DomContent)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button().withId("filterModalBtn")).withClass(this.successOutlineButton())).attr("data-target", (Object)"filterModalDialog")).with(new DomContent[]{TagCreator.i().withClass("fas fa-filter"), ((SpanTag)TagCreator.span((String)"Filter").withClass("ml-2")).withStyle(COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass(this.getNavbarItemNot4embedded() + " ml-3")).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("resetMsgs")).withClass("button is-outlined is-danger")).with(new DomContent[]{TagCreator.i().withClass("far fa-trash-alt"), ((SpanTag)TagCreator.span((String)"Reset").withClass("ml-2")).withStyle(COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass("navbar-item")).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("saveMsgs")).withClass(this.successOutlineButton())).with(new DomContent[]{TagCreator.i().withClass("far fa-save"), ((SpanTag)TagCreator.span((String)"Save").withClass("ml-2")).withStyle(COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass("navbar-item")).with((DomContent)((DivTag)((DivTag)TagCreator.div().withId("dropdown-page-selection")).withClass("dropdown is-up")).with(new DomContent[]{((DivTag)TagCreator.div().withClass("dropdown-trigger")).with((DomContent)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button().withClass(this.darkButton())).attr("aria-haspopup", (Object)"true")).attr("aria-controls", (Object)"dropdown-menu")).with(new DomContent[]{((SpanTag)TagCreator.span().withText("Page 1")).withId("pageNumberDisplay"), ((SpanTag)TagCreator.span().withClass("icon is-small")).with((DomContent)((ITag)TagCreator.i().withClass("fas fa-angle-up")).attr("aria-hidden", (Object)"true"))})), ((DivTag)((DivTag)TagCreator.div().withClass("dropdown-menu")).attr("role", (Object)"menu")).with((DomContent)((DivTag)((DivTag)TagCreator.div().withClass("dropdown-content")).withId("pageSelector")).with((DomContent)((ATag)((ATag)TagCreator.a().withClass("dropdown-item")).attr("onClick", (Object)"setPageNumber(0)")).withText("1")))})), ((DivTag)TagCreator.div().withClass("navbar-item")).with((DomContent)((DivTag)((DivTag)TagCreator.div().withId("dropdown-page-size")).withClass("dropdown is-up")).with(new DomContent[]{((DivTag)TagCreator.div().withClass("dropdown-trigger")).with((DomContent)((ButtonTag)((ButtonTag)((ButtonTag)TagCreator.button().withClass(this.darkButton())).attr("aria-haspopup", (Object)"true")).attr("aria-controls", (Object)"dropdown-menu")).with(new DomContent[]{((SpanTag)TagCreator.span().withId("pageSizeDisplay")).withText("Size"), ((SpanTag)TagCreator.span().withClass("icon is-small")).with((DomContent)((ITag)TagCreator.i().withClass("fas fa-angle-up")).attr("aria-hidden", (Object)"true"))})), ((DivTag)((DivTag)TagCreator.div().withClass("dropdown-menu")).attr("role", (Object)"menu")).with((DomContent)((DivTag)TagCreator.div().withClass("dropdown-content")).with(new DomContent[]{((ATag)((ATag)TagCreator.a().withClass("dropdown-item")).attr("onClick", (Object)"event.stopPropagation(); setPageSize(10)")).withText("10"), ((ATag)((ATag)TagCreator.a().withClass("dropdown-item")).attr("onClick", (Object)"event.stopPropagation(); setPageSize(20)")).withText("20"), ((ATag)((ATag)TagCreator.a().withClass("dropdown-item")).attr("onClick", (Object)"event.stopPropagation(); setPageSize(50)")).withText("50"), ((ATag)((ATag)TagCreator.a().withClass("dropdown-item")).attr("onClick", (Object)"event.stopPropagation(); setPageSize(100)")).withText("100")}))})), ((DivTag)TagCreator.div().withClass(this.getNavbarItemNot4embedded())).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("importMsgs")).withClass(this.successOutlineButton())).with(new DomContent[]{TagCreator.i().withClass("far fa-folder-open"), ((SpanTag)TagCreator.span((String)"Import").withClass("ml-2")).withStyle(COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass(this.getNavbarItemNot4embedded())).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("uploadMsgs")).withClass("button is-outlined is-info")).with(new DomContent[]{TagCreator.i().withClass("far fa-upload"), ((SpanTag)TagCreator.span((String)"Upload").withClass("ml-2")).withStyle(COLOR_INHERIT)})), ((DivTag)TagCreator.div().withClass(this.getNavbarItemNot4embedded())).with(new DomContent[]{TagCreator.span((String)"Proxy port "), TagCreator.b((String)("" + tigerProxy.getProxyPort())).withClass("ml-3")}), ((DivTag)TagCreator.div().withClass(this.getNavbarItemNot4embedded())).with((DomContent)((ButtonTag)((ButtonTag)TagCreator.button().withId("quitProxy")).withClass("button is-outlined is-danger")).with(new DomContent[]{TagCreator.i().withClass("fas fa-power-off"), ((SpanTag)TagCreator.span((String)"Quit").withClass("ml-2")).withStyle(COLOR_INHERIT)}))})))).render();
    }

    private String replaceScript(String html) {
        Document jsoup = Jsoup.parse((String)html);
        Element script = (Element)jsoup.select("script").get(2);
        ((DataNode)script.dataNodes().get(0)).replaceWith((Node)new DataNode(this.loadResourceToString("/tigerProxy.js")));
        return jsoup.html();
    }

    private String loadResourceToString(String resourceName) {
        InputStream resource = this.getClass().getResourceAsStream(resourceName);
        if (resource == null) {
            throw new TigerProxyConfigurationException("Unable to load resource '" + resourceName + "' !");
        }
        try {
            return IOUtils.toString((InputStream)resource, (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            throw new TigerProxyWebUiException("Exception while loading resource '" + resourceName + "'", e);
        }
    }

    @GetMapping(value={"/css/{cssfile}"}, produces={"text/css"})
    public String getCSS(@PathVariable(value="cssfile") String cssFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/css/" + cssFile);){
            if (is == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "css file " + cssFile + " not found");
            }
            String string = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    @GetMapping(value={"/testJexlQuery"}, produces={"application/json"})
    public JexlQueryResponseDto testJexlQuery(@RequestParam(name="msgUuid") String msgUuid, @RequestParam(name="query") String query) {
        RbelJexlExecutor jexlExecutor = new RbelJexlExecutor();
        RbelElement targetMessage = this.getTigerProxy().getRbelLogger().getMessageHistory().stream().filter(msg -> msg.getUuid().equals(msgUuid)).findFirst().orElseThrow();
        Map messageContext = jexlExecutor.buildJexlMapContext((Object)targetMessage, Optional.empty());
        RbelElementTreePrinter treePrinter = RbelElementTreePrinter.builder().rootElement(targetMessage).printFacets(false).build();
        return JexlQueryResponseDto.builder().matchSuccessful(jexlExecutor.matchesAsJexlExpression((Object)targetMessage, query)).messageContext(messageContext).rbelTreeHtml(HtmlEscapers.htmlEscaper().escape(treePrinter.execute()).replace(RbelAnsiColors.RESET.toString(), "</span>").replace(RbelAnsiColors.RED_BOLD.toString(), "<span class='has-text-danger'>").replace(RbelAnsiColors.CYAN.toString(), "<span class='has-text-info'>").replace(RbelAnsiColors.YELLOW_BRIGHT.toString(), "<span class='has-text-primary has-text-weight-bold'>").replace(RbelAnsiColors.GREEN.toString(), "<span class='has-text-warning'>").replace(RbelAnsiColors.BLUE.toString(), "<span class='has-text-success'>").replace("\n", "<br/>")).build();
    }

    @GetMapping(value={"/testRbelExpression"}, produces={"application/json"})
    public JexlQueryResponseDto testRbelExpression(@RequestParam(name="msgUuid") String msgUuid, @RequestParam(name="rbelPath") String rbelPath) {
        List targetElements = this.getTigerProxy().getRbelLogger().getMessageHistory().stream().filter(msg -> msg.getUuid().equals(msgUuid)).map(msg -> msg.findRbelPathMembers(rbelPath)).flatMap(Collection::stream).collect(Collectors.toList());
        if (targetElements.isEmpty()) {
            return JexlQueryResponseDto.builder().build();
        }
        RbelElementTreePrinter treePrinter = RbelElementTreePrinter.builder().rootElement((RbelElement)targetElements.get(0)).printFacets(false).build();
        return JexlQueryResponseDto.builder().rbelTreeHtml(HtmlEscapers.htmlEscaper().escape(treePrinter.execute()).replace(RbelAnsiColors.RESET.toString(), "</span>").replace(RbelAnsiColors.RED_BOLD.toString(), "<span class='has-text-danger jexlResponseLink' style='cursor: pointer;'>").replace(RbelAnsiColors.CYAN.toString(), "<span class='has-text-info'>").replace(RbelAnsiColors.YELLOW_BRIGHT.toString(), "<span class='has-text-primary has-text-weight-bold'>").replace(RbelAnsiColors.GREEN.toString(), "<span class='has-text-warning'>").replace(RbelAnsiColors.BLUE.toString(), "<span class='has-text-success'>").replace("\n", "<br/>")).elements(targetElements.stream().map(RbelElement::findNodePath).map(key -> "$." + key).collect(Collectors.toList())).build();
    }

    @GetMapping(value={"/webfonts/{fontfile}"}, produces={"text/css"})
    public ResponseEntity<byte[]> getWebFont(@PathVariable(value="fontfile") String fontFile) throws IOException {
        try (InputStream is = this.getClass().getResourceAsStream("/webfonts/" + fontFile);){
            if (is == null) {
                throw new ResponseStatusException(HttpStatus.NOT_FOUND, "webfont file " + fontFile + " not found");
            }
            ResponseEntity responseEntity = new ResponseEntity((Object)IOUtils.toByteArray((InputStream)is), HttpStatus.OK);
            return responseEntity;
        }
    }

    @GetMapping(value={"/getMsgAfter"}, produces={"application/json"})
    public GetMessagesAfterDto getMessagesAfter(@RequestParam(name="lastMsgUuid", required=false) String lastMsgUuid, @RequestParam(name="filterCriterion", required=false) String filterCriterion, @RequestParam(defaultValue="1000000") int pageSize, @RequestParam(defaultValue="0") int pageNumber) {
        log.debug("requesting messages since " + lastMsgUuid + " (filtered by . " + filterCriterion + ")");
        RbelJexlExecutor jexlExecutor = new RbelJexlExecutor();
        List msgs = this.getTigerProxy().getRbelLogger().getMessageHistory().stream().filter(msg -> {
            if (StringUtils.isEmpty((CharSequence)filterCriterion)) {
                return true;
            }
            if (filterCriterion.startsWith("\"") && filterCriterion.endsWith("\"")) {
                String textFilter = filterCriterion.substring(1, filterCriterion.length() - 1);
                return jexlExecutor.matchAsTextExpression(msg, textFilter) || jexlExecutor.matchAsTextExpression((Object)this.findPartner((RbelElement)msg), textFilter);
            }
            return jexlExecutor.matchesAsJexlExpression(msg, filterCriterion, Optional.empty()) || jexlExecutor.matchesAsJexlExpression((Object)this.findPartner((RbelElement)msg), filterCriterion, Optional.empty());
        }).collect(Collectors.toList());
        GetMessagesAfterDto result = new GetMessagesAfterDto();
        result.setLastMsgUuid(lastMsgUuid);
        result.setHtmlMsgList(msgs.stream().skip((long)pageNumber * (long)pageSize).limit(pageSize).dropWhile(TigerWebUiController.messageIsBefore(lastMsgUuid)).filter(msg -> !msg.getUuid().equals(lastMsgUuid)).map(msg -> HtmlMessage.builder().html(new RbelHtmlRenderingToolkit(this.renderer).convertMessage(msg).render()).uuid(msg.getUuid()).sequenceNumber(MessageMetaDataDto.getElementSequenceNumber(msg)).build()).collect(Collectors.toList()));
        result.setMetaMsgList(msgs.stream().dropWhile(TigerWebUiController.messageIsBefore(lastMsgUuid)).filter(msg -> !msg.getUuid().equals(lastMsgUuid)).map(MessageMetaDataDto::createFrom).collect(Collectors.toList()));
        result.setPagesAvailable(msgs.size() / pageSize + 1);
        result.setTotalMsgCount(this.tigerProxy.getRbelLogger().getMessageHistory().size());
        log.info("Returning {} messages ({} in menu, {} filtered) of total {}", new Object[]{result.getHtmlMsgList().size(), result.getMetaMsgList().size(), msgs.size(), this.tigerProxy.getRbelLogger().getMessageHistory().size()});
        return result;
    }

    private static Predicate<RbelElement> messageIsBefore(String lastMsgUuid) {
        return msg -> {
            if (StringUtils.isEmpty((CharSequence)lastMsgUuid)) {
                return false;
            }
            return !msg.getUuid().equals(lastMsgUuid);
        };
    }

    private RbelElement findPartner(RbelElement msg) {
        return msg.getFacet(TracingMessagePairFacet.class).map(pairFacet -> {
            if (pairFacet.getRequest() == msg) {
                return pairFacet.getResponse();
            }
            return pairFacet.getRequest();
        }).orElse(null);
    }

    @GetMapping(value={"/resetMsgs"}, produces={"application/json"})
    public ResetMessagesDto resetMessages() {
        log.info("Resetting currently recorded messages on rbel logger..");
        int size = this.getTigerProxy().getRbelLogger().getMessageHistory().size();
        ResetMessagesDto result = new ResetMessagesDto();
        result.setNumMsgs(size);
        this.getTigerProxy().getRbelLogger().clearAllMessages();
        return result;
    }

    @GetMapping(value={"/quit"}, produces={"application/json"})
    public void quitProxy(@RequestParam(name="noSystemExit", required=false) String noSystemExit) {
        log.info("Shutting down tiger standalone proxy at port " + this.tigerProxy.getProxyPort() + "...");
        this.tigerProxy.clearAllRoutes();
        this.tigerProxy.shutdown();
        log.info("Shutting down tiger standalone proxy ui...");
        int exitCode = SpringApplication.exit((ApplicationContext)this.applicationContext, (ExitCodeGenerator[])new ExitCodeGenerator[0]);
        if (exitCode != 0) {
            log.warn("Exit of tiger proxy ui not successful - exit code: " + exitCode);
        }
        if (StringUtils.isEmpty((CharSequence)noSystemExit)) {
            System.exit(0);
        }
    }

    @PostMapping(value={"/uploadReport"})
    public void uploadReport(@RequestBody String htmlReport) {
        if (this.applicationConfiguration.getUploadUrl().equals("UNDEFINED")) {
            throw new TigerProxyConfigurationException("Upload feature is not configured!");
        }
        log.info("Uploading report to {}...", (Object)this.applicationConfiguration.getUploadUrl());
        this.performUploadReport(URLDecoder.decode(htmlReport, StandardCharsets.UTF_8));
    }

    private void performUploadReport(String htmlReport) {
        String filename = this.applicationConfiguration.getFilenamePattern().replace("${DATE}", LocalDate.now().format(DateTimeFormatter.ofPattern("yyyyMMdd"))).replace("${TIME}", LocalTime.now().format(DateTimeFormatter.ofPattern("HHmmssSSS")));
        String uploadUrl = this.applicationConfiguration.getUploadUrl() + filename;
        try {
            URL serverUrl = new URL(uploadUrl);
            HttpURLConnection urlConnection = (HttpURLConnection)serverUrl.openConnection();
            String boundaryString = "----TigerProxyReport";
            urlConnection.setDoOutput(true);
            urlConnection.setRequestMethod("POST");
            urlConnection.addRequestProperty("Content-Type", "multipart/form-data; boundary=" + boundaryString);
            if (this.applicationConfiguration.getUsername() != null) {
                String auth = this.applicationConfiguration.getUsername() + ":" + this.applicationConfiguration.getPassword();
                byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(StandardCharsets.UTF_8));
                String authHeaderValue = "Basic " + new String(encodedAuth);
                urlConnection.setRequestProperty("Authorization", authHeaderValue);
            }
            try (OutputStream outputStreamToRequestBody = urlConnection.getOutputStream();
                 BufferedWriter httpRequestBodyWriter = new BufferedWriter(new OutputStreamWriter(outputStreamToRequestBody));){
                httpRequestBodyWriter.write("\n--" + boundaryString + "\n");
                httpRequestBodyWriter.write("Content-Disposition: form-data;name=\"Tiger proxy report archive\";filename=\"" + filename + "\"\nContent-Type: application/zip\n\n");
                httpRequestBodyWriter.flush();
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                try (ZipOutputStream zos = new ZipOutputStream(baos);){
                    ZipEntry entry = new ZipEntry(filename);
                    zos.putNextEntry(entry);
                    zos.write(htmlReport.getBytes(StandardCharsets.UTF_8));
                    zos.closeEntry();
                    entry = new ZipEntry("application.cfg");
                    zos.putNextEntry(entry);
                    zos.write(this.tigerProxy.getTigerProxyConfiguration().toString().getBytes(StandardCharsets.UTF_8));
                    zos.closeEntry();
                }
                outputStreamToRequestBody.write(baos.toByteArray());
                outputStreamToRequestBody.flush();
                baos.close();
                httpRequestBodyWriter.write("\n--" + boundaryString + "--\n");
                httpRequestBodyWriter.flush();
            }
        }
        catch (MalformedURLException | ProtocolException e) {
            throw new TigerProxyConfigurationException("Invalid upload url '" + uploadUrl + "'", e);
        }
        catch (IOException e) {
            throw new TigerRemoteProxyClientException("Failed to upload report to '" + uploadUrl + "'", e);
        }
    }

    @PostMapping(value={"/traffic"})
    public void importTrafficFromFile(@RequestBody String rawTraffic) {
        this.tigerProxy.getRbelFileWriter().convertFromRbelFile(rawTraffic);
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public RbelHtmlRenderer getRenderer() {
        return this.renderer;
    }

    @Generated
    public ApplicationConfiguration getApplicationConfiguration() {
        return this.applicationConfiguration;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public SimpMessagingTemplate getTemplate() {
        return this.template;
    }

    @Generated
    public TigerBuildPropertiesService getBuildProperties() {
        return this.buildProperties;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TigerWebUiController)) {
            return false;
        }
        TigerWebUiController other = (TigerWebUiController)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        RbelHtmlRenderer this$renderer = this.getRenderer();
        RbelHtmlRenderer other$renderer = other.getRenderer();
        if (this$renderer == null ? other$renderer != null : !this$renderer.equals(other$renderer)) {
            return false;
        }
        ApplicationConfiguration this$applicationConfiguration = this.getApplicationConfiguration();
        ApplicationConfiguration other$applicationConfiguration = other.getApplicationConfiguration();
        if (this$applicationConfiguration == null ? other$applicationConfiguration != null : !((Object)((Object)this$applicationConfiguration)).equals((Object)other$applicationConfiguration)) {
            return false;
        }
        ApplicationContext this$applicationContext = this.getApplicationContext();
        ApplicationContext other$applicationContext = other.getApplicationContext();
        if (this$applicationContext == null ? other$applicationContext != null : !this$applicationContext.equals(other$applicationContext)) {
            return false;
        }
        SimpMessagingTemplate this$template = this.getTemplate();
        SimpMessagingTemplate other$template = other.getTemplate();
        if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
            return false;
        }
        TigerBuildPropertiesService this$buildProperties = this.getBuildProperties();
        TigerBuildPropertiesService other$buildProperties = other.getBuildProperties();
        return !(this$buildProperties == null ? other$buildProperties != null : !this$buildProperties.equals(other$buildProperties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof TigerWebUiController;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        RbelHtmlRenderer $renderer = this.getRenderer();
        result = result * 59 + ($renderer == null ? 43 : $renderer.hashCode());
        ApplicationConfiguration $applicationConfiguration = this.getApplicationConfiguration();
        result = result * 59 + ($applicationConfiguration == null ? 43 : ((Object)((Object)$applicationConfiguration)).hashCode());
        ApplicationContext $applicationContext = this.getApplicationContext();
        result = result * 59 + ($applicationContext == null ? 43 : $applicationContext.hashCode());
        SimpMessagingTemplate $template = this.getTemplate();
        result = result * 59 + ($template == null ? 43 : $template.hashCode());
        TigerBuildPropertiesService $buildProperties = this.getBuildProperties();
        result = result * 59 + ($buildProperties == null ? 43 : $buildProperties.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "TigerWebUiController(tigerProxy=" + this.getTigerProxy() + ", renderer=" + this.getRenderer() + ", applicationConfiguration=" + this.getApplicationConfiguration() + ", applicationContext=" + this.getApplicationContext() + ", template=" + this.getTemplate() + ", buildProperties=" + this.getBuildProperties() + ")";
    }

    @ConstructorProperties(value={"tigerProxy", "renderer", "applicationConfiguration", "template", "buildProperties"})
    @Generated
    public TigerWebUiController(TigerProxy tigerProxy, RbelHtmlRenderer renderer, ApplicationConfiguration applicationConfiguration, SimpMessagingTemplate template, TigerBuildPropertiesService buildProperties) {
        this.tigerProxy = tigerProxy;
        this.renderer = renderer;
        this.applicationConfiguration = applicationConfiguration;
        this.template = template;
        this.buildProperties = buildProperties;
    }
}

