/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.renderer.RbelHtmlRenderer;
import de.gematik.test.tiger.common.config.tigerProxy.TigerBasicAuthConfiguration;
import de.gematik.test.tiger.common.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.config.tigerProxy.TigerProxyType;
import de.gematik.test.tiger.common.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.pki.TigerPkiIdentity;
import de.gematik.test.tiger.exception.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.AbstractTigerProxy;
import de.gematik.test.tiger.proxy.MockServerToRbelConverter;
import de.gematik.test.tiger.proxy.TigerKeyAndCertificateFactory;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyConfigurationException;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyRouteConflictException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.buf.UriUtil;
import org.mockserver.client.MockServerClient;
import org.mockserver.configuration.ConfigurationProperties;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.matchers.TimeToLive;
import org.mockserver.matchers.Times;
import org.mockserver.mock.Expectation;
import org.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import org.mockserver.mock.action.ExpectationForwardCallback;
import org.mockserver.model.ExpectationId;
import org.mockserver.model.Header;
import org.mockserver.model.HttpOverrideForwardedRequest;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.RequestDefinition;
import org.mockserver.netty.MockServer;
import org.mockserver.proxyconfiguration.ProxyConfiguration;
import org.mockserver.socket.tls.KeyAndCertificateFactory;
import org.mockserver.socket.tls.KeyAndCertificateFactoryFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerProxy
extends AbstractTigerProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerProxy.class);
    private MockServer mockServer;
    private MockServerClient mockServerClient;
    private MockServerToRbelConverter mockServerToRbelConverter;
    private Map<String, TigerRoute> tigerRouteMap = new HashMap<String, TigerRoute>();

    public TigerProxy(TigerProxyConfiguration configuration) {
        super(configuration);
        KeyAndCertificateFactoryFactory.setCustomKeyAndCertificateFactorySupplier(this.buildKeyAndCertificateFactory(configuration));
        this.mockServerToRbelConverter = new MockServerToRbelConverter(this.getRbelLogger().getRbelConverter());
        ConfigurationProperties.useBouncyCastleForKeyAndCertificateGeneration((boolean)true);
        ConfigurationProperties.forwardProxyTLSX509CertificatesTrustManagerType((String)"ANY");
        if (StringUtils.isNotEmpty((CharSequence)configuration.getProxyLogLevel())) {
            ConfigurationProperties.logLevel((String)configuration.getProxyLogLevel());
        }
        this.mockServer = this.convertProxyConfiguration(configuration).map(proxyConfiguration -> new MockServer(proxyConfiguration, configuration.getPortAsArray())).orElseGet(() -> new MockServer(configuration.getPortAsArray()));
        log.info("Proxy started on port " + this.mockServer.getLocalPort());
        this.mockServerClient = new MockServerClient("localhost", this.mockServer.getLocalPort()){};
        if (configuration.getProxyRoutes() != null) {
            for (TigerRoute tigerRoute : configuration.getProxyRoutes()) {
                this.addRoute(tigerRoute);
            }
        }
        if (configuration.isActivateRbelEndpoint()) {
            this.addRbelTrafficEndpoint();
        }
        if (!configuration.isSkipTrafficEndpointsSubscription()) {
            this.subscribeToTrafficEndpoints(configuration);
        }
        if (configuration.isActivateForwardAllLogging()) {
            this.mockServerClient.when((RequestDefinition)HttpRequest.request().withPath(".*"), Times.unlimited(), TimeToLive.unlimited(), Integer.valueOf(Integer.MIN_VALUE)).forward(req -> HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)req.withSocketAddress(req.isSecure(), req.socketAddressFromHostHeader().getHostName(), Integer.valueOf(req.socketAddressFromHostHeader().getPort()))).getHttpRequest(), (req, resp) -> {
                try {
                    this.triggerListener(this.mockServerToRbelConverter.convertRequest(req, req.getSocketAddress().getScheme() + "://" + req.getSocketAddress().getHost() + ":" + req.getSocketAddress().getPort()));
                    this.triggerListener(this.mockServerToRbelConverter.convertResponse(resp, req.getSocketAddress().getScheme() + "://" + req.getSocketAddress().getHost() + ":" + req.getSocketAddress().getPort()));
                    this.manageRbelBufferSize();
                }
                catch (Exception e) {
                    log.error("RBel FAILED!", (Throwable)e);
                }
                return resp;
            });
        }
    }

    private static String patchPath(String requestPath, String forwardTarget) {
        if (StringUtils.isEmpty((CharSequence)forwardTarget)) {
            return requestPath;
        }
        String patchedUrl = requestPath.replaceFirst(forwardTarget, "");
        if (patchedUrl.startsWith("/")) {
            return patchedUrl;
        }
        return "/" + patchedUrl;
    }

    private BiFunction<MockServerLogger, Boolean, KeyAndCertificateFactory> buildKeyAndCertificateFactory(TigerProxyConfiguration configuration) {
        if (this.getTigerProxyConfiguration().getServerIdentity() != null && !this.getTigerProxyConfiguration().getServerIdentity().hasValidChainWithRootCa()) {
            throw new TigerProxyStartupException("Configured server-identity has no valid chain!");
        }
        return (mockServerLogger, isServerInstance) -> {
            if (isServerInstance.booleanValue() || configuration.getForwardMutualTlsIdentity() == null) {
                return new TigerKeyAndCertificateFactory((MockServerLogger)mockServerLogger, this.determineServerRootCa().orElse(null), this.getTigerProxyConfiguration().getServerIdentity());
            }
            return new TigerKeyAndCertificateFactory((MockServerLogger)mockServerLogger, null, configuration.getForwardMutualTlsIdentity());
        };
    }

    private Optional<TigerPkiIdentity> determineServerRootCa() {
        if (this.getTigerProxyConfiguration().getServerRootCa() != null) {
            return Optional.ofNullable(this.getTigerProxyConfiguration().getServerRootCa());
        }
        if (this.getTigerProxyConfiguration().getServerIdentity() != null) {
            return Optional.empty();
        }
        return Optional.of(new TigerPkiIdentity("CertificateAuthorityCertificate.pem;PKCS8CertificateAuthorityPrivateKey.pem;PKCS8"));
    }

    public void subscribeToTrafficEndpoints(TigerProxyConfiguration configuration) {
        Optional.of(configuration).filter(Objects::nonNull).map(TigerProxyConfiguration::getTrafficEndpoints).ifPresent(this::subscribeToTrafficEndpoints);
    }

    public void subscribeToTrafficEndpoints(List<String> trafficEndpointUrls) {
        Optional.of(trafficEndpointUrls).filter(Objects::nonNull).stream().flatMap(Collection::stream).map(url -> new TigerRemoteProxyClient((String)url, new TigerProxyConfiguration())).forEach(remoteClient -> {
            remoteClient.setRbelLogger(this.getRbelLogger());
            remoteClient.addRbelMessageListener(this::triggerListener);
        });
    }

    private void addRbelTrafficEndpoint() {
        this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", new String[]{"rbel"})).respond(HttpResponse.response().withHeader("content-type", new String[]{"text/html; charset=utf-8"}).withBody(new RbelHtmlRenderer().doRender(this.getRbelLogger().getMessageHistory())));
        this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", null).withPath("/rbel")).respond(httpRequest -> HttpResponse.response().withHeader("content-type", new String[]{"text/html; charset=utf-8"}).withBody(new RbelHtmlRenderer().doRender(this.getRbelLogger().getMessageHistory())));
    }

    public ProxyConfiguration.Type toMockServerType(TigerProxyType type) {
        if (type == TigerProxyType.HTTP) {
            return ProxyConfiguration.Type.HTTP;
        }
        return ProxyConfiguration.Type.HTTPS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<ProxyConfiguration> convertProxyConfiguration(TigerProxyConfiguration configuration) {
        Optional<ProxyConfiguration> optional;
        block14: {
            Optional<ProxyConfiguration> cfg;
            block12: {
                block10: {
                    Optional<ProxyConfiguration> optional2;
                    block13: {
                        block11: {
                            cfg = Optional.empty();
                            try {
                                if (configuration.getForwardToProxy() != null && !StringUtils.isEmpty((CharSequence)configuration.getForwardToProxy().getHostname())) break block10;
                                optional2 = cfg;
                                if (!cfg.isEmpty()) break block11;
                            }
                            catch (Throwable throwable) {
                                if (cfg.isEmpty()) {
                                    log.info("Tigerproxy has NO forward proxy configured!");
                                } else {
                                    log.info("Forward proxy is set to " + ((ProxyConfiguration)cfg.get()).getType() + "://" + ((ProxyConfiguration)cfg.get()).getProxyAddress().getHostName() + ":" + cfg.get().getProxyAddress().getPort());
                                }
                                throw throwable;
                            }
                            log.info("Tigerproxy has NO forward proxy configured!");
                            break block13;
                        }
                        log.info("Forward proxy is set to " + ((ProxyConfiguration)cfg.get()).getType() + "://" + cfg.get().getProxyAddress().getHostName() + ":" + cfg.get().getProxyAddress().getPort());
                    }
                    return optional2;
                }
                if (configuration.getForwardToProxy().getHostname() != null && configuration.getForwardToProxy().getHostname().equals("$SYSTEM")) {
                    if (System.getProperty("http.proxyHost") != null) {
                        cfg = Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)ProxyConfiguration.Type.HTTP, (String)(System.getProperty("http.proxyHost") + ":" + System.getProperty("http.proxyPort"))));
                    } else if (System.getenv("http_proxy") != null) {
                        cfg = Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)ProxyConfiguration.Type.HTTP, (String)System.getenv("http_proxy").split("://")[1]));
                    }
                } else {
                    cfg = Optional.of(ProxyConfiguration.proxyConfiguration((ProxyConfiguration.Type)Optional.ofNullable(configuration.getForwardToProxy().getType()).map(this::toMockServerType).orElse(ProxyConfiguration.Type.HTTPS), (String)(configuration.getForwardToProxy().getHostname() + ":" + configuration.getForwardToProxy().getPort())));
                }
                optional = cfg;
                if (!cfg.isEmpty()) break block12;
                log.info("Tigerproxy has NO forward proxy configured!");
                break block14;
            }
            log.info("Forward proxy is set to " + cfg.get().getType() + "://" + cfg.get().getProxyAddress().getHostName() + ":" + cfg.get().getProxyAddress().getPort());
        }
        return optional;
    }

    @Override
    public String getBaseUrl() {
        return "http://localhost:" + this.mockServer.getLocalPort();
    }

    @Override
    public int getPort() {
        return this.mockServer.getLocalPort();
    }

    @Override
    public List<TigerRoute> getRoutes() {
        return this.tigerRouteMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
    }

    @Override
    public TigerRoute addRoute(TigerRoute tigerRoute) {
        this.tigerRouteMap.values().stream().filter(existingRoute -> this.uriEquals(existingRoute.getFrom(), tigerRoute.getFrom())).findAny().ifPresent(existingRoute -> {
            throw new TigerProxyRouteConflictException((TigerRoute)existingRoute);
        });
        log.info("adding route {} -> {}", (Object)tigerRoute.getFrom(), (Object)tigerRoute.getTo());
        Expectation[] expectations = this.buildRouteAndReturnExpectation(tigerRoute);
        if (expectations.length > 1) {
            log.warn("Unexpected number of expectations created! Got {}, expected 1", (Object)expectations.length);
        }
        if (expectations.length == 0) {
            throw new TigerProxyConfigurationException("Error while adding route from '{}' to '{}': Got 0 new expectations");
        }
        TigerRoute createdTigerRoute = tigerRoute.withId(expectations[0].getId());
        this.tigerRouteMap.put(expectations[0].getId(), createdTigerRoute);
        return createdTigerRoute;
    }

    private boolean uriEquals(String value1, String value2) {
        try {
            return new URI(value1).equals(new URI(value2));
        }
        catch (URISyntaxException e) {
            return false;
        }
    }

    private Expectation[] buildRouteAndReturnExpectation(TigerRoute tigerRoute) {
        if (UriUtil.hasScheme((CharSequence)tigerRoute.getFrom())) {
            return this.buildForwardProxyRoute(tigerRoute);
        }
        try {
            return this.buildReverseProxyRoute(tigerRoute);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Expectation[] buildReverseProxyRoute(TigerRoute tigerRoute) throws URISyntaxException {
        URI targetUri = new URI(tigerRoute.getTo());
        if (targetUri.getPort() < 0) {
            int port = tigerRoute.getTo().startsWith("https://") ? 443 : 80;
        } else {
            int port = targetUri.getPort();
        }
        ArrayList<Header> headers = new ArrayList<Header>(List.of(new Header("Host", new String[]{targetUri.getHost()})));
        if (tigerRoute.getBasicAuth() != null) {
            headers.add(new Header("Authorization", new String[]{tigerRoute.getBasicAuth().toAuthorizationHeaderValue()}));
        }
        HttpRequest req = HttpRequest.request();
        return this.mockServerClient.when((RequestDefinition)req.withPath(tigerRoute.getFrom() + ".*")).forward((ExpectationForwardCallback)new RoutedForwardRequestExpectationForwardAndResponseCallback(tigerRoute));
    }

    private Expectation[] buildForwardProxyRoute(TigerRoute tigerRoute) {
        return this.mockServerClient.when((RequestDefinition)HttpRequest.request().withHeader("Host", new String[]{tigerRoute.getFrom().split("://")[1]}).withSecure(Boolean.valueOf(tigerRoute.getFrom().startsWith("https://")))).forward(req -> {
            req.replaceHeader(Header.header((String)"Host", (String[])new String[]{tigerRoute.getTo().split("://")[1]}));
            if (tigerRoute.getBasicAuth() != null) {
                req.replaceHeader(Header.header((String)"Authorization", (String[])new String[]{tigerRoute.getBasicAuth().toAuthorizationHeaderValue()}));
            }
            return HttpOverrideForwardedRequest.forwardOverriddenRequest((HttpRequest)req).getHttpRequest().withSecure(Boolean.valueOf(tigerRoute.getTo().startsWith("https://")));
        }, this.buildExpectationCallback(tigerRoute, tigerRoute.getFrom()));
    }

    private ExpectationForwardAndResponseCallback buildExpectationCallback(TigerRoute tigerRoute, String protocolAndHost) {
        return (req, resp) -> {
            if (!tigerRoute.isDisableRbelLogging()) {
                try {
                    this.triggerListener(this.mockServerToRbelConverter.convertRequest(req, protocolAndHost));
                    this.triggerListener(this.mockServerToRbelConverter.convertResponse(resp, protocolAndHost));
                    this.manageRbelBufferSize();
                }
                catch (Exception e) {
                    log.error("RBel FAILED!", (Throwable)e);
                }
            }
            return resp;
        };
    }

    private void manageRbelBufferSize() {
        while (this.rbelBufferIsExceedingMaxSize()) {
            log.info("Exceeded buffer size, dropping oldest message in history");
            this.getRbelLogger().getMessageHistory().remove(0);
        }
    }

    private boolean rbelBufferIsExceedingMaxSize() {
        boolean exceedingLimit;
        long bufferSize = this.getRbelLogger().getMessageHistory().stream().map(RbelElement::getRawContent).mapToLong(ar -> ((byte[])ar).length).sum();
        boolean bl = exceedingLimit = bufferSize > (long)(this.getTigerProxyConfiguration().getRbelBufferSizeInMb() * 1024 * 1024);
        if (exceedingLimit) {
            log.info("Buffersize is {} Mb which exceeds the limit of {} Mb", (Object)(bufferSize / 1026L), (Object)this.getTigerProxyConfiguration().getRbelBufferSizeInMb());
        }
        return exceedingLimit;
    }

    @Override
    public void removeRoute(String routeId) {
        this.mockServerClient.clear(new ExpectationId().withId(routeId));
        TigerRoute route = this.tigerRouteMap.remove(routeId);
        log.info("Deleted route {}. Current # expectations {}", (Object)route, (Object)this.mockServerClient.retrieveActiveExpectations((RequestDefinition)HttpRequest.request()).length);
    }

    public KeyStore buildTruststore() {
        try {
            KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
            ks.load(null);
            TigerPkiIdentity serverIdentity = this.determineServerRootCa().or(() -> Optional.ofNullable(this.getTigerProxyConfiguration().getServerIdentity())).orElseThrow(() -> new TigerProxyTrustManagerBuildingException("Unrecoverable state: Server-Identity null and Server-CA empty"));
            ks.setCertificateEntry("caCert", serverIdentity.getCertificate());
            int chainCertCtr = 0;
            for (X509Certificate chainCert : serverIdentity.getCertificateChain()) {
                ks.setCertificateEntry("chainCert" + chainCertCtr++, chainCert);
            }
            return ks;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for tiger-proxy", e);
        }
    }

    public SSLContext buildSslContext() {
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(this.buildTruststore());
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (Exception e) {
            throw new TigerProxyTrustManagerBuildingException("Error while building SSL-Context for tiger-proxy", e);
        }
    }

    private class TigerProxyTrustManagerBuildingException
    extends RuntimeException {
        public TigerProxyTrustManagerBuildingException(String s, Exception e) {
            super(s, e);
        }

        public TigerProxyTrustManagerBuildingException(String s) {
            super(s);
        }
    }

    private class RoutedForwardRequestExpectationForwardAndResponseCallback
    implements ExpectationForwardAndResponseCallback {
        private final TigerRoute route;

        RoutedForwardRequestExpectationForwardAndResponseCallback(TigerRoute route) {
            this.route = route;
        }

        public HttpRequest handle(HttpRequest httpRequest) throws Exception {
            URI targetUri = new URI(this.route.getTo());
            int port = targetUri.getPort() < 0 ? (this.route.getTo().startsWith("https://") ? 443 : 80) : targetUri.getPort();
            ArrayList<Header> headers = new ArrayList<Header>(List.of(new Header("Host", new String[]{targetUri.getHost()})));
            if (this.route.getBasicAuth() != null) {
                headers.add(new Header("Authorization", new String[]{this.route.getBasicAuth().toAuthorizationHeaderValue()}));
            }
            return httpRequest.withSocketAddress(Boolean.valueOf(this.route.getTo().startsWith("https://")), targetUri.getHost(), Integer.valueOf(port)).withSecure(Boolean.valueOf(this.route.getTo().startsWith("https://"))).removeHeader("Host").withHeaders(headers).withPath(TigerProxy.patchPath(httpRequest.getPath().getValue(), this.route.getFrom()));
        }

        public HttpResponse handle(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
            if (!this.route.isDisableRbelLogging()) {
                try {
                    TigerProxy.this.triggerListener(TigerProxy.this.mockServerToRbelConverter.convertRequest(httpRequest, this.route.getFrom()));
                    TigerProxy.this.triggerListener(TigerProxy.this.mockServerToRbelConverter.convertResponse(httpResponse, this.route.getFrom()));
                }
                catch (Exception e) {
                    log.error("RBel FAILED!", (Throwable)e);
                }
            }
            String newBody = httpResponse.getBodyAsString().replaceAll("http[s|]*\\:\\/\\/kon.\\.e2e\\-test\\.gematik\\.solutions", "http://127.0.0.1:" + TigerProxy.this.getTigerProxyConfiguration().getPort());
            return httpResponse.withBody(newBody);
        }
    }

    public static class TestExpectationForwardCallback
    implements ExpectationForwardAndResponseCallback {
        public HttpRequest handle(HttpRequest httpRequest) {
            return httpRequest.clone().removeHeader("Host").withHeader(Header.header((String)"Host", (String[])new String[]{"kon1.e2e-test.gematik.solutions"})).withHeader(new Header("Authentication", new String[]{new TigerBasicAuthConfiguration("Konnektor1", "no2FjkGGqogu").toAuthorizationHeaderValue()})).withSecure(Boolean.valueOf(true)).withPath(TigerProxy.patchPath(httpRequest.getPath().getValue(), "/"));
        }

        public HttpResponse handle(HttpRequest httpRequest, HttpResponse httpResponse) throws Exception {
            return httpResponse;
        }
    }
}

