/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tracing;

import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import java.beans.ConstructorProperties;
import lombok.Generated;
import org.springframework.context.ApplicationListener;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.ContextClosedEvent;
import org.springframework.messaging.simp.config.ChannelRegistration;
import org.springframework.messaging.simp.config.MessageBrokerRegistry;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.web.socket.config.annotation.EnableWebSocketMessageBroker;
import org.springframework.web.socket.config.annotation.StompEndpointRegistry;
import org.springframework.web.socket.config.annotation.WebSocketMessageBrokerConfigurer;
import org.springframework.web.socket.server.HandshakeHandler;
import org.springframework.web.socket.server.RequestUpgradeStrategy;
import org.springframework.web.socket.server.standard.TomcatRequestUpgradeStrategy;
import org.springframework.web.socket.server.support.DefaultHandshakeHandler;

@Configuration
@EnableWebSocketMessageBroker
public class TracingEndpointConfiguration
implements WebSocketMessageBrokerConfigurer,
ApplicationListener<ContextClosedEvent> {
    private final TigerProxyConfiguration tigerProxyConfiguration;
    private final ThreadPoolTaskExecutor taskExecutor = new ThreadPoolTaskExecutor();

    public void configureMessageBroker(MessageBrokerRegistry config) {
        config.enableSimpleBroker(new String[]{"/topic"});
        config.setApplicationDestinationPrefixes(new String[]{this.tigerProxyConfiguration.getTrafficEndpointConfiguration().getStompTopic()});
    }

    public void registerStompEndpoints(StompEndpointRegistry registry) {
        TomcatRequestUpgradeStrategy upgradeStrategy = new TomcatRequestUpgradeStrategy();
        registry.addEndpoint(new String[]{this.tigerProxyConfiguration.getTrafficEndpointConfiguration().getWsEndpoint()}).withSockJS();
        registry.addEndpoint(new String[]{this.tigerProxyConfiguration.getTrafficEndpointConfiguration().getWsEndpoint()}).setHandshakeHandler((HandshakeHandler)new DefaultHandshakeHandler((RequestUpgradeStrategy)upgradeStrategy)).setAllowedOrigins(new String[]{"*"});
    }

    public void configureClientOutboundChannel(ChannelRegistration registration) {
        registration.taskExecutor(this.taskExecutor);
    }

    public void onApplicationEvent(ContextClosedEvent event) {
        this.taskExecutor.shutdown();
    }

    @ConstructorProperties(value={"tigerProxyConfiguration"})
    @Generated
    public TracingEndpointConfiguration(TigerProxyConfiguration tigerProxyConfiguration) {
        this.tigerProxyConfiguration = tigerProxyConfiguration;
    }
}

