/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.util.RbelFileWriterUtils;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.data.TigerDownloadedMessageFacet;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kong.unirest.GetRequest;
import kong.unirest.HttpResponse;
import kong.unirest.Unirest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TigerRemoteTrafficDownloader {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TigerRemoteTrafficDownloader.class);
    private final TigerRemoteProxyClient tigerRemoteProxyClient;

    public void execute() {
        this.tigerRemoteProxyClient.getTrafficParserExecutor().submit(this.tigerRemoteProxyClient::switchToQueueMode);
        this.downloadAllTrafficFromRemote();
        log.info("{}Successfully downloaded missed traffic from '{}'.", (Object)this.tigerRemoteProxyClient.proxyName(), (Object)this.getRemoteProxyUrl());
        this.tigerRemoteProxyClient.getTrafficParserExecutor().submit(() -> log.info("{}Successfully downloaded & parsed missed traffic from '{}'. Now {} message cached", new Object[]{this.tigerRemoteProxyClient.proxyName(), this.getRemoteProxyUrl(), this.getRbelMessages().size()}));
        this.tigerRemoteProxyClient.getTrafficParserExecutor().submit(this.tigerRemoteProxyClient::switchToExecutorMode);
    }

    private void parseTrafficChunk(String rawTraffic) {
        List convertedMessages = RbelFileWriterUtils.convertFromRbelFile((String)rawTraffic, (RbelConverter)this.getRbelLogger().getRbelConverter());
        long count = rawTraffic.lines().count();
        convertedMessages.forEach(msg -> msg.addFacet((RbelFacet)new TigerDownloadedMessageFacet()));
        for (int i = 0; i < convertedMessages.size(); i += 2) {
            TracingMessagePairFacet pairFacet = TracingMessagePairFacet.builder().response((RbelElement)convertedMessages.get(i + 1)).request((RbelElement)convertedMessages.get(i)).build();
            ((RbelElement)convertedMessages.get(i + 1)).addFacet((RbelFacet)pairFacet);
        }
        if (log.isTraceEnabled()) {
            log.trace("{}Just parsed another traffic batch of {} lines, got {} messages, expected {} (rest was filtered). Now standing at {} messages overall", new Object[]{this.tigerRemoteProxyClient.proxyName(), count, convertedMessages.size(), (count + 2L) / 3L, this.getRbelMessages().size()});
        }
        if (!convertedMessages.isEmpty()) {
            this.tigerRemoteProxyClient.getLastMessageUuid().set(((RbelElement)convertedMessages.get(convertedMessages.size() - 1)).getUuid());
        }
        convertedMessages.forEach(this.tigerRemoteProxyClient::triggerListener);
        if (log.isTraceEnabled()) {
            log.trace("{}Parsed traffic, ending with {}", (Object)this.tigerRemoteProxyClient.proxyName(), (Object)convertedMessages.stream().map(RbelElement::getRawStringContent).flatMap(content -> Stream.of(content.split(" ")).skip(1L).limit(1L)).filter(httpHeaderString -> httpHeaderString.startsWith("/")).collect(Collectors.joining(", ")));
        }
    }

    private void downloadAllTrafficFromRemote() {
        PaginationInfo paginationInfo;
        int pageNumber = 0;
        Optional<String> currentLastUuid = Optional.ofNullable(this.tigerRemoteProxyClient.getLastMessageUuid().get());
        int pageSize = this.tigerRemoteProxyClient.getTigerProxyConfiguration().getTrafficDownloadPageSize();
        do {
            paginationInfo = this.downloadTrafficPageFromRemoteAndAddToQueue(pageSize, currentLastUuid);
            currentLastUuid = Optional.ofNullable(paginationInfo.getLastUuid()).filter(StringUtils::isNotEmpty);
            if (++pageNumber <= 100) continue;
            log.warn("Interrupting traffic-download: Reached 100 downloads! (Maybe the influx of traffic on the upstream proxy is greater then our downstream-sped?)");
            return;
        } while (paginationInfo.getAvailableMessages() > pageSize);
    }

    private PaginationInfo downloadTrafficPageFromRemoteAndAddToQueue(int pageSize, Optional<String> currentLastUuid) {
        String downloadUrl = this.getRemoteProxyUrl() + "/webui/trafficLog.tgr";
        log.debug("{}Downloading missed traffic from '{}', starting from {}. page-size {} (currently cached {} messages)", new Object[]{this.tigerRemoteProxyClient.proxyName(), currentLastUuid, downloadUrl, pageSize, this.getRbelMessages().size()});
        HashMap<String, Integer> parameters = new HashMap<String, Integer>();
        parameters.put("pageSize", pageSize);
        currentLastUuid.ifPresent(uuid -> parameters.put("lastMsgUuid", (Integer)uuid));
        HttpResponse response = ((GetRequest)Unirest.get((String)downloadUrl).queryString(parameters)).asString();
        if (response.getStatus() != 200) {
            throw new TigerRemoteProxyClientException("Error while downloading message from remote '" + downloadUrl + "': " + (String)response.getBody());
        }
        this.tigerRemoteProxyClient.getTrafficParserExecutor().submit(() -> this.parseTrafficChunk((String)response.getBody()));
        return PaginationInfo.of((HttpResponse<String>)response);
    }

    private RbelLogger getRbelLogger() {
        return this.tigerRemoteProxyClient.getRbelLogger();
    }

    private List<RbelElement> getRbelMessages() {
        return this.tigerRemoteProxyClient.getRbelMessages();
    }

    private String getRemoteProxyUrl() {
        return this.tigerRemoteProxyClient.getRemoteProxyUrl();
    }

    @ConstructorProperties(value={"tigerRemoteProxyClient"})
    @Generated
    public TigerRemoteTrafficDownloader(TigerRemoteProxyClient tigerRemoteProxyClient) {
        this.tigerRemoteProxyClient = tigerRemoteProxyClient;
    }

    private static class PaginationInfo {
        private final int availableMessages;
        private final String lastUuid;

        public static PaginationInfo of(HttpResponse<String> response) {
            return PaginationInfo.builder().availableMessages(PaginationInfo.convertHeaderFieldToInt(response, "available-messages")).lastUuid(response.getHeaders().getFirst("last-uuid")).build();
        }

        private static Integer convertHeaderFieldToInt(HttpResponse<String> response, String key) {
            return Optional.ofNullable(response.getHeaders().getFirst(key)).filter(StringUtils::isNotEmpty).map(Integer::parseInt).orElse(-1);
        }

        @ConstructorProperties(value={"availableMessages", "lastUuid"})
        @Generated
        PaginationInfo(int availableMessages, String lastUuid) {
            this.availableMessages = availableMessages;
            this.lastUuid = lastUuid;
        }

        @Generated
        public static PaginationInfoBuilder builder() {
            return new PaginationInfoBuilder();
        }

        @Generated
        public int getAvailableMessages() {
            return this.availableMessages;
        }

        @Generated
        public String getLastUuid() {
            return this.lastUuid;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaginationInfo)) {
                return false;
            }
            PaginationInfo other = (PaginationInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAvailableMessages() != other.getAvailableMessages()) {
                return false;
            }
            String this$lastUuid = this.getLastUuid();
            String other$lastUuid = other.getLastUuid();
            return !(this$lastUuid == null ? other$lastUuid != null : !this$lastUuid.equals(other$lastUuid));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof PaginationInfo;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAvailableMessages();
            String $lastUuid = this.getLastUuid();
            result = result * 59 + ($lastUuid == null ? 43 : $lastUuid.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "TigerRemoteTrafficDownloader.PaginationInfo(availableMessages=" + this.getAvailableMessages() + ", lastUuid=" + this.getLastUuid() + ")";
        }

        @Generated
        public static class PaginationInfoBuilder {
            @Generated
            private int availableMessages;
            @Generated
            private String lastUuid;

            @Generated
            PaginationInfoBuilder() {
            }

            @Generated
            public PaginationInfoBuilder availableMessages(int availableMessages) {
                this.availableMessages = availableMessages;
                return this;
            }

            @Generated
            public PaginationInfoBuilder lastUuid(String lastUuid) {
                this.lastUuid = lastUuid;
                return this;
            }

            @Generated
            public PaginationInfo build() {
                return new PaginationInfo(this.availableMessages, this.lastUuid);
            }

            @Generated
            public String toString() {
                return "TigerRemoteTrafficDownloader.PaginationInfo.PaginationInfoBuilder(availableMessages=" + this.availableMessages + ", lastUuid=" + this.lastUuid + ")";
            }
        }
    }
}

