/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.client;

import de.gematik.test.tiger.proxy.client.PartialTracingMessage;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClient;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessagePair;
import java.beans.ConstructorProperties;
import java.lang.reflect.Type;
import lombok.Generated;
import org.springframework.messaging.simp.stomp.StompFrameHandler;
import org.springframework.messaging.simp.stomp.StompHeaders;

class TracingStompHandler
implements StompFrameHandler {
    private final TigerRemoteProxyClient remoteProxyClient;

    public Type getPayloadType(StompHeaders stompHeaders) {
        return TigerTracingDto.class;
    }

    public void handleFrame(StompHeaders stompHeaders, Object frameContent) {
        if (frameContent instanceof TigerTracingDto) {
            TigerTracingDto tigerTracingDto = (TigerTracingDto)frameContent;
            TracingMessagePair messagePair = new TracingMessagePair(this.remoteProxyClient);
            messagePair.setRequest(PartialTracingMessage.builder().tracingDto(tigerTracingDto).receiver(tigerTracingDto.getSender()).sender(tigerTracingDto.getReceiver()).messagePair(messagePair).transmissionTime(tigerTracingDto.getRequestTransmissionTime()).build());
            messagePair.setResponse(PartialTracingMessage.builder().tracingDto(tigerTracingDto).receiver(tigerTracingDto.getReceiver()).sender(tigerTracingDto.getSender()).messagePair(messagePair).transmissionTime(tigerTracingDto.getResponseTransmissionTime()).build());
            this.remoteProxyClient.initOrUpdateMessagePart(tigerTracingDto.getRequestUuid(), messagePair.getRequest());
            this.remoteProxyClient.initOrUpdateMessagePart(tigerTracingDto.getResponseUuid(), messagePair.getResponse());
        }
    }

    @ConstructorProperties(value={"remoteProxyClient"})
    @Generated
    public TracingStompHandler(TigerRemoteProxyClient remoteProxyClient) {
        this.remoteProxyClient = remoteProxyClient;
    }
}

