/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.facet.RbelFacet;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelUriFacet;
import de.gematik.rbellogger.data.facet.RbelUriParameterFacet;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyModificationException;
import java.beans.ConstructorProperties;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.mockserver.mock.action.ExpectationForwardAndResponseCallback;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.model.Parameters;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTigerRouteCallback
implements ExpectationForwardAndResponseCallback {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTigerRouteCallback.class);
    private final TigerProxy tigerProxy;
    private final TigerRoute tigerRoute;
    private final Map<String, ZonedDateTime> requestTimingMap = new HashMap<String, ZonedDateTime>();

    public void applyModifications(HttpRequest request) {
        if (!this.tigerProxy.getModifications().isEmpty()) {
            this.parseMessageAndApplyModifications(request);
        }
    }

    public void parseMessageAndApplyModifications(HttpRequest request) {
        RbelElement requestElement = this.tigerProxy.getRbelLogger().getRbelConverter().convertElement(this.tigerProxy.getMockServerToRbelConverter().requestToRbelMessage(request));
        RbelElement modifiedRequest = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(requestElement);
        if (modifiedRequest == requestElement) {
            return;
        }
        request.withBody(this.extractSafe(modifiedRequest, "$.body").getRawContent());
        for (RbelElement modifiedHeader : modifiedRequest.findRbelPathMembers("$.header.*")) {
            request = request.replaceHeader(Header.header((String)((String)modifiedHeader.getKey().orElseThrow()), (String[])new String[]{modifiedHeader.getRawStringContent()}));
        }
        RbelUriFacet uriFacet = (RbelUriFacet)this.extractSafe(modifiedRequest, "$.path").getFacetOrFail(RbelUriFacet.class);
        request.withPath(uriFacet.getBasicPathString());
        this.clearExistingQueryParameters(request);
        this.addAllQueryParametersFromRbelMessage(request, uriFacet);
        request.withMethod(this.extractSafe(modifiedRequest, "$.method").getRawStringContent());
    }

    private RbelElement extractSafe(RbelElement targetElement, String rbelPath) {
        return (RbelElement)targetElement.findElement(rbelPath).orElseThrow(() -> new TigerProxyModificationException("Unexpected structure: Could not find '" + rbelPath + "'!"));
    }

    private void addAllQueryParametersFromRbelMessage(HttpRequest request, RbelUriFacet uriFacet) {
        for (RbelElement queryElement : uriFacet.getQueryParameters()) {
            RbelUriParameterFacet parameterFacet = (RbelUriParameterFacet)queryElement.getFacetOrFail(RbelUriParameterFacet.class);
            request.withQueryStringParameter(parameterFacet.getKeyAsString(), new String[]{parameterFacet.getValue().getRawStringContent()});
        }
    }

    private void clearExistingQueryParameters(HttpRequest request) {
        Parameters queryStringParameters = request.getQueryStringParameters();
        if (queryStringParameters == null) {
            return;
        }
        queryStringParameters.getEntries().stream().forEach(parameter -> queryStringParameters.remove(parameter.getName()));
    }

    public void applyModifications(HttpResponse response) {
        if (!this.tigerProxy.getModifications().isEmpty()) {
            this.parseMessageAndApplyModifications(response);
        }
    }

    public void parseMessageAndApplyModifications(HttpResponse response) {
        RbelElement responseElement = this.tigerProxy.getRbelLogger().getRbelConverter().convertElement(this.tigerProxy.getMockServerToRbelConverter().responseToRbelMessage(response));
        RbelElement modifiedResponse = this.tigerProxy.getRbelLogger().getRbelModifier().applyModifications(responseElement);
        if (modifiedResponse == responseElement) {
            return;
        }
        response.withBody(this.extractSafe(modifiedResponse, "$.body").getRawContent());
        for (RbelElement modifiedHeader : modifiedResponse.findRbelPathMembers("$.header.*")) {
            response = response.replaceHeader(Header.header((String)((String)modifiedHeader.getKey().orElseThrow()), (String[])new String[]{modifiedHeader.getRawStringContent()}));
        }
        response.withStatusCode(Integer.valueOf(Integer.parseInt(this.extractSafe(modifiedResponse, "$.responseCode").getRawStringContent())));
        String reasonPhrase = this.extractSafe(modifiedResponse, "$.reasonPhrase").getRawStringContent();
        if (!StringUtils.isEmpty((CharSequence)reasonPhrase)) {
            response.withReasonPhrase(reasonPhrase);
        } else {
            response.withReasonPhrase(" ");
        }
    }

    public final HttpRequest handle(HttpRequest req) {
        try {
            this.requestTimingMap.put(req.getLogCorrelationId(), ZonedDateTime.now());
            return this.handleRequest(req);
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of request", (Throwable)e);
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    public void propagateExceptionMessageSafe(Exception exception) {
        try {
            this.tigerProxy.propagateException(exception);
        }
        catch (Exception handlingException) {
            log.warn("While propagating an exception another error occured (ignoring):", (Throwable)handlingException);
        }
    }

    protected abstract HttpRequest handleRequest(HttpRequest var1);

    public final HttpResponse handle(HttpRequest req, HttpResponse resp) {
        try {
            HttpResponse httpResponse = this.handleResponse(req, resp);
            this.requestTimingMap.remove(req);
            return httpResponse;
        }
        catch (RuntimeException e) {
            log.warn("Uncaught exception during handling of response", (Throwable)e);
            this.propagateExceptionMessageSafe(e);
            throw e;
        }
    }

    public HttpResponse handleResponse(HttpRequest req, HttpResponse resp) {
        this.applyModifications(resp);
        if (this.shouldLogTraffic()) {
            try {
                RbelElement request = this.getTigerProxy().getMockServerToRbelConverter().convertRequest(req, this.extractProtocolAndHostForRequest(req));
                RbelElement response = this.getTigerProxy().getMockServerToRbelConverter().convertResponse(resp, this.extractProtocolAndHostForRequest(req), req.getClientAddress());
                Optional.ofNullable(this.getRequestTimingMap().get(req.getLogCorrelationId())).ifPresent(requestTime -> this.addTimingFacet(request, (ZonedDateTime)requestTime));
                this.addTimingFacet(response, ZonedDateTime.now());
                TracingMessagePairFacet pairFacet = TracingMessagePairFacet.builder().response(response).request(request).build();
                request.addFacet((RbelFacet)pairFacet);
                response.addFacet((RbelFacet)pairFacet);
                response.addOrReplaceFacet((RbelFacet)response.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::toBuilder).orElse(RbelHttpResponseFacet.builder()).request(request).build());
                this.getTigerProxy().triggerListener(request);
                this.getTigerProxy().triggerListener(response);
            }
            catch (RuntimeException e) {
                this.propagateExceptionMessageSafe(e);
                log.error("Rbel-parsing failed!", (Throwable)e);
            }
        }
        return resp;
    }

    boolean shouldLogTraffic() {
        return !this.getTigerRoute().isDisableRbelLogging();
    }

    protected abstract String extractProtocolAndHostForRequest(HttpRequest var1);

    private RbelElement addTimingFacet(RbelElement message, ZonedDateTime requestTime) {
        return message.addFacet((RbelFacet)RbelMessageTimingFacet.builder().transmissionTime(requestTime).build());
    }

    @ConstructorProperties(value={"tigerProxy", "tigerRoute"})
    @Generated
    public AbstractTigerRouteCallback(TigerProxy tigerProxy, TigerRoute tigerRoute) {
        this.tigerProxy = tigerProxy;
        this.tigerRoute = tigerRoute;
    }

    @Generated
    public TigerProxy getTigerProxy() {
        return this.tigerProxy;
    }

    @Generated
    public TigerRoute getTigerRoute() {
        return this.tigerRoute;
    }

    @Generated
    public Map<String, ZonedDateTime> getRequestTimingMap() {
        return this.requestTimingMap;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTigerRouteCallback)) {
            return false;
        }
        AbstractTigerRouteCallback other = (AbstractTigerRouteCallback)o;
        if (!other.canEqual(this)) {
            return false;
        }
        TigerProxy this$tigerProxy = this.getTigerProxy();
        TigerProxy other$tigerProxy = other.getTigerProxy();
        if (this$tigerProxy == null ? other$tigerProxy != null : !((Object)this$tigerProxy).equals(other$tigerProxy)) {
            return false;
        }
        TigerRoute this$tigerRoute = this.getTigerRoute();
        TigerRoute other$tigerRoute = other.getTigerRoute();
        if (this$tigerRoute == null ? other$tigerRoute != null : !this$tigerRoute.equals(other$tigerRoute)) {
            return false;
        }
        Map<String, ZonedDateTime> this$requestTimingMap = this.getRequestTimingMap();
        Map<String, ZonedDateTime> other$requestTimingMap = other.getRequestTimingMap();
        return !(this$requestTimingMap == null ? other$requestTimingMap != null : !((Object)this$requestTimingMap).equals(other$requestTimingMap));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTigerRouteCallback;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        TigerProxy $tigerProxy = this.getTigerProxy();
        result = result * 59 + ($tigerProxy == null ? 43 : ((Object)$tigerProxy).hashCode());
        TigerRoute $tigerRoute = this.getTigerRoute();
        result = result * 59 + ($tigerRoute == null ? 43 : $tigerRoute.hashCode());
        Map<String, ZonedDateTime> $requestTimingMap = this.getRequestTimingMap();
        result = result * 59 + ($requestTimingMap == null ? 43 : ((Object)$requestTimingMap).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractTigerRouteCallback(tigerProxy=" + this.getTigerProxy() + ", tigerRoute=" + this.getTigerRoute() + ", requestTimingMap=" + this.getRequestTimingMap() + ")";
    }
}

