/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy;

import de.gematik.rbellogger.RbelLogger;
import de.gematik.rbellogger.configuration.RbelConfiguration;
import de.gematik.rbellogger.configuration.RbelFileSaveInfo;
import de.gematik.rbellogger.converter.RbelConverter;
import de.gematik.rbellogger.converter.RbelConverterPlugin;
import de.gematik.rbellogger.converter.initializers.RbelKeyFolderInitializer;
import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.key.RbelKey;
import de.gematik.rbellogger.util.RbelFileWriterUtils;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerFileSaveInfo;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerProxyConfiguration;
import de.gematik.test.tiger.common.data.config.tigerProxy.TigerRoute;
import de.gematik.test.tiger.common.pki.KeyMgr;
import de.gematik.test.tiger.proxy.IRbelMessageListener;
import de.gematik.test.tiger.proxy.ITigerProxy;
import de.gematik.test.tiger.proxy.exceptions.TigerProxyStartupException;
import de.gematik.test.tiger.proxy.vau.RbelVauSessionListener;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.security.Key;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import kong.unirest.GetRequest;
import kong.unirest.Unirest;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.awaitility.Awaitility;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTigerProxy
implements ITigerProxy {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractTigerProxy.class);
    private static final String FIX_VAU_KEY = "-----BEGIN PRIVATE KEY-----\nMIGIAgEAMBQGByqGSM49AgEGCSskAwMCCAEBBwRtMGsCAQEEIAeOzpSQT8a/mQDM\n7Uxa9NzU++vFhbIFS2Nsw/djM73uoUQDQgAEIfr+3Iuh71R3mVooqXlPhjVd8wXx\n9Yr8iPh+kcZkNTongD49z2cL0wXzuSP5Fb/hGTidhpw1ZYKMib1CIjH59A==\n-----END PRIVATE KEY-----\n";
    private final List<IRbelMessageListener> rbelMessageListeners = new ArrayList<IRbelMessageListener>();
    private final TigerProxyConfiguration tigerProxyConfiguration;
    private RbelLogger rbelLogger;
    private Optional<String> name;

    public AbstractTigerProxy(TigerProxyConfiguration configuration) {
        this(configuration, null);
    }

    public AbstractTigerProxy(TigerProxyConfiguration configuration, @Nullable RbelLogger rbelLogger) {
        this.name = Optional.ofNullable(configuration.getName());
        if (configuration.getTls() == null) {
            throw new TigerProxyStartupException("no TLS-configuration found!");
        }
        this.rbelLogger = rbelLogger == null ? AbstractTigerProxy.buildRbelLoggerConfiguration(configuration).constructRbelLogger() : rbelLogger;
        if (!configuration.isActivateRbelParsing()) {
            this.rbelLogger.getRbelConverter().removeAllConverterPlugins();
        }
        this.addFixVauKey();
        this.tigerProxyConfiguration = configuration;
        if (configuration.getFileSaveInfo() != null && StringUtils.isNotEmpty((CharSequence)configuration.getFileSaveInfo().getSourceFile())) {
            this.readTrafficFromSourceFile(configuration.getFileSaveInfo().getSourceFile());
        }
    }

    protected void readTrafficFromSourceFile(String sourceFile) {
        new Thread(() -> {
            log.info("Trying to read traffic from file '{}'...", (Object)sourceFile);
            try {
                this.rbelLogger.getRbelConverter().addPostConversionListener((msg, conv) -> {
                    if (msg.getParentNode() == null) {
                        this.triggerListener(msg);
                    }
                });
                RbelFileWriterUtils.convertFromRbelFile((String)Files.readString(Path.of(sourceFile, new String[0]), StandardCharsets.UTF_8), (RbelConverter)this.getRbelLogger().getRbelConverter());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            log.info("Successfully read and parsed traffic from file '{}'!", (Object)sourceFile);
        }, "readTrafficFromSourceFile").start();
    }

    private void addFixVauKey() {
        KeyPair keyPair = KeyMgr.readEcdsaKeypairFromPkcs8Pem((byte[])FIX_VAU_KEY.getBytes(StandardCharsets.UTF_8));
        RbelKey rbelPublicVauKey = RbelKey.builder().keyName("fixVauKey_public").key((Key)keyPair.getPublic()).precedence(0).build();
        RbelKey rbelPrivateVauKey = RbelKey.builder().keyName("fixVauKey_public").key((Key)keyPair.getPrivate()).precedence(0).matchingPublicKey(rbelPublicVauKey).build();
        this.rbelLogger.getRbelKeyManager().addKey(rbelPublicVauKey);
        this.rbelLogger.getRbelKeyManager().addKey(rbelPrivateVauKey);
    }

    private static RbelConfiguration buildRbelLoggerConfiguration(TigerProxyConfiguration configuration) {
        RbelConfiguration rbelConfiguration = new RbelConfiguration();
        if (configuration.getKeyFolders() != null) {
            configuration.getKeyFolders().forEach(folder -> rbelConfiguration.addInitializer((Consumer)new RbelKeyFolderInitializer(folder)));
        }
        if (configuration.isActivateVauAnalysis()) {
            rbelConfiguration.addPostConversionListener((RbelConverterPlugin)new RbelVauSessionListener());
        }
        rbelConfiguration.setFileSaveInfo((RbelFileSaveInfo)Optional.ofNullable(configuration.getFileSaveInfo()).map(TigerFileSaveInfo::toRbelFileSaveInfo).orElse(null));
        rbelConfiguration.setActivateAsn1Parsing(configuration.isActivateAsn1Parsing());
        rbelConfiguration.setRbelBufferSizeInMb(configuration.getRbelBufferSizeInMb());
        rbelConfiguration.setManageBuffer(true);
        return rbelConfiguration;
    }

    @Override
    public List<RbelElement> getRbelMessages() {
        return this.rbelLogger.getMessageHistory();
    }

    @Override
    public void addKey(String keyid, Key key) {
        this.rbelLogger.getRbelKeyManager().addKey(keyid, key, 110);
    }

    public void triggerListener(RbelElement element) {
        this.getRbelMessageListeners().forEach(listener -> listener.triggerNewReceivedMessage(element));
    }

    @Override
    public void addRbelMessageListener(IRbelMessageListener listener) {
        this.rbelMessageListeners.add(listener);
    }

    @Override
    public void clearAllRoutes() {
        this.getRoutes().stream().filter(route -> !route.isInternalRoute()).map(TigerRoute::getId).forEach(this::removeRoute);
    }

    @Override
    public void removeRbelMessageListener(IRbelMessageListener listener) {
        this.rbelMessageListeners.remove(listener);
    }

    protected void waitForRemoteTigerProxyToBeOnline(String url) {
        Awaitility.await().atMost((long)this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds() * 20L, TimeUnit.SECONDS).pollInterval(500L, TimeUnit.MILLISECONDS).until(() -> {
            try {
                log.debug("Waiting for tiger-proxy at '{}' to be online...", (Object)url);
                ((GetRequest)Unirest.get((String)url).connectTimeout(this.getTigerProxyConfiguration().getConnectionTimeoutInSeconds() * 1000)).asEmpty();
                return true;
            }
            catch (RuntimeException e) {
                return false;
            }
        });
    }

    public String proxyName() {
        return this.name.map(s -> s + ": ").orElse("");
    }

    @Generated
    public List<IRbelMessageListener> getRbelMessageListeners() {
        return this.rbelMessageListeners;
    }

    @Generated
    public TigerProxyConfiguration getTigerProxyConfiguration() {
        return this.tigerProxyConfiguration;
    }

    @Generated
    public RbelLogger getRbelLogger() {
        return this.rbelLogger;
    }

    @Generated
    public Optional<String> getName() {
        return this.name;
    }

    @Generated
    public void setRbelLogger(RbelLogger rbelLogger) {
        this.rbelLogger = rbelLogger;
    }

    @Generated
    public void setName(Optional<String> name) {
        this.name = name;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AbstractTigerProxy)) {
            return false;
        }
        AbstractTigerProxy other = (AbstractTigerProxy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<IRbelMessageListener> this$rbelMessageListeners = this.getRbelMessageListeners();
        List<IRbelMessageListener> other$rbelMessageListeners = other.getRbelMessageListeners();
        if (this$rbelMessageListeners == null ? other$rbelMessageListeners != null : !((Object)this$rbelMessageListeners).equals(other$rbelMessageListeners)) {
            return false;
        }
        TigerProxyConfiguration this$tigerProxyConfiguration = this.getTigerProxyConfiguration();
        TigerProxyConfiguration other$tigerProxyConfiguration = other.getTigerProxyConfiguration();
        if (this$tigerProxyConfiguration == null ? other$tigerProxyConfiguration != null : !this$tigerProxyConfiguration.equals(other$tigerProxyConfiguration)) {
            return false;
        }
        RbelLogger this$rbelLogger = this.getRbelLogger();
        RbelLogger other$rbelLogger = other.getRbelLogger();
        if (this$rbelLogger == null ? other$rbelLogger != null : !this$rbelLogger.equals(other$rbelLogger)) {
            return false;
        }
        Optional<String> this$name = this.getName();
        Optional<String> other$name = other.getName();
        return !(this$name == null ? other$name != null : !((Object)this$name).equals(other$name));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AbstractTigerProxy;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<IRbelMessageListener> $rbelMessageListeners = this.getRbelMessageListeners();
        result = result * 59 + ($rbelMessageListeners == null ? 43 : ((Object)$rbelMessageListeners).hashCode());
        TigerProxyConfiguration $tigerProxyConfiguration = this.getTigerProxyConfiguration();
        result = result * 59 + ($tigerProxyConfiguration == null ? 43 : $tigerProxyConfiguration.hashCode());
        RbelLogger $rbelLogger = this.getRbelLogger();
        result = result * 59 + ($rbelLogger == null ? 43 : $rbelLogger.hashCode());
        Optional<String> $name = this.getName();
        result = result * 59 + ($name == null ? 43 : ((Object)$name).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "AbstractTigerProxy(rbelMessageListeners=" + this.getRbelMessageListeners() + ", tigerProxyConfiguration=" + this.getTigerProxyConfiguration() + ", rbelLogger=" + this.getRbelLogger() + ", name=" + this.getName() + ")";
    }
}

