/*
 * Decompiled with CFR 0.152.
 */
package de.gematik.test.tiger.proxy.tracing;

import de.gematik.rbellogger.data.RbelElement;
import de.gematik.rbellogger.data.RbelHostname;
import de.gematik.rbellogger.data.facet.RbelHttpResponseFacet;
import de.gematik.rbellogger.data.facet.RbelMessageTimingFacet;
import de.gematik.rbellogger.data.facet.RbelTcpIpMessageFacet;
import de.gematik.test.tiger.proxy.TigerProxy;
import de.gematik.test.tiger.proxy.client.TigerExceptionDto;
import de.gematik.test.tiger.proxy.client.TigerRemoteProxyClientException;
import de.gematik.test.tiger.proxy.client.TigerTracingDto;
import de.gematik.test.tiger.proxy.client.TracingMessagePart;
import de.gematik.test.tiger.proxy.data.TracingMessagePairFacet;
import java.beans.ConstructorProperties;
import java.util.Arrays;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.messaging.simp.SimpMessagingTemplate;
import org.springframework.stereotype.Service;

@Service
public class TracingPushController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TracingPushController.class);
    public static final int MAX_MESSAGE_SIZE = 524288;
    public final SimpMessagingTemplate template;
    public final TigerProxy tigerProxy;

    @PostConstruct
    public void addWebSocketListener() {
        this.tigerProxy.addRbelMessageListener(this::propagateRbelMessageSafe);
        this.tigerProxy.addNewExceptionConsumer(this::propagateExceptionSafe);
    }

    private void propagateExceptionSafe(Throwable exc) {
        try {
            this.propagateException(exc);
        }
        catch (RuntimeException e) {
            log.error("Error while propagating Exception", (Throwable)e);
            throw e;
        }
    }

    private void propagateRbelMessageSafe(RbelElement msg) {
        try {
            this.propagateRbelMessage(msg);
        }
        catch (RuntimeException e) {
            log.error("Error while propagating new Rbel-Message", (Throwable)e);
            throw e;
        }
    }

    private void propagateRbelMessage(RbelElement msg) {
        if (!msg.hasFacet(RbelTcpIpMessageFacet.class)) {
            log.trace("Skipping propagation, not a TCP/IP message {}", (Object)msg.getUuid());
            return;
        }
        if (!msg.hasFacet(RbelHttpResponseFacet.class) && !msg.hasFacet(TracingMessagePairFacet.class)) {
            log.trace("Skipping propagation, not a response (facets: {}, uuid: {})", (Object)msg.getFacets().stream().map(Object::getClass).map(Class::getSimpleName).collect(Collectors.joining(", ")), (Object)msg.getUuid());
            return;
        }
        RbelTcpIpMessageFacet rbelTcpIpMessageFacet = (RbelTcpIpMessageFacet)msg.getFacetOrFail(RbelTcpIpMessageFacet.class);
        RbelHostname sender = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getSender().getRawStringContent()).orElse(null);
        RbelHostname receiver = RbelHostname.fromString((String)rbelTcpIpMessageFacet.getReceiver().getRawStringContent()).orElse(null);
        RbelElement request = msg.getFacet(TracingMessagePairFacet.class).map(TracingMessagePairFacet::getRequest).or(() -> msg.getFacet(RbelHttpResponseFacet.class).map(RbelHttpResponseFacet::getRequest)).orElseThrow(() -> new TigerRemoteProxyClientException("Failure to correctly push message with id '" + msg.getUuid() + "': Unable to find matching request"));
        log.trace("{}Propagating new request/response pair (IDs: {} and {})", new Object[]{this.tigerProxy.proxyName(), request.getUuid(), msg.getUuid()});
        this.template.convertAndSend((Object)"/topic/traces", (Object)TigerTracingDto.builder().receiver(receiver).sender(sender).responseUuid(msg.getUuid()).requestUuid(request.getUuid()).responseTransmissionTime(msg.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).requestTransmissionTime(request.getFacet(RbelMessageTimingFacet.class).map(RbelMessageTimingFacet::getTransmissionTime).orElse(null)).build());
        this.mapRbelMessageAndSent(msg);
        this.mapRbelMessageAndSent(request);
    }

    private void propagateException(Throwable exception) {
        this.template.convertAndSend((Object)"/topic/errors", (Object)TigerExceptionDto.builder().className(exception.getClass().getName()).message(exception.getMessage()).stacktrace(ExceptionUtils.getStackTrace((Throwable)exception)).build());
    }

    private void mapRbelMessageAndSent(RbelElement rbelHttpMessage) {
        if (rbelHttpMessage == null) {
            return;
        }
        int numberOfParts = rbelHttpMessage.getRawContent().length / 524288 + 1;
        for (int i = 0; i < numberOfParts; ++i) {
            byte[] partContent = Arrays.copyOfRange(rbelHttpMessage.getRawContent(), i * 524288, Math.min((i + 1) * 524288, rbelHttpMessage.getRawContent().length));
            log.trace("Sending part {} of {} for UUID {}...", new Object[]{i, numberOfParts, rbelHttpMessage.getUuid()});
            this.template.convertAndSend((Object)"/topic/data", (Object)TracingMessagePart.builder().data(partContent).index(i).uuid(rbelHttpMessage.getUuid()).numberOfMessages(numberOfParts).build());
        }
    }

    @ConstructorProperties(value={"template", "tigerProxy"})
    @Generated
    public TracingPushController(SimpMessagingTemplate template, TigerProxy tigerProxy) {
        this.template = template;
        this.tigerProxy = tigerProxy;
    }
}

